/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import hep.analysis.NamedObject;
import jas.hist.FitListener;
import jas.hist.FitUpdate;
import jas.hist.Fitter;
import jas.hist.JASHist;
import jas.hist.XMLHistBuilder;
import jas.jds.interfaces.JavaDataServer;
import jas.jds.module.LocalDIM2;
import jas.job.JobFolder;
import jas.loader.ClassPath;
import jas.loader.ClassPathLoader;
import jas.plugin.IExtensionPlugin;
import jas.plugin.IPluginInfo;
import jas.swingstudio.AboutBox;
import jas.swingstudio.AllSupportedFileFilter;
import jas.swingstudio.ChangableContainer;
import jas.swingstudio.ConnectFailed;
import jas.swingstudio.ConnectPage;
import jas.swingstudio.FileError;
import jas.swingstudio.HTMLPage;
import jas.swingstudio.JASCommandProcessor;
import jas.swingstudio.JASConsoleTabbedPane;
import jas.swingstudio.JASException;
import jas.swingstudio.JASFileFilter;
import jas.swingstudio.JASJob;
import jas.swingstudio.JASJobAdaptor;
import jas.swingstudio.JASLeftRightSplitPane;
import jas.swingstudio.JASLocalJobBuilder;
import jas.swingstudio.JASOptionsDialog;
import jas.swingstudio.JASPage;
import jas.swingstudio.JASPluginContext;
import jas.swingstudio.JASRegistry;
import jas.swingstudio.JASRegistryDialog;
import jas.swingstudio.JASSecurityManager;
import jas.swingstudio.JASToolbarHolder;
import jas.swingstudio.JASTopBottomSplitPane;
import jas.swingstudio.JASTree;
import jas.swingstudio.JASWindowManager;
import jas.swingstudio.LocalJob;
import jas.swingstudio.NewJobPage;
import jas.swingstudio.NewProgramPage;
import jas.swingstudio.NotImplemented;
import jas.swingstudio.ProgramPage;
import jas.swingstudio.StatusBar;
import jas.swingstudio.StoppableExecution;
import jas.swingstudio.StoppableExecutionMonitor;
import jas.swingstudio.WebPageDialog;
import jas.swingstudio.WindowItem;
import jas.swingstudio.WindowManager;
import jas.util.Application;
import jas.util.CommandProcessor;
import jas.util.CommandSource;
import jas.util.CommandTarget;
import jas.util.FileTypeFileFilter;
import jas.util.GetOptions;
import jas.util.JASCheckboxState;
import jas.util.JASIcon;
import jas.util.JASState;
import jas.util.JASWizard;
import jas.util.NestedException;
import jas.util.SimpleCommandTarget;
import jas.util.SplashScreen;
import jas.util.UserProperties;
import jas.util.pluginmanager.JASVersion;
import jas.util.pluginmanager.PluginManager;
import jas.util.xml.XMLWriter;
import jas.util.xmlmenus.XMLMenuBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BoundedRangeModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;

public final class JavaAnalysisStudio
extends Application {
    private static int makeCount = 0;
    private ClassPathLoader m_extensionLoader;
    private CommandProcessor m_currentSelection;
    private JASConsoleTabbedPane m_JASConsoleTabbedPane;
    private WindowManager m_windowManager;
    private JMenuBar m_disconnectedMenuBar;
    private JASJob m_job = null;
    private JTree m_tree;
    private JASTopBottomSplitPane m_topBottomSplitPane;
    private JASLeftRightSplitPane m_leftRightSplitPane;
    private static JavaAnalysisStudio theApp;
    private JASToolbarHolder m_toolbarHolder;
    private JTabbedPane m_controlPane;
    private StatusBar m_status;
    private boolean m_statusBarVisible;
    private UserProperties userProp = this.getUserProperties();
    private int nPages = 0;
    private String[] m_lastJobs;
    private String[] m_lastFiles;
    private JASCommand m_jasCommand;
    private JASStoppableManager m_stopMan = new JASStoppableManager();
    private URL m_homePage;
    private boolean m_noTopBottomSplitPane = true;
    private String menuFile = "menus.xml";
    private PluginManager pluginmanager;
    final String m_lastJobPath_Key = "LastJobPath";
    private static final String m_WindowsLAF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String m_MotifLAF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String m_JavaLAF = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String m_TabbedWM = "jas.swingstudio.JASWindowManager";
    private static final String m_InternalWM = "jas.swingstudio.InternalFramesWindowManager";
    private static final String versionURL = "http://jas.freehep.org/version.asp";
    static final boolean jobSavingDisabled = true;
    static final long checkWord = 3457768635619245585L;
    static final String[][] knownDebugFlags;
    private XMLMenuBuilder xmb;
    static /* synthetic */ Class class$jas$swingstudio$JavaAnalysisStudio;
    static /* synthetic */ Class class$jas$util$JASMenuItem;
    static /* synthetic */ Class class$jas$util$JASRadioMenuItem;
    static /* synthetic */ Class class$jas$util$JASCheckboxMenuItem;
    static /* synthetic */ Class class$jas$util$JASToolBarButton;
    static /* synthetic */ Class class$jas$swingstudio$SwingStudioIcon;
    static /* synthetic */ Class class$jas$util$OnScreenPopupMenu;
    static /* synthetic */ Class class$jas$swingstudio$JASPage;
    static /* synthetic */ Class class$jas$swingstudio$HTMLPage;

    protected void doHelp() {
        System.out.println();
        System.out.println(this.getVersionName());
        System.out.println();
        super.doHelp();
        System.out.println();
        System.out.println("Parameters:");
        System.out.println("\tp1 - A job file to read at startup");
        System.out.println();
        System.out.println("Known debug flags:");
        int n = 0;
        while (n < knownDebugFlags.length) {
            System.out.println("\t" + this.pad(knownDebugFlags[n][0], 19) + " " + knownDebugFlags[n][1]);
            ++n;
        }
    }

    private String pad(String string, int n) {
        String string2 = "                                                       ";
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 < n) {
            return string + string2.substring(0, n - n2);
        }
        return string.substring(n);
    }

    protected void setDebugFlag(String string) {
        if (string.equals("all")) {
            int n = 0;
            while (n < knownDebugFlags.length) {
                super.setDebugFlag(knownDebugFlags[n][0]);
                ++n;
            }
        }
        super.setDebugFlag(string);
    }

    JavaAnalysisStudio(String[] stringArray) throws Exception {
        theApp = this;
        GetOptions getOptions = this.getGetOptions();
        getOptions.addOption("nosplash", 'n', true, "Suppress the splash screen");
        getOptions.addOption("startPage", 's', false, "URL for the welcome page");
        getOptions.addOption("connect", 'c', false, "Reconnect to server/job at startup");
        getOptions.addOption("extdir", 'e', false, "Directory to search for extensions");
        getOptions.addOption("menus", 'm', false, "Path of an alternate XML file to read the menus from");
        getOptions.addOption("noversion", 'v', true, "Do not perform application version check on start up");
        int n = this.parseArgs(stringArray);
        if (n > 1) {
            throw new GetOptions.BadArguments("Java Analysis Studio takes only one argument");
        }
        if (getOptions.hasOption("extdir")) {
            ((Hashtable)System.getProperties()).put("jas.user.extensions", getOptions.getOption("extdir"));
        }
        if (getOptions.hasOption("menus")) {
            this.menuFile = getOptions.getOption("menus");
        }
        if (getOptions.hasOption("startPage")) {
            String string = getOptions.getOption("startPage");
            try {
                this.m_homePage = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new NestedException("Invalid URL specified for startPage: " + string, malformedURLException);
            }
        } else {
            this.m_homePage = this.getClass().getResource("html/Welcome.html");
        }
        boolean bl = !getOptions.hasOption("nosplash") && this.userProp.getBoolean("showSplash", true);
        SplashScreen splashScreen = new SplashScreen(JASIcon.create(class$jas$swingstudio$JavaAnalysisStudio == null ? (class$jas$swingstudio$JavaAnalysisStudio = JavaAnalysisStudio.class$("jas.swingstudio.JavaAnalysisStudio")) : class$jas$swingstudio$JavaAnalysisStudio, "images/Splash.jpg"), "Initializing...", this.getVersionName());
        try {
            if (bl) {
                splashScreen.setVisible(true);
            }
            if (n == 0) {
                this.init(null, splashScreen);
            } else {
                this.init(getOptions.getParams()[0], splashScreen);
            }
            Object var7_8 = null;
            splashScreen.close();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            splashScreen.close();
            throw throwable;
        }
    }

    public void hideJASConsole() {
        this.m_topBottomSplitPane.saveState();
        this.remove(this.m_topBottomSplitPane);
        this.m_noTopBottomSplitPane = true;
        this.add("Center", this.m_leftRightSplitPane);
        this.validate();
        this.repaint();
    }

    public void showJASConsole() {
        this.remove(this.m_leftRightSplitPane);
        if (this.m_noTopBottomSplitPane) {
            this.makeNewTopBottomSplitPane();
            this.m_noTopBottomSplitPane = false;
        }
        this.validate();
        this.m_topBottomSplitPane.restoreState();
        this.repaint();
    }

    private void makeNewTopBottomSplitPane() {
        this.m_topBottomSplitPane = new JASTopBottomSplitPane(false, (Component)this.m_leftRightSplitPane, (Component)this.m_JASConsoleTabbedPane);
        this.m_topBottomSplitPane.setOneTouchExpandable(true);
        this.add("Center", this.m_topBottomSplitPane);
    }

    private void init(String string, SplashScreen splashScreen) throws Exception {
        boolean bl;
        Object object;
        splashScreen.showStatus("Setting Look and Feel...", 10);
        String string2 = this.userProp.getString("LookAndFeel", null);
        if (string2 == null) {
            string2 = UIManager.getSystemLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        splashScreen.showStatus("Configuring menus...", 20);
        this.xmb = new XMLMenuBuilder(new InputStreamReader(this.getClass().getResourceAsStream(this.menuFile)), this.menuFile);
        this.xmb.setDefaultMenuItemClass(class$jas$util$JASMenuItem == null ? (class$jas$util$JASMenuItem = JavaAnalysisStudio.class$("jas.util.JASMenuItem")) : class$jas$util$JASMenuItem);
        this.xmb.setDefaultRadioMenuItemClass(class$jas$util$JASRadioMenuItem == null ? (class$jas$util$JASRadioMenuItem = JavaAnalysisStudio.class$("jas.util.JASRadioMenuItem")) : class$jas$util$JASRadioMenuItem);
        this.xmb.setDefaultCheckboxMenuItemClass(class$jas$util$JASCheckboxMenuItem == null ? (class$jas$util$JASCheckboxMenuItem = JavaAnalysisStudio.class$("jas.util.JASCheckboxMenuItem")) : class$jas$util$JASCheckboxMenuItem);
        this.xmb.setDefaultPopupMenuItemClass(class$jas$util$JASMenuItem == null ? (class$jas$util$JASMenuItem = JavaAnalysisStudio.class$("jas.util.JASMenuItem")) : class$jas$util$JASMenuItem);
        this.xmb.setDefaultPopupRadioMenuItemClass(class$jas$util$JASRadioMenuItem == null ? (class$jas$util$JASRadioMenuItem = JavaAnalysisStudio.class$("jas.util.JASRadioMenuItem")) : class$jas$util$JASRadioMenuItem);
        this.xmb.setDefaultPopupCheckboxMenuItemClass(class$jas$util$JASCheckboxMenuItem == null ? (class$jas$util$JASCheckboxMenuItem = JavaAnalysisStudio.class$("jas.util.JASCheckboxMenuItem")) : class$jas$util$JASCheckboxMenuItem);
        this.xmb.setDefaultToolBarItemClass(class$jas$util$JASToolBarButton == null ? (class$jas$util$JASToolBarButton = JavaAnalysisStudio.class$("jas.util.JASToolBarButton")) : class$jas$util$JASToolBarButton);
        this.xmb.setDefaultImageIconClass(class$jas$swingstudio$SwingStudioIcon == null ? (class$jas$swingstudio$SwingStudioIcon = JavaAnalysisStudio.class$("jas.swingstudio.SwingStudioIcon")) : class$jas$swingstudio$SwingStudioIcon);
        this.xmb.setDefaultPopupMenuClass(class$jas$util$OnScreenPopupMenu == null ? (class$jas$util$OnScreenPopupMenu = JavaAnalysisStudio.class$("jas.util.OnScreenPopupMenu")) : class$jas$util$OnScreenPopupMenu);
        this.m_JASConsoleTabbedPane = new JASConsoleTabbedPane(3);
        this.m_disconnectedMenuBar = this.xmb.getMenuBar("mainMenu");
        splashScreen.showStatus("Loading extensions...", 30);
        this.loadExtensions();
        splashScreen.showStatus("Setting User Preferences...", 40);
        JASHist.addFitListener(new JASFitListener());
        String string3 = this.userProp.getString("WindowManager", m_TabbedWM);
        try {
            object = Class.forName(string3);
            this.m_windowManager = (WindowManager)((Class)object).newInstance();
        }
        catch (Exception exception) {
            this.m_windowManager = new JASWindowManager();
            this.userProp.setString("WindowManager", this.m_windowManager.getClass().getName());
        }
        this.addHelpLocation(ClassLoader.getSystemResource("JasHelp.hs"));
        object = JavaAnalysisStudio.getVersionNumber();
        this.addHelpLocation("http://jas.freehep.org/help/" + (String)object + "/JasHelp.hs");
        object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
        this.addHelpLocation("http://jas.freehep.org/help/" + (String)object + "/JasHelp.hs");
        splashScreen.showStatus("Building UI...", 50);
        this.m_jasCommand = new JASCommand();
        this.getCommandManager().add(this.m_jasCommand);
        this.m_tree = new JASTree();
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setEditable(true);
        this.m_tree.setShowsRootHandles(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setMinimumSize(new Dimension(20, 20));
        jScrollPane.setPreferredSize(new Dimension(150, 4000));
        jScrollPane.setViewportView(this.m_tree);
        this.m_controlPane = new JTabbedPane();
        this.m_controlPane.setTabPlacement(3);
        this.m_controlPane.addTab("JAS", jScrollPane);
        this.m_leftRightSplitPane = new JASLeftRightSplitPane(false, (Component)this.m_controlPane, (Component)((Object)this.m_windowManager));
        this.m_leftRightSplitPane.restoreState();
        this.m_JASConsoleTabbedPane.setMinimumSize(new Dimension(0, 0));
        this.m_JASConsoleTabbedPane.setPreferredSize(new Dimension(0, 0));
        this.add("Center", this.m_leftRightSplitPane);
        DoubleClickAdaptor doubleClickAdaptor = new DoubleClickAdaptor();
        this.m_tree.addMouseListener(doubleClickAdaptor);
        this.getCommandManager().add(doubleClickAdaptor);
        SelectAdaptor selectAdaptor = new SelectAdaptor();
        this.m_tree.addTreeSelectionListener(selectAdaptor);
        this.getCommandManager().add(selectAdaptor);
        this.m_toolbarHolder = new JASToolbarHolder(this.xmb);
        this.add("North", this.m_toolbarHolder);
        this.m_status = new StatusBar();
        this.setStatusBarVisible(this.userProp.getBoolean("StatusBarVisible", true));
        this.m_lastJobs = this.userProp.getStringArray("LastJobs", null);
        this.m_lastFiles = this.userProp.getStringArray("LastFiles", null);
        ToolTipManager.sharedInstance().setEnabled(this.userProp.getBoolean("EnableToolTips", true));
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Java Analysis Studio");
        ((Frame)jFrame).setIconImage(JASIcon.create(this, "images/histogram.gif").getImage());
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)this, "Center");
        jFrame.getContentPane().add((Component)this.getMenuBar(), "North");
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new AppCloser());
        splashScreen.showStatus("Activating menus...", 60);
        this.getCommandManager().start();
        if (!this.m_noTopBottomSplitPane) {
            this.m_topBottomSplitPane.restoreState();
        }
        this.setToEmptyJob();
        if (string == null && this.userProp.getBoolean("OpenLastJobAtStartup", false) && this.m_lastJobs != null && this.m_lastJobs.length > 0) {
            string = this.m_lastJobs[0];
        }
        final String string4 = string;
        final GetOptions getOptions = this.getGetOptions();
        boolean bl2 = bl = getOptions.hasOption("connect") || string != null;
        if (!bl) {
            splashScreen.showStatus("Loading welcome page...", 70);
            this.m_windowManager.newWindow("Welcome", new HTMLPage(this.m_homePage));
        }
        splashScreen.close();
        ((Component)jFrame).setBounds(this.userProp.getRectangle("Window", new Rectangle(10, 10, 450, 450)));
        jFrame.show();
        if (!getOptions.hasOption("noversion")) {
            JASVersion jASVersion;
            int n;
            if (this.userProp.getBoolean("AskUpdateOnStart", true)) {
                this.userProp.setBoolean("AskUpdateOnStart", false);
                JASVersion jASVersion2 = new JASVersion(this.getFrame(), "JAS", versionURL, JavaAnalysisStudio.getVersionNumber(), this.userProp);
                jASVersion2.showOptionsDialog();
            } else if (this.userProp.getBoolean("UpdateOnStart", false) && (n = (jASVersion = new JASVersion(this.getFrame(), "JAS", versionURL, JavaAnalysisStudio.getVersionNumber(), this.userProp)).testCurrentVersion()) == 1) {
                jASVersion.showUpdateDialog(jFrame, true, true);
            }
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (getOptions.hasOption("connect")) {
                        String string = getOptions.getOption("connect");
                        try {
                            JavaAnalysisStudio.this.reconnect(string);
                        }
                        catch (Throwable throwable) {
                            JavaAnalysisStudio.this.error("Could not connect to " + string, throwable);
                        }
                    } else if (string4 != null) {
                        try {
                            JavaAnalysisStudio.this.readJob(new File(string4));
                        }
                        catch (Throwable throwable) {
                            JavaAnalysisStudio.this.error("Could not open job " + string4, throwable);
                        }
                    }
                    JavaAnalysisStudio.this.m_windowManager.newWindow("Welcome", new HTMLPage(JavaAnalysisStudio.this.m_homePage));
                }
            });
        }
    }

    String getUserExtensionsDir() {
        return this.resolveSymbols(System.getProperty("jas.user.extensions", "{user.home}/JASExtensions"));
    }

    String getGroupExtensionsDir() {
        return this.resolveSymbols(System.getProperty("jas.group.extensions"));
    }

    String getSystemExtensionsDir() {
        return this.resolveSymbols(System.getProperty("jas.system.extensions", "{java.home}/JASExtensions"));
    }

    private void loadExtensions() {
        boolean bl = System.getProperty("debugExtensions") != null;
        ClassPath classPath = new ClassPath();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        String[] stringArray = new String[]{this.getUserExtensionsDir(), this.getGroupExtensionsDir(), this.getSystemExtensionsDir()};
        this.scanExtensionDirectories(stringArray, classPath, vector, vector2, bl);
        this.m_extensionLoader = new ClassPathLoader(classPath, "ExtensionLoader");
        JASPluginContext jASPluginContext = new JASPluginContext(this);
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        this.pluginmanager = new PluginManager(this.getSystemExtensionsDir(), this.getUserExtensionsDir());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            File file = (File)enumeration2.nextElement();
            String string2 = file.getParent();
            String string3 = file.getName();
            try {
                if (bl) {
                    System.out.println("Loading extension: " + string);
                }
                Class clazz = this.m_extensionLoader.loadClass(string, true);
                IExtensionPlugin iExtensionPlugin = (IExtensionPlugin)clazz.newInstance();
                iExtensionPlugin.setPluginContext(jASPluginContext);
                if (iExtensionPlugin instanceof IPluginInfo) {
                    this.pluginmanager.setPluginLoadedAtStart(((IPluginInfo)((Object)iExtensionPlugin)).getName(), ((IPluginInfo)((Object)iExtensionPlugin)).getVersion(), string2, string3);
                    continue;
                }
                this.pluginmanager.setPluginLoadedAtStart(string3, "unknown", string2, string3);
            }
            catch (Throwable throwable) {
                System.err.println("Unable to load plugin " + string);
                throwable.printStackTrace();
            }
        }
    }

    private void scanExtensionDirectories(String[] stringArray, ClassPath classPath, Vector vector, Vector vector2, boolean bl) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                File file = new File(stringArray[n]);
                if (bl) {
                    System.out.println("Seaching for extensions in: " + file);
                }
                if (file.isDirectory()) {
                    this.scanExtensionDirectory(file, classPath, vector, vector2, bl);
                }
            }
            ++n;
        }
    }

    private String resolveSymbols(String string) {
        if (string == null) {
            return null;
        }
        while (true) {
            String string2;
            int n = string.indexOf(123);
            int n2 = string.indexOf(125);
            if (n < 0 || n2 < 0 || n2 - n < 2) break;
            StringBuffer stringBuffer = new StringBuffer();
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            if ((string2 = System.getProperty(string.substring(n + 1, n2 - n))) != null) {
                stringBuffer.append(string2);
            }
            if (n2 + 1 < string.length()) {
                stringBuffer.append(string.substring(n2 + 1));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private void scanExtensionDirectory(File file, ClassPath classPath, Vector vector, Vector vector2, boolean bl) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(".jar")) {
                File file2 = new File(file, stringArray[n]);
                if (file2.length() > 0L) {
                    try {
                        ZipFile zipFile = new ZipFile(file2);
                        ZipEntry zipEntry = zipFile.getEntry("JAS-inf/plugins.txt");
                        if (zipEntry != null) {
                            String string;
                            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(zipFile.getInputStream(zipEntry)));
                            while ((string = lineNumberReader.readLine()) != null) {
                                if (vector.indexOf(string) >= 0) continue;
                                vector.addElement(string);
                                vector2.addElement(file2);
                            }
                            lineNumberReader.close();
                        }
                        if (bl) {
                            System.out.println("\tFound: " + stringArray[n]);
                        }
                        classPath.add(zipFile);
                    }
                    catch (IOException iOException) {
                        System.err.println("Extension jar file " + stringArray[n] + " could not be loaded" + iOException);
                    }
                } else {
                    boolean bl2 = file2.delete();
                }
            }
            ++n;
        }
    }

    private void reconnect(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() != 2) {
            throw new ConnectException("Invalid connect option " + string);
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        JavaDataServer javaDataServer = JASJobAdaptor.connectToServer(string2, null, 0);
        JASJob jASJob = new JASJob(string3);
        JASJobAdaptor jASJobAdaptor = new JASJobAdaptor(jASJob, string3, javaDataServer);
        jASJob.setJob(jASJobAdaptor);
        this.setJob(jASJob, true);
        jASJobAdaptor.listItems();
    }

    public JASPage getCurrentPage() {
        try {
            Component component = this.m_windowManager.getWindow(this.m_windowManager.getSelectedWindow());
            return (JASPage)component;
        }
        catch (Exception exception) {
            return null;
        }
    }

    JTabbedPane getControlPane() {
        return this.m_controlPane;
    }

    JTabbedPane getConsolePane() {
        return this.m_JASConsoleTabbedPane;
    }

    JASPage newPage(int n, int n2) {
        ++this.nPages;
        JASPage jASPage = new JASPage(n, n2);
        this.m_windowManager.newWindow("Page " + this.nPages, jASPage);
        return jASPage;
    }

    void setNPages(int n) {
        this.nPages = n;
    }

    private void setStatusBarVisible(boolean bl) {
        this.m_statusBarVisible = bl;
        if (bl) {
            this.add("South", this.m_status);
        } else {
            this.remove(this.m_status);
        }
        this.revalidate();
    }

    JMenuBar getMenuBar() {
        return this.m_disconnectedMenuBar;
    }

    JASJob getJob() {
        return this.m_job;
    }

    ClassPathLoader getExtensionLoader() {
        return this.m_extensionLoader;
    }

    public static String getVersionNumber() {
        return "2.2.1";
    }

    String getVersionName() {
        return "Java Analysis Studio - " + JavaAnalysisStudio.getVersionNumber() + " (27 August 2000)";
    }

    public static void main(String[] stringArray) {
        try {
            try {
                Class<?> clazz = Class.forName("java.security.Permission");
                System.setSecurityManager((SecurityManager)Class.forName("jas.swingstudio.JASSecurityManager2").newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.setSecurityManager(new JASSecurityManager());
            }
            theApp = new JavaAnalysisStudio(stringArray);
        }
        catch (Throwable throwable) {
            System.err.println("Java Analysis Studio Failed to Initialize");
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    void openLastJob() {
        if (this.m_lastJobs == null || this.m_lastJobs.length == 0) {
            this.error("There is no last job to open.");
            return;
        }
        try {
            this.readJob(new File(this.m_lastJobs[0]));
        }
        catch (Throwable throwable) {
            this.error("Could not open last job", throwable);
        }
    }

    public static JavaAnalysisStudio getApp() {
        return theApp;
    }

    public TreeModel getTreeModel() {
        return this.m_tree.getModel();
    }

    void setCurrentSelection(CommandProcessor commandProcessor) {
        if (this.m_currentSelection != null) {
            this.getCommandManager().remove(this.m_currentSelection);
        }
        this.m_currentSelection = commandProcessor;
        if (this.m_currentSelection != null) {
            this.getCommandManager().add(this.m_currentSelection);
        }
    }

    public void setMessage(String string) {
        this.m_status.setMessage(string);
    }

    void setRebinModel(BoundedRangeModel boundedRangeModel, BoundedRangeModel boundedRangeModel2) {
        this.m_toolbarHolder.setRebinModel(boundedRangeModel, boundedRangeModel2);
    }

    OutputStream getOutputStream(String string) {
        return this.m_JASConsoleTabbedPane.getOutputStream(string);
    }

    void setModel(BoundedRangeModel boundedRangeModel) {
        this.m_status.setModel(boundedRangeModel);
    }

    WindowManager getWindowManager() {
        return this.m_windowManager;
    }

    public JASPage createNewPage() {
        return this.newPage(1, 1);
    }

    public JASPage createCurrentPage() {
        Component component;
        int n = this.m_windowManager.getSelectedWindow();
        Component component2 = component = n < 0 ? null : this.m_windowManager.getWindow(n);
        if (n >= 0 && component instanceof JASPage) {
            return (JASPage)component;
        }
        Vector vector = this.m_windowManager.openPages(class$jas$swingstudio$JASPage == null ? (class$jas$swingstudio$JASPage = JavaAnalysisStudio.class$("jas.swingstudio.JASPage")) : class$jas$swingstudio$JASPage);
        int n2 = vector.size();
        if (n2 == 0) {
            return this.newPage(1, 1);
        }
        if (n2 == 1) {
            JASPage jASPage = (JASPage)vector.elementAt(0);
            this.selectPage(jASPage);
            return jASPage;
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 1;
        nArray[0] = -1;
        int n4 = this.m_windowManager.getWindowCount();
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Create a new window");
        int n5 = 0;
        while (n5 < n4) {
            if (this.m_windowManager.getWindow(n5) instanceof JASPage) {
                nArray[n3++] = n5;
                jComboBox.addItem(this.m_windowManager.getWindowName(n5));
            }
            ++n5;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("North", new JLabel("Select the page to show the data on, or click on \"Cancel\"."));
        jPanel.add("South", jComboBox);
        if (JOptionPane.showConfirmDialog(this, jPanel, "Select a page", 2) == 0) {
            int n6 = nArray[jComboBox.getSelectedIndex()];
            if (n6 == -1) {
                return this.newPage(1, 1);
            }
            this.m_windowManager.selectWindow(n6);
            return this.getCurrentPage();
        }
        return null;
    }

    private void selectPage(JASPage jASPage) {
        int n = this.m_windowManager.find(jASPage);
        if (n >= 0) {
            this.m_windowManager.selectWindow(n);
        }
    }

    private void exit() throws JASException, IOException {
        if (this.querySaveJob()) {
            if (!this.m_noTopBottomSplitPane) {
                this.m_topBottomSplitPane.saveState();
            }
            this.m_leftRightSplitPane.saveState();
            if (this.m_job != null) {
                this.m_job.close();
            }
            if (this.getFrame().getBounds().x > 0) {
                this.userProp.setRectangle("Window", this.getFrame().getBounds());
            }
            this.userProp.setBoolean("StatusBarVisible", this.m_statusBarVisible);
            this.userProp.setStringArray("LastJobs", this.m_lastJobs);
            this.userProp.setStringArray("LastFiles", this.m_lastFiles);
            try {
                this.userProp.save();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Could not save properties", fileNotFoundException);
            }
            System.exit(0);
        }
    }

    public XMLMenuBuilder getXMLMenuBuilder() {
        return this.xmb;
    }

    private void readJob(File file) throws Throwable {
        this.closeCurrentJob();
    }

    private void writeJob(String string) throws IOException {
        XMLWriter xMLWriter = new XMLWriter(new FileWriter(string));
        this.m_job.setFilePath(string);
        this.m_windowManager.saveState(xMLWriter);
        xMLWriter.close();
        if (xMLWriter.checkError()) {
            throw new IOException("Error while writing XML file");
        }
    }

    void updateRecentFiles(File file) {
        try {
            this.m_lastFiles = this.userProp.updateStringArray(this.m_lastFiles, file.getCanonicalPath(), "MaxFileListLength");
        }
        catch (IOException iOException) {
            this.m_lastFiles = this.userProp.updateStringArray(this.m_lastFiles, file.getAbsolutePath(), "MaxFileListLength");
        }
    }

    private void updateRecentJobs(String string) {
        this.m_lastJobs = this.userProp.updateStringArray(this.m_lastJobs, string, "MaxJobsListLength");
    }

    String[] getLastJobs() {
        return this.m_lastJobs;
    }

    String[] getLastFiles() {
        return this.m_lastFiles;
    }

    void openJob(File file) {
        try {
            if (file != null && this.querySaveJob()) {
                this.readJob(file);
            }
        }
        catch (Throwable throwable) {
            this.error("Cannot read job file", throwable);
        }
    }

    public void openFile(File file) throws FileError, JASException, MalformedURLException {
        if (file.getName().endsWith(".java")) {
            this.openJavaFile(file);
        } else if (file.getName().endsWith(".javahist")) {
            this.openJavaHistFile(file);
        } else if (file.getName().endsWith(".plotml")) {
            this.openPlotMLFile(file);
        } else if (file.getName().endsWith(".html") || file.getName().endsWith(".htm")) {
            this.showHTMLPage("HTML Page", new URL("file:" + file.getAbsolutePath()), true);
        } else {
            Enumeration enumeration = JASRegistry.elements();
            while (enumeration.hasMoreElements()) {
                LocalDIM2 localDIM2;
                FileFilter fileFilter;
                Object e = enumeration.nextElement();
                if (!(e instanceof LocalDIM2) || !(fileFilter = (localDIM2 = (LocalDIM2)e).getFileFilter()).accept(file)) continue;
                this.openDataSet(file, localDIM2);
                return;
            }
            int n = JOptionPane.showConfirmDialog(this, "Unrecognised file type, open in text editor?");
            if (n == 0) {
                this.openJavaFile(file);
            }
        }
    }

    private void openDataSet(File file, LocalDIM2 localDIM2) throws FileError, JASException {
        try {
            if (this.m_job.getJob() instanceof LocalJob) {
                JASLocalJobBuilder jASLocalJobBuilder = new JASLocalJobBuilder((LocalJob)this.m_job.getJob());
                localDIM2.setLocalJobBuilder(jASLocalJobBuilder);
                jASLocalJobBuilder.setDIM(localDIM2);
                jASLocalJobBuilder.createJob(file.getCanonicalPath());
            } else if (this.querySaveJob()) {
                JASLocalJobBuilder jASLocalJobBuilder = this.getLocalJobBuilder();
                jASLocalJobBuilder.setJobName("Untitled");
                localDIM2.setLocalJobBuilder(jASLocalJobBuilder);
                jASLocalJobBuilder.setDIM(localDIM2);
                jASLocalJobBuilder.createJob(file.getCanonicalPath());
            }
        }
        catch (IOException iOException) {
            throw new FileError("Error opening file", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openJavaHistFile(File file) throws FileError, JASException {
        if (!(this.m_job.getJob() instanceof LocalJob)) {
            throw new JASException("You can not read a .javahist file into a remote job");
        }
        ObjectInputStream objectInputStream = null;
        try {
            try {
                NamedObject namedObject;
                objectInputStream = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))));
                Object object = objectInputStream.readObject();
                if (object instanceof NamedObject && (namedObject = (NamedObject)object).getFolder() == null) {
                    LocalJob localJob = (LocalJob)this.m_job.getJob();
                    JobFolder jobFolder = (JobFolder)localJob.getTreeRoot();
                    jobFolder.addNotify(namedObject);
                }
                this.updateRecentFiles(file);
            }
            catch (Exception exception) {
                throw new FileError("Error reading .javahist file", exception);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (objectInputStream == null) throw throwable;
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (objectInputStream == null) return;
        objectInputStream.close();
        return;
    }

    private void openJavaFile(File file) throws FileError {
        int n = this.m_windowManager.getWindowCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.m_windowManager.getWindow(n2);
            if (component instanceof ProgramPage) {
                String string = ((ProgramPage)component).getCanonicalPath();
                try {
                    if (string != null && file.getCanonicalPath().equals(string)) {
                        this.m_windowManager.selectWindow(n2);
                        this.updateRecentFiles(file);
                        return;
                    }
                }
                catch (IOException iOException) {
                    throw new FileError("Error opening java file", iOException);
                }
            }
            ++n2;
        }
        this.m_windowManager.newWindow(file.getName(), new ProgramPage(file));
        this.updateRecentFiles(file);
    }

    private void openPlotMLFile(File file) throws JASException {
        try {
            XMLHistBuilder xMLHistBuilder = new XMLHistBuilder(new BufferedReader(new FileReader(file)), file.getName());
            JASPage jASPage = new JASPage(1, 1);
            xMLHistBuilder.modifyPlot(jASPage.getCurrentPlot());
            this.m_windowManager.newWindow("PlotML", jASPage);
            this.updateRecentFiles(file);
        }
        catch (Throwable throwable) {
            this.error("Error reading PlotML file", throwable);
        }
    }

    private void showHTMLPage(String string, URL uRL, boolean bl) {
        Vector vector = this.m_windowManager.openPages(class$jas$swingstudio$HTMLPage == null ? (class$jas$swingstudio$HTMLPage = JavaAnalysisStudio.class$("jas.swingstudio.HTMLPage")) : class$jas$swingstudio$HTMLPage);
        if (bl || vector.isEmpty()) {
            this.m_windowManager.newWindow(string, new HTMLPage(uRL));
        } else {
            HTMLPage hTMLPage = (HTMLPage)vector.elementAt(0);
            hTMLPage.showURL(uRL);
            this.m_windowManager.selectWindow(this.m_windowManager.find(hTMLPage));
        }
    }

    JASLocalJobBuilder getLocalJobBuilder() {
        return new JASLocalJobBuilder();
    }

    private boolean querySaveJob() throws IOException, JASException {
        boolean bl = this.windowHasChanged();
        boolean bl2 = this.m_job.isChanged();
        if (bl2 || bl) {
            int n = JOptionPane.showConfirmDialog(this, "Save changes to job " + this.m_job.getName() + "?", "Save Changes?", 1, 2);
            if (n == 2) {
                return false;
            }
            if (n == -1) {
                return false;
            }
            if (n == 0) {
                throw new NotImplemented("Job Saving and Restoring");
            }
        }
        return true;
    }

    private boolean windowHasChanged() {
        int n = this.m_windowManager.getWindowCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.m_windowManager.getWindow(n2);
            if (component instanceof ChangableContainer && ((ChangableContainer)((Object)component)).hasChanged()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean saveJob() throws IOException {
        String string = this.m_job.getFilePath();
        if (string == null) {
            return this.saveJobAs();
        }
        this.writeJob(string);
        this.updateRecentJobs(string);
        return true;
    }

    boolean saveJobAs() throws IOException {
        JFileChooser jFileChooser = new JFileChooser(this.userProp.getString("LastJobPath", System.getProperty("user.home")));
        jFileChooser.setDialogTitle("Save Job As...");
        jFileChooser.setFileFilter(new JASFileFilter());
        jFileChooser.setSelectedFile(new File(this.m_job.getName().concat(".jas")));
        if (jFileChooser.showSaveDialog(this.getFrame()) != 0) {
            return false;
        }
        File file = jFileChooser.getSelectedFile();
        if (!file.getName().endsWith(".jas")) {
            file = new File(file.getAbsolutePath().concat(".jas"));
        }
        this.writeJob(file.getAbsolutePath());
        this.updateRecentJobs(file.getAbsolutePath());
        this.userProp.setString("LastJobPath", file.getParent());
        return true;
    }

    void closeCurrentJob() {
        this.m_job.close();
    }

    void setToEmptyJob() {
        String string = "Default Job";
        JASJob jASJob = new JASJob(string);
        LocalJob localJob = new LocalJob(jASJob, string);
        jASJob.setJob(localJob);
        this.setJob(jASJob, true);
    }

    void setJob(JASJob jASJob, boolean bl) {
        if (bl) {
            this.m_windowManager.closeAllWindows();
            this.newPage(1, 1);
        }
        this.m_job = jASJob;
        this.m_job.setTreeModel(this.m_tree);
        this.m_job.setEventSourceModel(this.m_toolbarHolder.getEventSourceComboBox());
    }

    StoppableExecutionMonitor registerStoppable(StoppableExecution stoppableExecution) {
        return this.m_stopMan.registerStoppable(stoppableExecution);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        knownDebugFlags = new String[][]{{"loader", "Debug Class Loaders"}, {"eventDelivery", "Remote Event Delivery"}, {"caching", "Caching of Remote Data"}, {"extensions", "Extension loading"}, {"printing", "Printing"}, {"help", "Help"}, {"all", "Turn on all known debug flags"}};
    }

    private class SelectAdaptor
    implements TreeSelectionListener,
    CommandSource {
        private SimpleCommandTarget m_target;

        private SelectAdaptor() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.m_target != null && treeSelectionEvent.isAddedPath()) {
                this.m_target.invoke();
            }
        }

        public String getCommand() {
            return "Select";
        }

        public CommandTarget getTarget() {
            return this.m_target;
        }

        public boolean setTarget(CommandTarget commandTarget) {
            if (commandTarget instanceof SimpleCommandTarget) {
                this.m_target = (SimpleCommandTarget)commandTarget;
                return true;
            }
            return false;
        }

        public void clearTarget() {
            this.m_target = null;
        }
    }

    private class DoubleClickAdaptor
    implements MouseListener,
    CommandSource {
        private SimpleCommandTarget m_target;

        private DoubleClickAdaptor() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && this.m_target != null) {
                this.m_target.invoke();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public String getCommand() {
            return "DoubleClick";
        }

        public CommandTarget getTarget() {
            return this.m_target;
        }

        public boolean setTarget(CommandTarget commandTarget) {
            if (commandTarget instanceof SimpleCommandTarget) {
                this.m_target = (SimpleCommandTarget)commandTarget;
                return true;
            }
            return false;
        }

        public void clearTarget() {
            this.m_target = null;
        }
    }

    private class FitWatcher
    implements Observer,
    StoppableExecution {
        private StoppableExecutionMonitor m_stopMonitor;
        private BoundedRangeModel model;
        private Fitter m_fitter;
        private final NumberFormat format = NumberFormat.getInstance();
        private String m_funcTitle;

        FitWatcher(Fitter fitter) {
            this.format.setMaximumFractionDigits(6);
            this.model = JavaAnalysisStudio.this.m_status.getModel();
            this.model.setMinimum(0);
            this.model.setMaximum(100);
            this.m_fitter = fitter;
            this.m_fitter.addObserver(this);
            this.m_stopMonitor = JavaAnalysisStudio.this.registerStoppable(this);
            this.m_funcTitle = this.m_fitter.getFunction().getTitle();
        }

        Fitter clearFit() {
            Fitter fitter = this.m_fitter;
            if (fitter != null) {
                fitter.deleteObserver(this);
                fitter.getFunction().clearFit();
                this.m_fitter = null;
                this.m_stopMonitor.end();
            }
            return fitter;
        }

        public void update(Observable observable, Object object) {
            if (object instanceof FitUpdate) {
                FitUpdate fitUpdate = (FitUpdate)object;
                int n = fitUpdate.getState();
                if (n == 5) {
                    this.clearFit();
                } else {
                    this.model.setValue(fitUpdate.getPercent());
                    if (n == 2) {
                        JavaAnalysisStudio.this.setMessage("Fit failed.  Exception was: " + fitUpdate.getReason());
                        this.clearFit();
                    } else if (n == 1) {
                        JavaAnalysisStudio.this.setMessage(this.m_funcTitle + " fit complete.  \u03c7\u00b2 = " + this.format.format(this.m_fitter.getChiSquared()));
                    } else if (n == 0) {
                        JavaAnalysisStudio.this.setMessage("Now fitting function " + this.m_funcTitle);
                    }
                    this.m_stopMonitor.doStopEnabling();
                }
                if (this.m_fitter != null) {
                    this.m_fitter.getFunction().setChanged();
                }
            }
        }

        public boolean isRunning() {
            return this.m_fitter != null && this.m_fitter.getState() == 0;
        }

        public void stop() {
            if (this.m_fitter != null) {
                this.m_fitter.stop();
                this.m_fitter.deleteObserver(this);
                this.m_fitter.getFunction().clearFit();
                this.m_fitter = null;
                JavaAnalysisStudio.this.m_status.setMessage("Fitter stopped before completion");
                JavaAnalysisStudio.this.m_status.getModel().setValue(0);
            }
        }
    }

    private final class JASFitListener
    implements FitListener {
        private JASFitListener() {
        }

        public void fitStarted(Fitter fitter) {
            new FitWatcher(fitter);
        }
    }

    private class JASStoppableExecutionMonitor
    implements StoppableExecutionMonitor {
        private StoppableExecution m_stoppable;

        JASStoppableExecutionMonitor(StoppableExecution stoppableExecution) {
            this.m_stoppable = stoppableExecution;
            this.doStopEnabling();
        }

        boolean isRunning() {
            return this.m_stoppable.isRunning();
        }

        public void setProgressModel(BoundedRangeModel boundedRangeModel) {
            JavaAnalysisStudio.this.m_status.setModel(boundedRangeModel);
        }

        public void doStopEnabling() {
            JavaAnalysisStudio.this.m_jasCommand.forceSetChanged();
        }

        public void end() {
            JavaAnalysisStudio.this.m_stopMan.removeStoppable(this);
        }

        void stop() {
            this.m_stoppable.stop();
        }
    }

    private class JASStoppableManager {
        private Vector m_stoppables = new Vector();

        private JASStoppableManager() {
        }

        StoppableExecutionMonitor registerStoppable(StoppableExecution stoppableExecution) {
            JASStoppableExecutionMonitor jASStoppableExecutionMonitor = new JASStoppableExecutionMonitor(stoppableExecution);
            this.m_stoppables.addElement(jASStoppableExecutionMonitor);
            return jASStoppableExecutionMonitor;
        }

        void removeStoppable(StoppableExecutionMonitor stoppableExecutionMonitor) {
            this.m_stoppables.removeElement(stoppableExecutionMonitor);
        }

        void stop() {
            Enumeration enumeration = this.m_stoppables.elements();
            while (enumeration.hasMoreElements()) {
                JASStoppableExecutionMonitor jASStoppableExecutionMonitor = (JASStoppableExecutionMonitor)enumeration.nextElement();
                if (!jASStoppableExecutionMonitor.isRunning()) continue;
                jASStoppableExecutionMonitor.stop();
            }
            JavaAnalysisStudio.this.m_jasCommand.forceSetChanged();
        }

        boolean getStopEnabled() {
            Enumeration enumeration = this.m_stoppables.elements();
            while (enumeration.hasMoreElements()) {
                if (!((JASStoppableExecutionMonitor)enumeration.nextElement()).isRunning()) continue;
                return true;
            }
            return false;
        }
    }

    private class JASCommand
    extends JASCommandProcessor {
        static /* synthetic */ Class class$jas$swingstudio$HTMLPage;

        private JASCommand() {
        }

        void forceSetChanged() {
            this.setChanged();
        }

        public void onNewJob() throws IOException, JASException {
            if (JavaAnalysisStudio.this.querySaveJob()) {
                new JASWizard(JavaAnalysisStudio.this.getFrame(), "New Job Wizard", new NewJobPage());
            }
        }

        public void onReconnect() throws ConnectFailed, IOException, JASException {
            if (JavaAnalysisStudio.this.querySaveJob()) {
                new JASWizard(JavaAnalysisStudio.this.getFrame(), "Connect to Server", new ConnectPage());
            }
        }

        public void onOpenJob() throws IOException, JASException {
            throw new NotImplemented("Saving and restoring jobs");
        }

        public void onOpen() throws FileError, JASException, MalformedURLException {
            Object object;
            Object object2;
            JFileChooser jFileChooser = new JFileChooser(JavaAnalysisStudio.this.userProp.getString("LastProgramPath", System.getProperty("user.home")));
            jFileChooser.setDialogTitle("Open File...");
            AllSupportedFileFilter allSupportedFileFilter = new AllSupportedFileFilter();
            Enumeration enumeration = JASRegistry.elements();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                if (!(object2 instanceof LocalDIM2)) continue;
                object = ((LocalDIM2)object2).getFileFilter();
                allSupportedFileFilter.add((FileFilter)object);
                jFileChooser.addChoosableFileFilter((FileFilter)object);
            }
            object2 = new FileTypeFileFilter("html", "HTML File (*.html)");
            allSupportedFileFilter.add((FileFilter)object2);
            jFileChooser.addChoosableFileFilter((FileFilter)object2);
            object2 = new FileTypeFileFilter("javahist", "Java Histogram File (*.javahist)");
            allSupportedFileFilter.add((FileFilter)object2);
            jFileChooser.addChoosableFileFilter((FileFilter)object2);
            object2 = new FileTypeFileFilter("plotml", "XML Plot File (*.plotml)");
            allSupportedFileFilter.add((FileFilter)object2);
            jFileChooser.addChoosableFileFilter((FileFilter)object2);
            object2 = new FileTypeFileFilter("java", "Java File (*.java)");
            allSupportedFileFilter.add((FileFilter)object2);
            jFileChooser.addChoosableFileFilter((FileFilter)object2);
            jFileChooser.setFileFilter(allSupportedFileFilter);
            if (jFileChooser.showOpenDialog(JavaAnalysisStudio.this.getFrame()) == 0) {
                object = jFileChooser.getSelectedFile();
                JavaAnalysisStudio.this.userProp.setString("LastProgramPath", ((File)object).getParent());
                JavaAnalysisStudio.this.openFile((File)object);
            }
        }

        public void onNewProgramWizard() {
            this.onProgramUsingWizard();
        }

        public void onProgramUsingWizard() {
            new JASWizard(JavaAnalysisStudio.this.getFrame(), "New Program Page Wizard", new NewProgramPage());
        }

        public void onBlankProgramPage() {
            ProgramPage programPage = new ProgramPage();
            programPage.setClassName("Untitled");
            JavaAnalysisStudio.this.m_windowManager.newWindow("Untitled      ", programPage);
        }

        public void onExit() throws JASException, IOException {
            JavaAnalysisStudio.this.exit();
        }

        public void onHome() throws IOException {
            JavaAnalysisStudio.this.showHTMLPage("Welcome", JavaAnalysisStudio.this.m_homePage, false);
        }

        public void onWebPage() throws IOException {
            Vector vector = JavaAnalysisStudio.this.m_windowManager.openPages(class$jas$swingstudio$HTMLPage == null ? (class$jas$swingstudio$HTMLPage = JASCommand.class$("jas.swingstudio.HTMLPage")) : class$jas$swingstudio$HTMLPage);
            WebPageDialog webPageDialog = new WebPageDialog((Frame)JavaAnalysisStudio.this.getFrame(), !vector.isEmpty());
            if (webPageDialog.doModal()) {
                JavaAnalysisStudio.this.showHTMLPage("Web Page", webPageDialog.getURL(), webPageDialog.getNewPage());
            }
        }

        public void onStatusBar(boolean bl) {
            JavaAnalysisStudio.this.setStatusBarVisible(bl);
        }

        public void onOptions() {
            new JASOptionsDialog(JavaAnalysisStudio.this.getFrame());
        }

        public void onRegistries() {
            new JASRegistryDialog(JavaAnalysisStudio.this.getFrame());
        }

        public void enableStatusBar(JASCheckboxState jASCheckboxState) {
            jASCheckboxState.setCheckbox(JavaAnalysisStudio.this.m_statusBarVisible);
            jASCheckboxState.setEnabled(true);
        }

        public void onAbout() {
            AboutBox aboutBox = new AboutBox(JavaAnalysisStudio.this.getFrame());
            ((Dialog)aboutBox).show();
        }

        public void onSubmitBugReport() throws MalformedURLException, IOException {
            URL uRL = new URL("http://www-sldnt.slac.stanford.edu/jas/bugs/bugreport_form.asp");
            JavaAnalysisStudio.this.showHTMLPage("Bug Report", uRL, true);
        }

        public void onReleaseNotes() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpTopic("relnotes");
        }

        public void onCheckVersion() {
            JASVersion jASVersion = new JASVersion(JavaAnalysisStudio.this.getFrame(), "JAS", JavaAnalysisStudio.versionURL, JavaAnalysisStudio.getVersionNumber(), JavaAnalysisStudio.this.userProp);
            jASVersion.showOptionsDialog();
        }

        public void onPluginManager() {
            if (JavaAnalysisStudio.this.pluginmanager.getReadPluginXMLOK()) {
                JavaAnalysisStudio.this.pluginmanager.showPluginManager();
            } else {
                JavaAnalysisStudio.this.pluginmanager.initializePluginList();
                if (JavaAnalysisStudio.this.pluginmanager.getReadPluginXMLOK()) {
                    JavaAnalysisStudio.this.pluginmanager.showPluginManager();
                }
            }
        }

        public void onTutorial() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpTopic("tutorial.part1");
        }

        public void onWelcome() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpTopic("tutorial.jasintro");
        }

        public void onHelpContents() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpContents();
        }

        public void onSearch() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpSearch();
        }

        public void onHelpIndex() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpIndex();
        }

        public void onheppackages() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpTopic("API.hepPackages.packageList");
        }

        public void onjaspackages() throws MalformedURLException, IOException {
            JavaAnalysisStudio.this.showHelpTopic("API.jasPackages.packageList");
        }

        public void enableTabbedPanels(JASCheckboxState jASCheckboxState) {
            this.enableWM(jASCheckboxState, JavaAnalysisStudio.m_TabbedWM);
        }

        public void onTabbedPanels() {
            this.setWM(JavaAnalysisStudio.m_TabbedWM);
        }

        public void enableInternalFrames(JASCheckboxState jASCheckboxState) {
            this.enableWM(jASCheckboxState, JavaAnalysisStudio.m_InternalWM);
        }

        public void onInternalFrames() {
            this.setWM(JavaAnalysisStudio.m_InternalWM);
        }

        private void enableWM(JASCheckboxState jASCheckboxState, String string) {
            jASCheckboxState.setCheckbox(JavaAnalysisStudio.this.m_windowManager.getClass().getName().equals(string));
            try {
                jASCheckboxState.setEnabled(Class.forName(string) != null);
            }
            catch (Exception exception) {
                jASCheckboxState.setEnabled(false);
            }
        }

        private void setWM(String string) {
            if (JavaAnalysisStudio.this.m_windowManager.getClass().getName().equals(string)) {
                return;
            }
            WindowManager windowManager = JavaAnalysisStudio.this.m_windowManager;
            WindowItem[] windowItemArray = windowManager.getItems();
            Vector vector = windowManager.getPageListeners();
            try {
                JavaAnalysisStudio.this.m_windowManager = (WindowManager)Class.forName(string).newInstance();
                JComponent jComponent = (JComponent)((Object)JavaAnalysisStudio.this.m_windowManager);
                jComponent.setMinimumSize(new Dimension(40, 40));
                JavaAnalysisStudio.this.m_leftRightSplitPane.setRightComponent(jComponent);
                JavaAnalysisStudio.this.m_leftRightSplitPane.validate();
                jComponent.repaint();
                JavaAnalysisStudio.this.userProp.setString("WindowManager", string);
                JavaAnalysisStudio.this.m_windowManager.initialize(windowItemArray, vector);
            }
            catch (Exception exception) {
                JavaAnalysisStudio.this.error("Could not open window manager " + string, exception);
                JavaAnalysisStudio.this.m_windowManager = windowManager;
            }
            this.setChanged();
        }

        public void enableWindows(JASCheckboxState jASCheckboxState) {
            this.enableLAF(jASCheckboxState, JavaAnalysisStudio.m_WindowsLAF);
        }

        public void onWindows() throws Exception {
            this.onLAF(JavaAnalysisStudio.m_WindowsLAF);
        }

        public void enableMotif(JASCheckboxState jASCheckboxState) {
            this.enableLAF(jASCheckboxState, JavaAnalysisStudio.m_MotifLAF);
        }

        public void onMotif() throws Exception {
            this.onLAF(JavaAnalysisStudio.m_MotifLAF);
        }

        public void enableJava(JASCheckboxState jASCheckboxState) {
            this.enableLAF(jASCheckboxState, JavaAnalysisStudio.m_JavaLAF);
        }

        public void onJava() throws Exception {
            this.onLAF(JavaAnalysisStudio.m_JavaLAF);
        }

        private void enableLAF(JASCheckboxState jASCheckboxState, String string) {
            try {
                Class<?> clazz = Class.forName(string);
                LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
                jASCheckboxState.setCheckbox(UIManager.getLookAndFeel().getName().equals(lookAndFeel.getName()));
                jASCheckboxState.setEnabled(lookAndFeel.isSupportedLookAndFeel());
            }
            catch (Exception exception) {
                jASCheckboxState.setEnabled(false);
            }
        }

        private void onLAF(String string) throws Exception {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(JavaAnalysisStudio.this.getFrame());
            ((Hashtable)JavaAnalysisStudio.this.userProp).put("LookAndFeel", string);
            this.setChanged();
        }

        public void onEnableToolTips(boolean bl) {
            ToolTipManager.sharedInstance().setEnabled(bl);
            JavaAnalysisStudio.this.userProp.setBoolean("EnableToolTips", bl);
        }

        public void enableEnableToolTips(JASCheckboxState jASCheckboxState) {
            jASCheckboxState.setCheckbox(ToolTipManager.sharedInstance().isEnabled());
            jASCheckboxState.setEnabled(true);
        }

        public void enableFullScreen(JASState jASState) {
            jASState.setEnabled(JavaAnalysisStudio.this.getWindowManager().getSelectedWindow() >= 0);
        }

        public void onFullScreen() {
            JavaAnalysisStudio.this.getWindowManager().doFullScreen();
        }

        public void on1x1() {
            JavaAnalysisStudio.this.newPage(1, 1);
        }

        public void on1x2() {
            JavaAnalysisStudio.this.newPage(1, 2);
        }

        public void on2x1() {
            JavaAnalysisStudio.this.newPage(2, 1);
        }

        public void on2x2() {
            JavaAnalysisStudio.this.newPage(2, 2);
        }

        public void on3x3() {
            JavaAnalysisStudio.this.newPage(3, 3);
        }

        public void on4x4() {
            JavaAnalysisStudio.this.newPage(4, 4);
        }

        public void onStop() {
            JavaAnalysisStudio.this.m_stopMan.stop();
        }

        public void enableStop(JASState jASState) {
            jASState.setEnabled(JavaAnalysisStudio.this.m_stopMan.getStopEnabled());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        AppCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            JavaAnalysisStudio javaAnalysisStudio = JavaAnalysisStudio.getApp();
            try {
                javaAnalysisStudio.exit();
            }
            catch (IOException iOException) {
                javaAnalysisStudio.error("Error during window close", iOException);
            }
            catch (JASException jASException) {
                javaAnalysisStudio.error("Error during window close", jASException);
            }
        }
    }
}

