/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.hist.DataSource;
import jas.hist.HasStatistics;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;
import jas.jds.interfaces.Remote1DHistogramInfo;
import jas.jds.interfaces.RemoteRebinnable1DHistogramData;
import jas.jds.interfaces.RemoteRebinnable2DHistogramData;
import jas.jds.interfaces.RemoteScatterSource;
import jas.swingstudio.JAS2DRebinAdaptor;
import jas.swingstudio.JASScatterAdaptor;
import jas.util.rmi.RMIDestination;
import jas.util.rmi.RMIEventDelivery;
import java.rmi.RemoteException;
import java.rmi.ServerRuntimeException;
import java.util.Observable;
import java.util.Observer;

public class JASRebinAdaptor
extends Observable
implements Rebinnable1DHistogramData,
Observer,
HasStyle,
HasStatistics,
Statistics {
    private double[][] cacheData;
    private Statistics cacheStats;
    private int cacheBins;
    private double cacheMin;
    private double cacheMax;
    private boolean cacheErrors;
    private Remote1DHistogramInfo info;
    private String[] axisLabels;
    private RemoteRebinnable1DHistogramData m_remote;
    private static final boolean debug = System.getProperty("debugCache") != null;

    public JASRebinAdaptor(RemoteRebinnable1DHistogramData remoteRebinnable1DHistogramData, RMIDestination rMIDestination) {
        rMIDestination.addObserver(this);
        this.m_remote = remoteRebinnable1DHistogramData;
    }

    public void update(Observable observable, Object object) {
        HistogramUpdate histogramUpdate = (HistogramUpdate)object;
        if (debug) {
            System.out.println("JASRebinAdaptor: update " + histogramUpdate);
        }
        this.setChanged();
        JASRebinAdaptor jASRebinAdaptor = this;
        synchronized (jASRebinAdaptor) {
            if (histogramUpdate.isDataUpdate()) {
                this.cacheStats = null;
                this.cacheData = null;
            }
            if (histogramUpdate.isRangeUpdate()) {
                this.info = null;
                this.axisLabels = null;
            }
            if (histogramUpdate.isTitleUpdate()) {
                this.info = null;
            }
            if (histogramUpdate.isReset()) {
                this.info = null;
                this.cacheStats = null;
                this.cacheData = null;
                this.axisLabels = null;
            }
        }
        this.notifyObservers(histogramUpdate);
    }

    public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
        double[][] dArray;
        if (this.cacheData != null && (n != this.cacheBins || d != this.cacheMin || d2 != this.cacheMax || bl && !this.cacheErrors)) {
            this.cacheData = null;
        }
        if ((dArray = this.cacheData) == null) {
            try {
                JASRebinAdaptor jASRebinAdaptor = this;
                synchronized (jASRebinAdaptor) {
                    this.cacheData = dArray = this.m_remote.remoteRebin(n, d, d2, bl, bl2);
                }
                if (bl2) {
                    return dArray;
                }
                this.cacheBins = n;
                this.cacheMin = d;
                this.cacheMax = d2;
                this.cacheErrors = bl;
            }
            catch (ServerRuntimeException serverRuntimeException) {
                System.out.println("Server Runtime exception!!");
                serverRuntimeException.detail.printStackTrace();
            }
            catch (RemoteException remoteException) {
                System.out.println("Terrible problem during remote rebin!!");
                remoteException.printStackTrace();
            }
        } else if (debug) {
            System.out.println("Data found in cache");
        }
        return dArray;
    }

    public double getMin() {
        Remote1DHistogramInfo remote1DHistogramInfo = this.info;
        if (remote1DHistogramInfo == null) {
            remote1DHistogramInfo = this.setInfo();
        }
        return remote1DHistogramInfo.m_min;
    }

    public double getMax() {
        Remote1DHistogramInfo remote1DHistogramInfo = this.info;
        if (remote1DHistogramInfo == null) {
            remote1DHistogramInfo = this.setInfo();
        }
        return remote1DHistogramInfo.m_max;
    }

    public int getBins() {
        Remote1DHistogramInfo remote1DHistogramInfo = this.info;
        if (remote1DHistogramInfo == null) {
            remote1DHistogramInfo = this.setInfo();
        }
        return remote1DHistogramInfo.m_bins;
    }

    public int getAxisType() {
        Remote1DHistogramInfo remote1DHistogramInfo = this.info;
        if (remote1DHistogramInfo == null) {
            remote1DHistogramInfo = this.setInfo();
        }
        return remote1DHistogramInfo.m_axisType;
    }

    public boolean isRebinnable() {
        Remote1DHistogramInfo remote1DHistogramInfo = this.info;
        if (remote1DHistogramInfo == null) {
            remote1DHistogramInfo = this.setInfo();
        }
        return remote1DHistogramInfo.m_isRebinnable;
    }

    public String getTitle() {
        Remote1DHistogramInfo remote1DHistogramInfo = this.info;
        if (remote1DHistogramInfo == null) {
            remote1DHistogramInfo = this.setInfo();
        }
        return remote1DHistogramInfo.m_title;
    }

    public String[] getAxisLabels() {
        String[] stringArray = this.axisLabels;
        if (stringArray == null) {
            stringArray = this.getRemoteAxisLabels();
        }
        return stringArray;
    }

    public JASHistStyle getStyle() {
        try {
            return this.m_remote.getStyle();
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            return null;
        }
    }

    private String[] getRemoteAxisLabels() {
        String[] stringArray;
        try {
            stringArray = this.m_remote.getRemoteAxisLabels();
            this.axisLabels = stringArray;
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            return null;
        }
        return stringArray;
    }

    private Remote1DHistogramInfo setInfo() {
        Remote1DHistogramInfo remote1DHistogramInfo;
        try {
            this.info = remote1DHistogramInfo = this.m_remote.getRemoteInfo();
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            return null;
        }
        return remote1DHistogramInfo;
    }

    public String toString() {
        try {
            return this.m_remote.getDescription();
        }
        catch (RemoteException remoteException) {
            return super.toString();
        }
    }

    public Statistics getStatistics() {
        Statistics statistics = this.cacheStats;
        if (statistics == null) {
            statistics = this.getStats();
        }
        return statistics == null ? null : this;
    }

    public String[] getStatisticNames() {
        Statistics statistics = this.cacheStats;
        if (statistics == null) {
            statistics = this.getStats();
        }
        return statistics.getStatisticNames();
    }

    public double getStatistic(String string) {
        Statistics statistics = this.cacheStats;
        if (statistics == null) {
            statistics = this.getStats();
        }
        return statistics.getStatistic(string);
    }

    private Statistics getStats() {
        try {
            Statistics statistics;
            this.cacheStats = statistics = this.m_remote.getStatistics();
            return statistics;
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            return null;
        }
    }

    static DataSource getAdaptor(Object object, RMIEventDelivery rMIEventDelivery, RMIDestination rMIDestination) throws RemoteException {
        if (object instanceof RemoteRebinnable1DHistogramData) {
            return new JASRebinAdaptor((RemoteRebinnable1DHistogramData)object, rMIDestination);
        }
        if (object instanceof RemoteScatterSource) {
            return new JASScatterAdaptor((RemoteScatterSource)object, rMIDestination, rMIEventDelivery);
        }
        if (object instanceof RemoteRebinnable2DHistogramData) {
            return new JAS2DRebinAdaptor((RemoteRebinnable2DHistogramData)object, rMIDestination, rMIEventDelivery);
        }
        throw new RuntimeException("Unknown RemoteDataSource");
    }
}

