/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.hist.HasSlices;
import jas.hist.HasStatistics;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.SliceParameters;
import jas.hist.Statistics;
import jas.jds.interfaces.Remote2DHistogramInfo;
import jas.jds.interfaces.RemoteRebinnable2DHistogramData;
import jas.swingstudio.JASRebinAdaptor;
import jas.swingstudio.JASSliceAdaptor;
import jas.util.rmi.RMIDestination;
import jas.util.rmi.RMIEventDelivery;
import java.rmi.RemoteException;
import java.rmi.ServerRuntimeException;
import java.util.Observable;
import java.util.Observer;

public class JAS2DRebinAdaptor
extends Observable
implements Rebinnable2DHistogramData,
Observer,
HasSlices,
HasStyle,
HasStatistics,
Statistics {
    private double[][][] cacheData;
    private boolean cacheErrors;
    private AxisCache xAxisCache = new AxisCache();
    private AxisCache yAxisCache = new AxisCache();
    protected Remote2DHistogramInfo info;
    private Statistics cacheStats;
    private String[] xAxisLabels;
    private String[] yAxisLabels;
    private RemoteRebinnable2DHistogramData m_remote;
    private RMIEventDelivery m_ed;
    private static final boolean debug = System.getProperty("debugCache") != null;

    public JAS2DRebinAdaptor(RemoteRebinnable2DHistogramData remoteRebinnable2DHistogramData, RMIDestination rMIDestination, RMIEventDelivery rMIEventDelivery) {
        rMIDestination.addObserver(this);
        this.m_remote = remoteRebinnable2DHistogramData;
        this.m_ed = rMIEventDelivery;
    }

    public void update(Observable observable, Object object) {
        HistogramUpdate histogramUpdate = (HistogramUpdate)object;
        this.setChanged();
        JAS2DRebinAdaptor jAS2DRebinAdaptor = this;
        synchronized (jAS2DRebinAdaptor) {
            if (histogramUpdate.isDataUpdate()) {
                this.cacheStats = null;
                this.cacheData = null;
            }
            if (histogramUpdate.isRangeUpdate()) {
                this.info = null;
                this.xAxisLabels = null;
                this.yAxisLabels = null;
            }
            if (histogramUpdate.isTitleUpdate()) {
                this.info = null;
            }
            if (histogramUpdate.isReset()) {
                this.info = null;
                this.cacheStats = null;
                this.cacheData = null;
                this.xAxisLabels = null;
                this.yAxisLabels = null;
            }
        }
        this.notifyObservers(histogramUpdate);
    }

    public double[][][] rebin(int n, double d, double d2, int n2, double d3, double d4, boolean bl, boolean bl2, boolean bl3) {
        double[][][] dArray;
        if (this.cacheData != null && (!this.xAxisCache.equals(n, d, d2) || !this.yAxisCache.equals(n2, d3, d4) || bl && !this.cacheErrors)) {
            this.cacheData = null;
        }
        if ((dArray = this.cacheData) == null) {
            try {
                JAS2DRebinAdaptor jAS2DRebinAdaptor = this;
                synchronized (jAS2DRebinAdaptor) {
                    this.cacheData = dArray = this.m_remote.remoteRebin(n, d, d2, n2, d3, d4, bl, bl2, bl3);
                }
                if (bl2) {
                    return dArray;
                }
                this.xAxisCache.setCache(n, d, d2);
                this.yAxisCache.setCache(n2, d3, d4);
                this.cacheErrors = bl;
            }
            catch (ServerRuntimeException serverRuntimeException) {
                System.out.println("Server Runtime exception!!");
                serverRuntimeException.detail.printStackTrace();
            }
            catch (RemoteException remoteException) {
                System.out.println("Terrible problem during remote rebin!!");
                remoteException.printStackTrace();
            }
        } else if (debug) {
            System.out.println("2D Data found in cache");
        }
        return dArray;
    }

    public double getXMin() {
        Remote2DHistogramInfo remote2DHistogramInfo = this.info;
        if (remote2DHistogramInfo == null) {
            remote2DHistogramInfo = this.setInfo();
        }
        return remote2DHistogramInfo.m_xAxis.m_min;
    }

    public double getXMax() {
        Remote2DHistogramInfo remote2DHistogramInfo = this.info;
        if (remote2DHistogramInfo == null) {
            remote2DHistogramInfo = this.setInfo();
        }
        return remote2DHistogramInfo.m_xAxis.m_max;
    }

    public double getYMin() {
        Remote2DHistogramInfo remote2DHistogramInfo = this.info;
        if (remote2DHistogramInfo == null) {
            remote2DHistogramInfo = this.setInfo();
        }
        return remote2DHistogramInfo.m_yAxis.m_min;
    }

    public double getYMax() {
        Remote2DHistogramInfo remote2DHistogramInfo = this.info;
        if (remote2DHistogramInfo == null) {
            remote2DHistogramInfo = this.setInfo();
        }
        return remote2DHistogramInfo.m_yAxis.m_max;
    }

    public int getXBins() {
        Remote2DHistogramInfo remote2DHistogramInfo = this.info;
        if (remote2DHistogramInfo == null) {
            remote2DHistogramInfo = this.setInfo();
        }
        return remote2DHistogramInfo.m_xAxis.m_bins;
    }

    public int getYBins() {
        Remote2DHistogramInfo remote2DHistogramInfo = this.info;
        if (remote2DHistogramInfo == null) {
            remote2DHistogramInfo = this.setInfo();
        }
        return remote2DHistogramInfo.m_yAxis.m_bins;
    }

    public int getXAxisType() {
        Remote2DHistogramInfo remote2DHistogramInfo = this.info;
        if (remote2DHistogramInfo == null) {
            remote2DHistogramInfo = this.setInfo();
        }
        return remote2DHistogramInfo.m_xAxis.m_axisType;
    }

    public int getYAxisType() {
        Remote2DHistogramInfo remote2DHistogramInfo = this.info;
        if (remote2DHistogramInfo == null) {
            remote2DHistogramInfo = this.setInfo();
        }
        return remote2DHistogramInfo.m_yAxis.m_axisType;
    }

    public String[] getXAxisLabels() {
        String[] stringArray = this.xAxisLabels;
        if (stringArray == null) {
            stringArray = this.getRemoteXAxisLabels();
        }
        return stringArray;
    }

    public String[] getYAxisLabels() {
        String[] stringArray = this.yAxisLabels;
        if (stringArray == null) {
            stringArray = this.getRemoteYAxisLabels();
        }
        return stringArray;
    }

    public boolean isRebinnable() {
        Remote2DHistogramInfo remote2DHistogramInfo = this.info;
        if (remote2DHistogramInfo == null) {
            remote2DHistogramInfo = this.setInfo();
        }
        return remote2DHistogramInfo.m_isRebinnable;
    }

    public String getTitle() {
        Remote2DHistogramInfo remote2DHistogramInfo = this.info;
        if (remote2DHistogramInfo == null) {
            remote2DHistogramInfo = this.setInfo();
        }
        return remote2DHistogramInfo.m_title;
    }

    private String[] getRemoteXAxisLabels() {
        String[] stringArray;
        try {
            stringArray = this.m_remote.getRemoteXAxisLabels();
            this.xAxisLabels = stringArray;
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            return null;
        }
        return stringArray;
    }

    private String[] getRemoteYAxisLabels() {
        String[] stringArray;
        try {
            stringArray = this.m_remote.getRemoteYAxisLabels();
            this.yAxisLabels = stringArray;
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            return null;
        }
        return stringArray;
    }

    protected Remote2DHistogramInfo setInfo() {
        Remote2DHistogramInfo remote2DHistogramInfo;
        try {
            this.info = remote2DHistogramInfo = this.m_remote.getRemoteInfo();
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            return null;
        }
        return remote2DHistogramInfo;
    }

    public String toString() {
        try {
            return this.m_remote.getDescription();
        }
        catch (RemoteException remoteException) {
            return super.toString();
        }
    }

    public Statistics getStatistics() {
        Statistics statistics = this.cacheStats;
        if (statistics == null) {
            statistics = this.getStats();
        }
        return statistics == null ? null : this;
    }

    public String[] getStatisticNames() {
        Statistics statistics = this.cacheStats;
        if (statistics == null) {
            statistics = this.getStats();
        }
        return statistics.getStatisticNames();
    }

    public double getStatistic(String string) {
        Statistics statistics = this.cacheStats;
        if (statistics == null) {
            statistics = this.getStats();
        }
        return statistics.getStatistic(string);
    }

    private Statistics getStats() {
        try {
            Statistics statistics;
            this.cacheStats = statistics = this.m_remote.getStatistics();
            return statistics;
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            return null;
        }
    }

    public JASHistStyle getStyle() {
        try {
            return this.m_remote.getStyle();
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            return null;
        }
    }

    public int getNSlices() {
        try {
            return this.m_remote.getNSlices();
        }
        catch (RemoteException remoteException) {
            System.err.println(remoteException);
            return 0;
        }
    }

    public SliceParameters getSliceParameters(int n) {
        try {
            return new JASSliceAdaptor(this.m_remote.getSliceParameters(n));
        }
        catch (RemoteException remoteException) {
            System.err.println(remoteException);
            return null;
        }
    }

    public Rebinnable1DHistogramData getSlice(int n) {
        try {
            RMIDestination rMIDestination = this.m_ed.getRMIDestination();
            return new JASRebinAdaptor(this.m_remote.getSlice(n, rMIDestination), rMIDestination);
        }
        catch (RemoteException remoteException) {
            System.err.println(remoteException);
            return null;
        }
    }

    public boolean canAddRemoveSlices() {
        try {
            return this.m_remote.canAddRemoveSlices();
        }
        catch (RemoteException remoteException) {
            System.err.println(remoteException);
            return false;
        }
    }

    public int addSlice(double d, double d2, double d3, double d4, double d5) {
        try {
            return this.m_remote.addSlice(d, d2, d3, d4, d5);
        }
        catch (RemoteException remoteException) {
            System.err.println(remoteException);
            return 0;
        }
    }

    public void removeSlice(int n) {
        try {
            this.m_remote.removeSlice(n);
        }
        catch (RemoteException remoteException) {
            System.err.println(remoteException);
        }
    }

    private class AxisCache {
        int m_bins;
        double m_min;
        double m_max;

        private AxisCache() {
        }

        void setCache(int n, double d, double d2) {
            this.m_bins = n;
            this.m_min = d;
            this.m_max = d2;
        }

        boolean equals(int n, double d, double d2) {
            return n == this.m_bins && d == this.m_min && d2 == this.m_max;
        }
    }
}

