/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.DataArea;
import jas.plot.Legend;
import jas.plot.TextBlock;
import jas.plot.Title;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;

public class ChartLayout
implements LayoutManager2 {
    private Legend legend;
    private DataArea data;
    private Title title;
    private TextBlock stats;
    private static final int pad = 5;

    public void addLayoutComponent(Component component, Object object) {
        if (component instanceof Title) {
            this.title = (Title)component;
        }
        if (component instanceof DataArea) {
            this.data = (DataArea)component;
        }
        if (component instanceof Legend) {
            this.legend = (Legend)component;
        }
        if (component instanceof TextBlock) {
            this.stats = (TextBlock)component;
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.title) {
            this.title = null;
        }
        if (component == this.data) {
            this.data = null;
        }
        if (component == this.legend) {
            this.legend = null;
        }
        if (component == this.stats) {
            this.stats = null;
        }
    }

    public void layoutContainer(Container container) {
        Dimension dimension;
        Dimension dimension2 = container.getSize();
        int n = 0;
        if (this.title != null && this.title.moveWithParent && this.title.isVisible()) {
            dimension = this.title.getPreferredSize();
            this.title.setSize(dimension2.width - 5 - 5, dimension.height);
            this.title.setLocation(5, 5);
            n += dimension.height;
        }
        if (this.data != null && this.data.moveWithParent) {
            this.data.setSize(dimension2.width - 5 - 5, dimension2.height - 5 - 5 - n);
            this.data.setLocation(5, 5 + n);
        }
        if (this.legend != null && this.legend.moveWithParent && this.legend.isVisible()) {
            dimension = this.legend.getPreferredSize();
            this.legend.setLocation(dimension2.width - 5 - dimension.width, 5 + n);
            this.legend.setSize(dimension);
            n += dimension.height + 5;
        }
        if (this.stats != null && this.stats.moveWithParent && this.stats.isVisible()) {
            dimension = this.stats.getPreferredSize();
            this.stats.setLocation(dimension2.width - 5 - dimension.width, 5 + n);
            this.stats.setSize(dimension);
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.title != null ? this.title.getPreferredSize() : new Dimension(10, 10);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    void restoreDefaultLayout() {
        if (this.legend != null) {
            this.legend.moveWithParent = true;
        }
        if (this.title != null) {
            this.title.moveWithParent = true;
        }
        if (this.stats != null) {
            this.stats.moveWithParent = true;
        }
        if (this.data != null) {
            this.data.moveWithParent = true;
        }
    }

    boolean hasDefaultLayout() {
        boolean bl = true;
        if (this.legend != null) {
            bl &= this.legend.moveWithParent;
        }
        if (this.title != null) {
            bl &= this.title.moveWithParent;
        }
        if (this.stats != null) {
            bl &= this.stats.moveWithParent;
        }
        if (this.data != null) {
            bl &= this.data.moveWithParent;
        }
        return bl;
    }
}

