/*
 * Decompiled with CFR 0.152.
 */
package jas.jds;

import jas.jds.JDSSecurityManager;
import jas.jds.JavaDataServerImpl;
import jas.jds.JavaDataServerMonitor;
import jas.jds.interfaces.Version;
import jas.util.NestedException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;

public class RMIProtocol {
    public static void main(String[] stringArray) throws NestedException {
        try {
            Object object;
            JavaDataServerMonitor javaDataServerMonitor;
            block29: {
                Serializable serializable;
                String string = System.getProperty("jas.jds.rmi.port");
                String string2 = System.getProperty("jas.jds.rmi.node");
                String string3 = System.getProperty("jas.jds.rmi.service", Version.getService());
                String string4 = System.getProperty("jas.jds.rmi.createRegistry", "ifneeded");
                String string5 = System.getProperty("jas.jds.rmi.rebind", "yes");
                int n = 0;
                while (n < stringArray.length) {
                    if (n + 1 >= stringArray.length) {
                        throw new IllegalArgumentException("Missing argument");
                    }
                    if (stringArray[n].equals("port")) {
                        string = stringArray[n + 1];
                    } else if (stringArray[n].equals("node")) {
                        string2 = stringArray[n + 1];
                    } else if (stringArray[n].equals("service")) {
                        string3 = stringArray[n + 1];
                    } else if (stringArray[n].equals("createRegistry")) {
                        string4 = stringArray[n + 1];
                    } else if (stringArray[n].equals("rebind")) {
                        string5 = stringArray[n + 1];
                    } else {
                        throw new IllegalArgumentException("Unrecognised argument " + stringArray[n]);
                    }
                    n += 2;
                }
                try {
                    serializable = Class.forName("java.security.Permission");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.setSecurityManager(new JDSSecurityManager());
                }
                serializable = new JavaDataServerImpl();
                javaDataServerMonitor = new JavaDataServerMonitor();
                if (string != null && string.equals("auto")) {
                    if (string2 != null) {
                        throw new IllegalArgumentException("Cannot specify port=auto for remote node");
                    }
                    if (string4.equals("no")) {
                        throw new IllegalArgumentException("Cannot specify port=auto && createRegistry=no");
                    }
                    object = new ServerSocket(0);
                    string = String.valueOf(((ServerSocket)object).getLocalPort());
                    ((ServerSocket)object).close();
                }
                object = string2 == null && string == null ? "/" + string3 : "rmi://" + (string2 == null ? "" : string2) + (string != null ? ":" + string : "") + "/" + string3;
                if (string4.equals("yes")) {
                    if (string2 != null) {
                        throw new IllegalArgumentException("Cannot specify createRegistry=yes with remote node");
                    }
                    LocateRegistry.createRegistry(string == null ? 1099 : Integer.parseInt(string));
                    System.out.println("Created RMI registry" + (string != null ? " on port " + string : ""));
                } else if (!string4.equals("ifneeded") && !string4.equals("no")) {
                    throw new IllegalArgumentException("Illegal value for createRegistry");
                }
                try {
                    if (string5.equals("yes")) {
                        Naming.rebind((String)object, serializable);
                        break block29;
                    }
                    if (string5.equals("no")) {
                        Naming.bind((String)object, serializable);
                        break block29;
                    }
                    throw new IllegalArgumentException("Illegal value for rebind option");
                }
                catch (ConnectException connectException) {
                    if (string2 != null || !string4.equals("ifneeded")) {
                        throw connectException;
                    }
                    LocateRegistry.createRegistry(string == null ? 1099 : Integer.parseInt(string));
                    System.out.println("Created RMI registry" + (string != null ? " on port " + string : ""));
                    if (string5.equals("yes")) {
                        Naming.rebind((String)object, serializable);
                    }
                    if (!string5.equals("no")) break block29;
                    Naming.bind((String)object, serializable);
                }
            }
            System.out.println("Server bound in RMI registry as " + (String)object);
            object = (String)object + "/Monitor";
            Naming.rebind((String)object, javaDataServerMonitor);
            System.out.println("Monitor bound in RMI registry as " + (String)object);
        }
        catch (Exception exception) {
            throw new NestedException("Error during RMI initialization", exception);
        }
    }
}

