/*
 * Decompiled with CFR 0.152.
 */
package jas.jds;

import hep.analysis.Job;
import hep.analysis.PeerSupport;
import jas.jds.JDSJob;
import jas.jds.RemoteJobAdaptor;
import jas.jds.interfaces.ConnectionRejected;
import jas.jds.interfaces.JavaDataServer;
import jas.jds.interfaces.RemoteClassLoader;
import jas.jds.interfaces.RemoteJob;
import jas.jds.interfaces.Version;
import jas.job.JobJob;
import jas.util.rmi.RMIDestination;
import jas.util.rmi.RemoteEventReceiver;
import java.rmi.RemoteException;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;

class JavaDataServerImpl
extends UnicastRemoteObject
implements JavaDataServer {
    private String m_user;
    private String m_node;

    JavaDataServerImpl() throws RemoteException {
    }

    public boolean openConnection(String string, double d) throws ConnectionRejected {
        double d2 = Version.getVersion();
        if (d != d2) {
            throw new ConnectionRejected("Incompatible protocol version", d2, d);
        }
        this.m_user = string;
        try {
            this.m_node = RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException serverNotActiveException) {
            serverNotActiveException.printStackTrace();
        }
        System.out.println("New connection from " + this.m_user + "@" + this.m_node);
        return JDSJob.countJobs(this.m_user) > 0;
    }

    public String[] listJobs() {
        return JDSJob.listJobs();
    }

    public RemoteJob newJob(String string, RemoteEventReceiver remoteEventReceiver, RMIDestination rMIDestination, RemoteClassLoader remoteClassLoader) throws RemoteException {
        Job job = new Job(string);
        JobJob jobJob = (JobJob)PeerSupport.getPeer((Job)job);
        JDSJob jDSJob = (JDSJob)jobJob.getAbstractJob();
        jDSJob.setOwner(this.m_user, this.m_node);
        RemoteJobAdaptor remoteJobAdaptor = new RemoteJobAdaptor(jDSJob, remoteEventReceiver, rMIDestination, remoteClassLoader);
        return remoteJobAdaptor;
    }

    public RemoteJob connectToJob(String string, RemoteEventReceiver remoteEventReceiver, RMIDestination rMIDestination, RemoteClassLoader remoteClassLoader) throws RemoteException {
        JDSJob jDSJob = JDSJob.findJob(string);
        jDSJob.connect(this.m_user, this.m_node);
        RemoteJobAdaptor remoteJobAdaptor = new RemoteJobAdaptor(jDSJob, remoteEventReceiver, rMIDestination, remoteClassLoader);
        return remoteJobAdaptor;
    }

    public RemoteJob connectToJob(String string, RemoteEventReceiver remoteEventReceiver, RMIDestination rMIDestination) throws RemoteException {
        return this.connectToJob(string, remoteEventReceiver, rMIDestination, null);
    }
}

