/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.normalization.AreaNormalizer;
import jas.hist.normalization.MaxBinNormalizer;
import jas.hist.normalization.Normalizer;
import jas.hist.normalization.RelativeNormalizer;
import jas.hist.normalization.SimpleNormalizer;
import jas.hist.normalization.StatisticsNormalizer;
import jas.hist.test.Gauss;
import jas.hist.test.LiveGauss;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NormalizationTest
extends JPanel
implements ChangeListener,
ActionListener {
    private Normalizer norm = new SimpleNormalizer(1000.0);
    private JASHistData data1;
    private JASHistData data2;
    private static final String[] methods = new String[]{"None", "Area", "MaxBin", "Entries"};
    public static final Class[] noArgc = new Class[0];
    public static final Object[] noArgs = new Object[0];
    static /* synthetic */ Class class$jas$hist$test$NormalizationTest;

    NormalizationTest() {
        super(new BorderLayout());
        JASHist jASHist = new JASHist();
        LiveGauss liveGauss = new LiveGauss("G1", 10000, 100.0, 0.0, 0.0);
        Gauss gauss = new Gauss("G2", 10000, 100.0, 0.0, 0.0);
        this.data2 = jASHist.addData(gauss);
        this.data1 = jASHist.addData(liveGauss);
        this.norm = new RelativeNormalizer(new StatisticsNormalizer(gauss, "Entries"), new StatisticsNormalizer(liveGauss, "Entries"));
        this.data2.show(true);
        this.data1.show(true);
        this.add((Component)jASHist, "Center");
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Normalization Method "));
        JComboBox<String> jComboBox = new JComboBox<String>(methods);
        jComboBox.addActionListener(this);
        jPanel.add(jComboBox);
        this.add((Component)jPanel, "South");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Normalization Test");
        jFrame.setContentPane(new NormalizationTest());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.pack();
        jFrame.show();
        try {
            Class clazz = class$jas$hist$test$NormalizationTest == null ? (class$jas$hist$test$NormalizationTest = NormalizationTest.class$("jas.hist.test.NormalizationTest")) : class$jas$hist$test$NormalizationTest;
            Class<?> clazz2 = Class.forName("jasext.hist.Register");
            Method method = clazz2.getMethod("init", noArgc);
            Object obj = clazz2.newInstance();
            method.invoke(obj, noArgs);
        }
        catch (Throwable throwable) {
            System.err.println("Unable to register functions/fitters");
            throwable.printStackTrace();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = ((JSlider)changeEvent.getSource()).getValue();
        double d = Math.pow(10.0, (double)n / 100.0);
        System.out.println("v=" + n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = ((JComboBox)actionEvent.getSource()).getSelectedItem();
        if (methods[0].equals(object)) {
            this.data1.setNormalization(null);
            this.data2.setNormalization(null);
        } else if (methods[1].equals(object)) {
            this.data1.setNormalization(new AreaNormalizer((Rebinnable1DHistogramData)this.data1.getDataSource()));
            this.data2.setNormalization(new AreaNormalizer((Rebinnable1DHistogramData)this.data2.getDataSource()));
        } else if (methods[2].equals(object)) {
            this.data1.setNormalization(new MaxBinNormalizer((Rebinnable1DHistogramData)this.data1.getDataSource()));
            this.data2.setNormalization(new MaxBinNormalizer((Rebinnable1DHistogramData)this.data2.getDataSource()));
        } else if (methods[3].equals(object)) {
            this.data1.setNormalization(new StatisticsNormalizer(this.data1.getDataSource(), "Entries"));
            this.data2.setNormalization(new StatisticsNormalizer(this.data2.getDataSource(), "Entries"));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

