/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DateTransformationConverter;
import jas.hist.JASHist2DHistogramData;
import jas.plot.CoordinateTransformation;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.MutableLegendEntry;
import jas.plot.Overlay;
import jas.plot.OverlayContainer;
import jas.plot.PlotGraphics;
import java.awt.Color;
import java.awt.Graphics;

class TwoDOverlay
implements Overlay,
MutableLegendEntry {
    private double[][] data;
    private int xBins;
    private double xLow;
    private double xHigh;
    private double binWidth;
    private int yBins;
    private double yLow;
    private double yHigh;
    private double binHeight;
    private double zmax;
    private double zmin;
    protected OverlayContainer container;
    private Color color = Color.black;
    private JASHist2DHistogramData parent;

    TwoDOverlay(JASHist2DHistogramData jASHist2DHistogramData) {
        this.parent = jASHist2DHistogramData;
    }

    void setData(double[][] dArray, double d, double d2, double d3, double d4, int n, int n2) {
        this.data = dArray;
        this.xBins = n;
        this.yBins = n2;
        this.xLow = d;
        this.xHigh = d2;
        this.yLow = d3;
        this.yHigh = d4;
        this.binWidth = (d2 - d) / (double)n;
        this.binHeight = (d4 - d3) / (double)n2;
    }

    void setZMinMax(double d, double d2) {
        this.zmin = d;
        this.zmax = d2;
    }

    public void paintIcon(Graphics graphics, int n, int n2) {
        graphics.setColor(this.parent.style.getShapeColor());
        graphics.fillRect(1, 1, n - 2, n2 - 2);
    }

    public String getTitle() {
        return this.parent.getLegendText();
    }

    public void setTitle(String string) {
        this.parent.setLegendText(string);
    }

    public boolean titleIsChanged() {
        return this.parent.isLegendChanged();
    }

    public void paint(PlotGraphics plotGraphics) {
        int n = this.parent.style.getHistStyle();
        int n2 = this.parent.style.getColorMapScheme();
        boolean bl = false;
        if (this.data == null) {
            return;
        }
        int n3 = this.xBins;
        int n4 = this.yBins;
        CoordinateTransformation coordinateTransformation = this.container.getXTransformation();
        CoordinateTransformation coordinateTransformation2 = this.container.getYTransformation();
        if (coordinateTransformation instanceof DateCoordinateTransformation) {
            coordinateTransformation = new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation);
        }
        if (coordinateTransformation instanceof DoubleCoordinateTransformation && coordinateTransformation2 instanceof DoubleCoordinateTransformation) {
            double d;
            DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)coordinateTransformation;
            DoubleCoordinateTransformation doubleCoordinateTransformation2 = (DoubleCoordinateTransformation)coordinateTransformation2;
            plotGraphics.setTransformation(doubleCoordinateTransformation, doubleCoordinateTransformation2);
            if (n == 0 || n == 1) {
                plotGraphics.setColor(Color.white);
            } else {
                if (n2 == 0) {
                    plotGraphics.setColor(Color.red);
                } else if (n2 == 1 || n2 == 3) {
                    plotGraphics.setColor(Color.blue);
                } else if (n2 == 2 || n2 == 4) {
                    plotGraphics.setColor(Color.black);
                } else if (n2 == 5) {
                    plotGraphics.setColor(this.parent.style.getStartDataColor());
                }
                plotGraphics.fillRect(this.xLow, this.yHigh, this.xHigh, this.yLow);
            }
            if ((n == 0 || n == 1) && bl) {
                plotGraphics.setColor(Color.black);
                plotGraphics.drawLine(doubleCoordinateTransformation.convert(this.xLow + this.binWidth), doubleCoordinateTransformation2.convert(this.yLow), doubleCoordinateTransformation.convert(this.xLow + this.binWidth), doubleCoordinateTransformation2.convert(this.yHigh));
                plotGraphics.drawLine(doubleCoordinateTransformation.convert(this.xHigh - this.binWidth), doubleCoordinateTransformation2.convert(this.yLow), doubleCoordinateTransformation.convert(this.xHigh - this.binWidth), doubleCoordinateTransformation2.convert(this.yHigh));
                plotGraphics.drawLine(doubleCoordinateTransformation.convert(this.xLow), doubleCoordinateTransformation2.convert(this.yLow + this.binHeight), doubleCoordinateTransformation.convert(this.xHigh), doubleCoordinateTransformation2.convert(this.yLow + this.binHeight));
                plotGraphics.drawLine(doubleCoordinateTransformation.convert(this.xLow), doubleCoordinateTransformation2.convert(this.yHigh - this.binHeight), doubleCoordinateTransformation.convert(this.xHigh), doubleCoordinateTransformation2.convert(this.yHigh - this.binHeight));
            }
            double d2 = this.zmin;
            double d3 = this.zmax;
            if (d2 > 0.0 && d3 > 0.0) {
                d2 = 0.0;
            }
            if (d2 < 0.0 && d3 < 0.0) {
                d3 = 0.0;
            }
            if ((d = d3 - d2) > 0.0) {
                if (n == 0 || n == 1) {
                    plotGraphics.setColor(this.parent.style.getShapeColor());
                    double d4 = this.yLow - this.binHeight / 2.0;
                    int n5 = 0;
                    while (n5 < n4) {
                        d4 += this.binHeight;
                        double d5 = this.xLow - this.binWidth / 2.0;
                        int n6 = 0;
                        while (n6 < n3) {
                            d5 += this.binWidth;
                            double d6 = Math.sqrt((this.data[n6][n5] - d2) / d);
                            double d7 = this.binWidth * d6 / 2.0;
                            double d8 = this.binHeight * d6 / 2.0;
                            if (d6 != 0.0) {
                                if (n == 0) {
                                    plotGraphics.drawRect(d5 - d7, d4 - d8, d5 + d7, d4 + d8);
                                } else {
                                    plotGraphics.drawOval(d5 - d7, d4 - d8, d5 + d7, d4 + d8);
                                }
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                } else {
                    double d9 = this.yLow;
                    int n7 = 0;
                    while (n7 < n4) {
                        double d10 = d9 + this.binHeight;
                        double d11 = this.xLow;
                        int n8 = 0;
                        while (n8 < n3) {
                            double d12 = d11 + this.binWidth;
                            double d13 = (this.data[n8][n7] - d2) / d;
                            plotGraphics.setColor(this.getHistColor(n2, d13));
                            plotGraphics.fillRect(d11, d9, d12, d10);
                            d11 = d12;
                            ++n8;
                        }
                        d9 = d10;
                        ++n7;
                    }
                }
            } else if (d == 0.0) {
                // empty if block
            }
        }
    }

    private Color getHistColor(int n, double d) {
        int n2 = n;
        double d2 = d;
        if (n2 == 0) {
            if (d == 0.0) {
                return new Color(255, 0, 0);
            }
            if (d == 1.0) {
                return new Color(255, 255, 0);
            }
            return new Color(255, 155 + (int)(100.0 * d), 0);
        }
        if (n2 == 1) {
            if (d2 == 0.0) {
                return new Color(0, 0, 255);
            }
            if (d2 == 1.0) {
                return new Color(0, 255, 255);
            }
            return new Color(0, 155 + (int)(100.0 * d), 255);
        }
        if (n2 == 2) {
            if (d == 0.0) {
                return new Color(0, 0, 0);
            }
            if (d == 1.0) {
                return new Color(255, 0, 0);
            }
            return new Color(155 + (int)(100.0 * d), 0, 0);
        }
        if (n2 == 3) {
            if (d == 0.0) {
                return new Color(0, 0, 255);
            }
            if (d > 0.0 && d <= 0.3) {
                return new Color(0, 0, 155 + (int)(100.0 * d));
            }
            if (d > 0.3 && d <= 0.6) {
                return new Color(0, 155 + (int)(100.0 * d), 0);
            }
            if (d > 0.6 && d <= 0.9) {
                return new Color(155 + (int)(100.0 * d), 0, 0);
            }
            return new Color(255, 255, 0);
        }
        if (n2 == 4) {
            if (d == 0.0) {
                return new Color(0, 0, 0);
            }
            if (d == 1.0) {
                return new Color(255, 255, 255);
            }
            return new Color(155 + (int)(100.0 * d), 155 + (int)(100.0 * d), 155 + (int)(100.0 * d));
        }
        int n3 = this.parent.style.getStartDataColor().getRed() > this.parent.style.getEndDataColor().getRed() ? this.parent.style.getStartDataColor().getRed() - (int)((double)(this.parent.style.getStartDataColor().getRed() - this.parent.style.getEndDataColor().getRed()) * d) : (this.parent.style.getStartDataColor().getRed() < this.parent.style.getEndDataColor().getRed() ? this.parent.style.getStartDataColor().getRed() + (int)((double)(this.parent.style.getEndDataColor().getRed() - this.parent.style.getStartDataColor().getRed()) * d) : this.parent.style.getStartDataColor().getRed());
        int n4 = this.parent.style.getStartDataColor().getGreen() > this.parent.style.getEndDataColor().getGreen() ? this.parent.style.getStartDataColor().getGreen() - (int)((double)(this.parent.style.getStartDataColor().getGreen() - this.parent.style.getEndDataColor().getGreen()) * d) : (this.parent.style.getStartDataColor().getGreen() < this.parent.style.getEndDataColor().getGreen() ? this.parent.style.getStartDataColor().getGreen() + (int)((double)(this.parent.style.getEndDataColor().getGreen() - this.parent.style.getStartDataColor().getGreen()) * d) : this.parent.style.getStartDataColor().getGreen());
        int n5 = this.parent.style.getStartDataColor().getBlue() > this.parent.style.getEndDataColor().getBlue() ? this.parent.style.getStartDataColor().getBlue() - (int)((double)(this.parent.style.getStartDataColor().getBlue() - this.parent.style.getEndDataColor().getBlue()) * d) : (this.parent.style.getStartDataColor().getBlue() < this.parent.style.getEndDataColor().getBlue() ? this.parent.style.getStartDataColor().getBlue() + (int)((double)(this.parent.style.getEndDataColor().getBlue() - this.parent.style.getStartDataColor().getBlue()) * d) : this.parent.style.getStartDataColor().getBlue());
        if (d == 0.0) {
            return this.parent.style.getStartDataColor();
        }
        if (d == 1.0) {
            return this.parent.style.getEndDataColor();
        }
        return new Color(n3, n4, n5);
    }

    public void containerNotify(OverlayContainer overlayContainer) {
        this.container = overlayContainer;
    }
}

