/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DataSource;
import jas.hist.DataSourceMenuFactory;
import jas.hist.HasScatterPlotData;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist;
import jas.hist.JASHist2DHistogramData;
import jas.hist.JASHist2DHistogramStyle;
import jas.hist.JASHist2DScatterData;
import jas.hist.JASHistData;
import jas.hist.JASHistScatterPlotData;
import jas.hist.JASHistScatterPlotStyle;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.ScatterPlotSource;
import jas.hist.SpecialComponent;
import jas.hist.StatisticsBlock;
import jas.hist.TwoDDataManager;
import jas.plot.DataArea;
import jas.plot.DoubleAxis;
import jas.plot.Legend;
import jas.plot.LegendEntry;
import jas.util.ColorMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.DefaultColorSelectionModel;

abstract class ScatterDataManager
extends TwoDDataManager {
    private int oldStyle = -1;
    private final int m_defaultNumberOfBins;
    protected transient double xLow;
    protected transient double xHigh;
    protected transient double yLow;
    protected transient double yHigh;
    private DoubleAxis xAxis = new DoubleAxis();
    private DoubleAxis yAxis = new DoubleAxis();
    private transient boolean styleChanged;
    private SizeMenu m_sizeMenu;
    private StyleMenu m_styleMenu;
    private static boolean enabled3d;

    ScatterDataManager(JASHist jASHist, DataArea dataArea, Legend legend, StatisticsBlock statisticsBlock) {
        super(jASHist, dataArea, legend, statisticsBlock);
        this.m_defaultNumberOfBins = 40;
        this.xm.setDataManager(this, true, this.xAxis);
        this.ym[0].setDataManager(this, true, this.yAxis);
        this.xm.setBins(this.m_defaultNumberOfBins);
        this.ym[0].setBins(this.m_defaultNumberOfBins);
    }

    void styleUpdate(JASHistData jASHistData) {
        this.styleChanged = true;
        JASHist2DHistogramStyle jASHist2DHistogramStyle = (JASHist2DHistogramStyle)jASHistData.getStyle();
        if (this.oldStyle != jASHist2DHistogramStyle.getHistStyle()) {
            boolean bl = jASHist2DHistogramStyle.getHistStyle() == 3;
            boolean bl2 = jASHist2DHistogramStyle.getHistStyle() == 4;
            try {
                if (bl) {
                    Class<?> clazz = Class.forName("gov.fnal.plot3d.jas.SpecialLego");
                    SpecialComponent specialComponent = (SpecialComponent)clazz.newInstance();
                    specialComponent.setData(jASHistData.getDataSource());
                    this.da.setSpecialComponent(specialComponent.getDisplayComponent());
                } else if (bl2) {
                    Class<?> clazz = Class.forName("gov.fnal.plot3d.jas.SpecialSurface");
                    SpecialComponent specialComponent = (SpecialComponent)clazz.newInstance();
                    specialComponent.setData(jASHistData.getDataSource());
                    this.da.setSpecialComponent(specialComponent.getDisplayComponent());
                } else {
                    this.da.setSpecialComponent(null);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.da.setSpecialComponent(null);
            }
            this.oldStyle = jASHist2DHistogramStyle.getHistStyle();
        }
        SwingUtilities.invokeLater(this);
    }

    final void init() {
        this.computeXAxisRange();
        this.XAxisUpdated();
        this.computeYAxisRange();
        this.YAxisUpdated();
        this.computeZAxisRange();
        this.isInit = true;
    }

    void axisChanged(JASHistData jASHistData) {
        int n = jASHistData.getYAxis();
        if (this.ym[n] == null) {
            this.createYAxis(n);
            ((DoubleAxis)this.ym[n].getType()).setUseSuggestedRange(false);
        } else {
            this.ym[n].setAttentionNeeded();
        }
        SwingUtilities.invokeLater(this);
    }

    void update(HistogramUpdate histogramUpdate, JASHistData jASHistData) {
        JASHist2DHistogramData jASHist2DHistogramData = (JASHist2DHistogramData)jASHistData;
        int n = jASHist2DHistogramData.getYAxis();
        if (histogramUpdate.isRangeUpdate()) {
            if (histogramUpdate.axisIsSet(0)) {
                this.xm.setAttentionNeeded();
            }
            if (histogramUpdate.axisIsSet(1)) {
                this.ym[n].setAttentionNeeded();
            }
        } else if (histogramUpdate.isReset() || histogramUpdate.isDataUpdate()) {
            // empty if block
        }
        if (histogramUpdate.isFinalUpdate() || histogramUpdate.isReset()) {
            SwingUtilities.invokeLater(this);
        } else {
            this.timer.start();
        }
    }

    protected void doUpdate() {
        if (this.isInit) {
            int n;
            boolean bl = false;
            if (this.xm.needsAttention()) {
                this.computeXAxisRange();
                this.XAxisUpdated();
                bl = true;
            }
            if (this.ym[n = 0].needsAttention()) {
                this.computeYAxisRange();
                this.YAxisUpdated();
                bl = true;
            }
            this.computeZAxisRange();
            Enumeration enumeration = this.data.elements();
            while (enumeration.hasMoreElements()) {
                boolean bl2;
                Object e = enumeration.nextElement();
                if (!(e instanceof JASHist2DScatterData)) continue;
                JASHist2DScatterData jASHist2DScatterData = (JASHist2DScatterData)e;
                boolean bl3 = bl2 = bl || jASHist2DScatterData.resetSent || jASHist2DScatterData.onNewAxis;
                if (bl2 || this.styleChanged) {
                    jASHist2DScatterData.restartImage(bl2);
                    jASHist2DScatterData.onNewAxis = false;
                    jASHist2DScatterData.resetSent = false;
                    continue;
                }
                if (!jASHist2DScatterData.dataChanged) continue;
                jASHist2DScatterData.continueImage();
                jASHist2DScatterData.dataChanged = false;
            }
            this.da.validate();
            this.da.repaint();
            this.styleChanged = false;
        }
    }

    JASHistData add(DataSource dataSource) {
        this.da.setSpecialComponent(null);
        this.oldStyle = -1;
        if (dataSource instanceof HasScatterPlotData && ((HasScatterPlotData)dataSource).hasScatterPlotData()) {
            HasScatterPlotData hasScatterPlotData = (HasScatterPlotData)dataSource;
            JASHist2DScatterData jASHist2DScatterData = new JASHist2DScatterData((DataManager)this, hasScatterPlotData);
            this.data.addElement(jASHist2DScatterData);
            return jASHist2DScatterData;
        }
        if (dataSource instanceof Rebinnable2DHistogramData) {
            Rebinnable2DHistogramData rebinnable2DHistogramData = (Rebinnable2DHistogramData)dataSource;
            JASHist2DHistogramData jASHist2DHistogramData = new JASHist2DHistogramData(this, rebinnable2DHistogramData);
            this.data.addElement(jASHist2DHistogramData);
            return jASHist2DHistogramData;
        }
        if (dataSource instanceof ScatterPlotSource) {
            ScatterPlotSource scatterPlotSource = (ScatterPlotSource)dataSource;
            JASHistScatterPlotData jASHistScatterPlotData = new JASHistScatterPlotData((DataManager)this, scatterPlotSource);
            this.data.addElement(jASHistScatterPlotData);
            return jASHistScatterPlotData;
        }
        throw new RuntimeException("Unknown subtype of DataSource added to ScatterDataManager");
    }

    void computeXAxisRange() {
        if (!this.xm.needsAttention()) {
            return;
        }
        this.xm.payingAttention();
        if (this.data.isEmpty()) {
            return;
        }
        if (!this.xm.getRangeAutomatic() || this.xm.isFixed()) {
            this.xLow = this.xm.getMin();
            this.xHigh = this.xm.getMax();
            return;
        }
        int n = 0;
        this.xLow = 0.0;
        this.xHigh = 0.0;
        boolean bl = false;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            JASHist2DHistogramData jASHist2DHistogramData = (JASHist2DHistogramData)enumeration.nextElement();
            if (!jASHist2DHistogramData.isShowing()) continue;
            if (n++ == 0) {
                this.xLow = jASHist2DHistogramData.getXMin();
                this.xHigh = jASHist2DHistogramData.getXMax();
            } else {
                this.xLow = Math.min(this.xLow, jASHist2DHistogramData.getXMin());
                this.xHigh = Math.max(this.xHigh, jASHist2DHistogramData.getXMax());
            }
            if (!jASHist2DHistogramData.isRebinnable()) continue;
            bl = true;
        }
        if (n == 0) {
            return;
        }
        this.xm.setBinned(bl);
        if (!this.xm.getAllowSuppressedZero()) {
            if (this.xLow > 0.0) {
                this.xLow = 0.0;
            }
            if (this.xHigh < 0.0) {
                this.xHigh = 0.0;
            }
        }
        if (this.xHigh <= this.xLow) {
            this.xHigh = this.xLow + 1.0;
        }
        this.calcMinMaxXBins(this.xLow, this.xHigh);
    }

    protected void calcMinMaxXBins(double d, double d2) {
        double d3 = this.xAxis.getPlotMin();
        double d4 = this.xAxis.getPlotMax();
        if (d != d3 || d2 != d4) {
            this.xAxis.setMin(d);
            this.xAxis.setMax(d2);
            this.xm.invalidate();
        }
    }

    void computeYAxisRange() {
        int n = 0;
        if (!this.ym[n].needsAttention()) {
            return;
        }
        this.ym[n].payingAttention();
        if (this.data.isEmpty()) {
            return;
        }
        if (!this.ym[n].getRangeAutomatic() || this.ym[n].isFixed()) {
            this.yLow = this.ym[n].getMin();
            this.yHigh = this.ym[n].getMax();
            return;
        }
        int n2 = 0;
        this.yLow = 0.0;
        this.yHigh = 0.0;
        boolean bl = false;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            JASHist2DHistogramData jASHist2DHistogramData = (JASHist2DHistogramData)enumeration.nextElement();
            if (!jASHist2DHistogramData.isShowing()) continue;
            if (n2++ == 0) {
                this.yLow = jASHist2DHistogramData.getYMin();
                this.yHigh = jASHist2DHistogramData.getYMax();
            } else {
                this.yLow = Math.min(this.yLow, jASHist2DHistogramData.getYMin());
                this.yHigh = Math.max(this.yHigh, jASHist2DHistogramData.getYMax());
            }
            if (!jASHist2DHistogramData.isRebinnable()) continue;
            bl = true;
        }
        if (n2 == 0) {
            return;
        }
        this.ym[n].setBinned(bl);
        if (!this.ym[n].getAllowSuppressedZero()) {
            if (this.yLow > 0.0) {
                this.yLow = 0.0;
            }
            if (this.yHigh < 0.0) {
                this.yHigh = 0.0;
            }
        }
        if (this.yHigh <= this.yLow) {
            this.yHigh = this.yLow + 1.0;
        }
        this.calcMinMaxYBins(this.yLow, this.yHigh);
    }

    protected void calcMinMaxYBins(double d, double d2) {
        double d3 = this.yAxis.getPlotMin();
        double d4 = this.yAxis.getPlotMax();
        if (d != d3 || d2 != d4) {
            this.yAxis.setMin(d);
            this.yAxis.setMax(d2);
            this.ym[0].invalidate();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.data = new Vector();
    }

    final void requestShow(JASHistData jASHistData) {
        LegendEntry legendEntry;
        this.da.add(jASHistData.getOverlay());
        ++this.nVisible;
        if (this.legend != null && (legendEntry = jASHistData.getLegendEntry()) != null) {
            this.legend.add(legendEntry);
            ++this.nVisibleLegend;
            this.showLegend();
        }
        if (this.stats != null) {
            this.stats.add(jASHistData);
        }
        if (this.isInit) {
            this.xm.setAttentionNeeded();
            this.computeXAxisRange();
            this.XAxisUpdated();
            this.ym[0].setAttentionNeeded();
            this.computeYAxisRange();
            this.YAxisUpdated();
            this.computeZAxisRange();
            this.da.revalidate();
            this.da.repaint();
        }
    }

    void requestHide(JASHistData jASHistData) {
        LegendEntry legendEntry;
        this.da.remove(jASHistData.getOverlay());
        --this.nVisible;
        if (this.legend != null && (legendEntry = jASHistData.getLegendEntry()) != null) {
            this.legend.remove(legendEntry);
            --this.nVisibleLegend;
            this.showLegend();
        }
        if (this.stats != null) {
            this.stats.remove(jASHistData);
        }
        if (this.isInit) {
            this.xm.setAttentionNeeded();
            this.computeXAxisRange();
            this.XAxisUpdated();
            this.ym[0].setAttentionNeeded();
            this.computeYAxisRange();
            this.YAxisUpdated();
            this.computeZAxisRange();
            this.da.revalidate();
            this.da.repaint();
        }
    }

    void XAxisUpdated() {
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            JASHist2DHistogramData jASHist2DHistogramData = (JASHist2DHistogramData)enumeration.nextElement();
            if (!jASHist2DHistogramData.isShowing()) continue;
            jASHist2DHistogramData.setXRange(this.xm.getBins(), this.xLow, this.xHigh);
        }
    }

    void YAxisUpdated() {
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            JASHist2DHistogramData jASHist2DHistogramData = (JASHist2DHistogramData)enumeration.nextElement();
            if (!jASHist2DHistogramData.isShowing()) continue;
            jASHist2DHistogramData.setYRange(this.ym[0].getBins(), this.yLow, this.yHigh);
        }
    }

    private final void computeZAxisRange() {
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            JASHist2DHistogramData jASHist2DHistogramData = (JASHist2DHistogramData)enumeration.nextElement();
            if (!jASHist2DHistogramData.isShowing()) continue;
            jASHist2DHistogramData.calcZLimits();
        }
    }

    private void restartImages() {
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            try {
                JASHist2DScatterData jASHist2DScatterData = (JASHist2DScatterData)enumeration.nextElement();
                if (!jASHist2DScatterData.isVisible) continue;
                jASHist2DScatterData.restartImage(false);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    final void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        Serializable serializable;
        Object object;
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        Enumeration enumeration = this.getDataSources();
        while (enumeration.hasMoreElements()) {
            object = (JASHistData)enumeration.nextElement();
            if (!(object instanceof JASHist2DScatterData) || !((JASHist2DScatterData)object).hasScatterPlotData()) continue;
            bl = true;
            serializable = (JASHistScatterPlotStyle)((JASHistData)object).getStyle();
            if (((JASHistScatterPlotStyle)serializable).getDisplayAsScatterPlot()) {
                bl3 = false;
                continue;
            }
            bl2 = false;
        }
        if (bl) {
            object = new JRadioButtonMenuItem("Display As Scatter Plot");
            serializable = new JRadioButtonMenuItem("Display As Binned Plot");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)object);
            buttonGroup.add((AbstractButton)serializable);
            ((AbstractButton)object).setSelected(bl2);
            ((AbstractButton)serializable).setSelected(bl3);
            ((AbstractButton)object).addActionListener(new ScatterActionListener(true));
            ((AbstractButton)serializable).addActionListener(new ScatterActionListener(false));
            jPopupMenu.add((JMenuItem)object);
            jPopupMenu.add((JMenuItem)serializable);
        }
        if (!bl || !bl2) {
            jPopupMenu.add(this.addPerDataSourceMenu("Plot Style", new DataSourceMenuFactory(){

                public JMenu createMenu(String string, JASHistData jASHistData) {
                    return new StyleMenu(string, jASHistData);
                }
            }));
        }
        if (bl && !bl3) {
            if (this.m_sizeMenu == null) {
                this.m_sizeMenu = new SizeMenu();
            }
            this.m_sizeMenu.init();
            jPopupMenu.add(this.m_sizeMenu);
            jPopupMenu.add(this.addPerDataSourceMenu("Point Color", new DataSourceMenuFactory(){

                public JMenu createMenu(String string, JASHistData jASHistData) {
                    JASHistScatterPlotStyle jASHistScatterPlotStyle = (JASHistScatterPlotStyle)jASHistData.getStyle();
                    DefaultColorSelectionModel defaultColorSelectionModel = new DefaultColorSelectionModel(this, jASHistScatterPlotStyle){
                        private final /* synthetic */ JASHistScatterPlotStyle val$style;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$style = jASHistScatterPlotStyle;
                        }

                        public Color getSelectedColor() {
                            return this.val$style.getDataPointColor();
                        }

                        public void setSelectedColor(Color color) {
                            this.val$style.setDataPointColor(color);
                        }
                    };
                    return new ColorMenu(string, defaultColorSelectionModel, true);
                }
            }));
        }
        super.modifyPopupMenu(jPopupMenu, component);
    }

    static {
        try {
            Class.forName("javax.media.j3d.Canvas3D");
            Class.forName("gov.fnal.plot3d.jas.SpecialLego");
            Class.forName("gov.fnal.plot3d.jas.SpecialSurface");
            enabled3d = true;
        }
        catch (Throwable throwable) {
            enabled3d = false;
        }
    }

    private final class StyleMenu
    extends JMenu {
        ButtonGroup group = new ButtonGroup();
        JASHistData data;

        public StyleMenu(String string, JASHistData jASHistData) {
            super(string);
            this.data = jASHistData;
            JMenu jMenu = new JMenu("Color Map");
            jMenu.setMnemonic('M');
            this.add(this.addButton("Box", 'B', 0, -1));
            this.add(this.addButton("Ellipse", 'E', 1, -1));
            if (enabled3d) {
                this.add(this.addButton("3D Lego Plot", 'L', 3, -1));
                this.add(this.addButton("3D Surface Plot", 'S', 4, -1));
            }
            this.add(jMenu);
            jMenu.add(this.addButton("Warm", 'W', 2, 0));
            jMenu.add(this.addButton("Cool", 'C', 2, 1));
            jMenu.add(this.addButton("Thermal", 'T', 2, 2));
            jMenu.add(this.addButton("Rainbow", 'B', 2, 3));
            jMenu.add(this.addButton("Gray Scale", 'G', 2, 4));
            this.init();
        }

        private JRadioButtonMenuItem addButton(String string, char c, int n, int n2) {
            StyleButton styleButton = new StyleButton(string, n, n2);
            styleButton.setMnemonic(c);
            this.group.add(styleButton);
            return styleButton;
        }

        private void init() {
            int n = -1;
            int n2 = -1;
            JASHist2DHistogramStyle jASHist2DHistogramStyle = (JASHist2DHistogramStyle)this.data.getStyle();
            n = jASHist2DHistogramStyle.getHistStyle();
            n2 = jASHist2DHistogramStyle.getColorMapScheme();
            Enumeration<AbstractButton> enumeration = this.group.getElements();
            while (enumeration.hasMoreElements()) {
                StyleButton styleButton = (StyleButton)enumeration.nextElement();
                styleButton.setStyle(n, n2);
            }
        }

        final class StyleButton
        extends JRadioButtonMenuItem {
            private int iStyle;
            private int cStyle;

            StyleButton(String string, int n, int n2) {
                super(string);
                this.iStyle = n;
                this.cStyle = n2;
            }

            public void fireActionPerformed(ActionEvent actionEvent) {
                JASHist2DHistogramStyle jASHist2DHistogramStyle = (JASHist2DHistogramStyle)StyleMenu.this.data.getStyle();
                jASHist2DHistogramStyle.setHistStyle(this.iStyle);
                if (this.cStyle >= 0) {
                    jASHist2DHistogramStyle.setColorMapScheme(this.cStyle);
                }
            }

            void setStyle(int n, int n2) {
                this.setSelected(this.iStyle == n && (this.cStyle == -1 || this.cStyle == n2));
            }
        }
    }

    final class SizeButton
    extends JRadioButtonMenuItem {
        private int size;

        SizeButton(String string, int n) {
            super(string);
            this.size = n;
        }

        public void fireActionPerformed(ActionEvent actionEvent) {
            Enumeration enumeration = ScatterDataManager.this.getDataSources();
            while (enumeration.hasMoreElements()) {
                JASHistData jASHistData = (JASHistData)enumeration.nextElement();
                JASHistScatterPlotStyle jASHistScatterPlotStyle = (JASHistScatterPlotStyle)jASHistData.getStyle();
                jASHistScatterPlotStyle.setDataPointSize(this.size);
            }
        }

        void setSize(int n) {
            this.setSelected(this.size == n);
        }
    }

    private final class SizeMenu
    extends JMenu {
        ButtonGroup group = new ButtonGroup();

        public SizeMenu() {
            super("Point Size");
            this.setMnemonic('S');
            this.addButton("Huge", 'H', 20);
            this.addButton("Large", 'L', 10);
            this.addButton("Medium", 'M', 5);
            this.addButton("Small", 'S', 3);
            this.addButton("Tiny", 'T', 1);
        }

        private void addButton(String string, char c, int n) {
            SizeButton sizeButton = new SizeButton(string, n);
            sizeButton.setMnemonic(c);
            this.group.add(sizeButton);
            this.add(sizeButton);
        }

        public void init() {
            Serializable serializable;
            Object object;
            int n = -1;
            Enumeration enumeration = ScatterDataManager.this.getDataSources();
            while (enumeration.hasMoreElements()) {
                object = (JASHistData)enumeration.nextElement();
                if (!(object instanceof JASHist2DScatterData)) continue;
                serializable = (JASHistScatterPlotStyle)((JASHistData)object).getStyle();
                if (n == -1) {
                    n = ((JASHistScatterPlotStyle)serializable).getDataPointSize();
                    continue;
                }
                if (n == ((JASHistScatterPlotStyle)serializable).getDataPointSize()) continue;
                n = -2;
            }
            object = this.group.getElements();
            while (object.hasMoreElements()) {
                serializable = (SizeButton)object.nextElement();
                ((SizeButton)serializable).setSize(n);
            }
        }
    }

    private final class ScatterActionListener
    implements ActionListener {
        private boolean state;

        ScatterActionListener(boolean bl) {
            this.state = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Enumeration enumeration = ScatterDataManager.this.getDataSources();
            while (enumeration.hasMoreElements()) {
                JASHistData jASHistData = (JASHistData)enumeration.nextElement();
                if (!(jASHistData instanceof JASHist2DScatterData)) continue;
                JASHistScatterPlotStyle jASHistScatterPlotStyle = (JASHistScatterPlotStyle)jASHistData.getStyle();
                jASHistScatterPlotStyle.setDisplayAsScatterPlot(this.state);
            }
        }
    }
}

