/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataSource;
import jas.hist.Handle;
import jas.hist.HasHandles;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.Overlay;
import jas.plot.OverlayContainer;
import jas.plot.PlotGraphics;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

abstract class OverlayWithHandles
implements Overlay,
MouseListener,
MouseMotionListener {
    private static final double handleSize = 2.5;
    private HandleWrapper[] handles = null;
    private HandleWrapper currentHandle = null;
    private HandleWrapper capturedHandle = null;
    private HasHandles hasHandles;
    protected OverlayContainer container;

    OverlayWithHandles(DataSource dataSource) {
        if (dataSource instanceof HasHandles) {
            this.hasHandles = (HasHandles)((Object)dataSource);
        }
    }

    public void paint(PlotGraphics plotGraphics) {
        if (this.handles != null) {
            DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)this.container.getXTransformation();
            DoubleCoordinateTransformation doubleCoordinateTransformation2 = (DoubleCoordinateTransformation)this.container.getYTransformation();
            plotGraphics.clearTransformation();
            int n = 0;
            while (n < this.handles.length) {
                this.handles[n].paint(plotGraphics, doubleCoordinateTransformation, doubleCoordinateTransformation2);
                ++n;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)this.container.getXTransformation();
        DoubleCoordinateTransformation doubleCoordinateTransformation2 = (DoubleCoordinateTransformation)this.container.getYTransformation();
        Handle[] handleArray = this.hasHandles.getHandles(doubleCoordinateTransformation.getPlotMin(), doubleCoordinateTransformation.getPlotMax(), doubleCoordinateTransformation2.getPlotMin(), doubleCoordinateTransformation2.getPlotMax());
        this.handles = new HandleWrapper[handleArray.length];
        int n = 0;
        while (n < this.handles.length) {
            this.handles[n] = new HandleWrapper(handleArray[n]);
            ++n;
        }
        this.container.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.handles = null;
        this.container.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = 0;
        while (n < this.handles.length) {
            if (this.handles[n].contains(point)) {
                this.setCurrentHandle(this.handles[n]);
                return;
            }
            ++n;
        }
        this.setCurrentHandle(null);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.currentHandle != null) {
            this.captureHandle(this.currentHandle);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.captureHandle(null);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.capturedHandle != null) {
            this.capturedHandle.moveTo(mouseEvent.getPoint());
            this.container.repaint();
        }
    }

    public void containerNotify(OverlayContainer overlayContainer) {
        if (this.container != null) {
            this.container.removeMouseListener(this);
            this.container.removeMouseMotionListener(this);
        }
        this.container = overlayContainer;
        if (overlayContainer != null && this.hasHandles != null) {
            overlayContainer.addMouseListener(this);
            overlayContainer.addMouseMotionListener(this);
        }
    }

    private void setCurrentHandle(HandleWrapper handleWrapper) {
        if (this.currentHandle != handleWrapper) {
            this.currentHandle = handleWrapper;
            this.container.repaint();
        }
    }

    private void captureHandle(HandleWrapper handleWrapper) {
        if (this.capturedHandle != handleWrapper) {
            this.capturedHandle = handleWrapper;
            this.container.repaint();
        }
    }

    private class HandleWrapper {
        private Handle handle;

        HandleWrapper(Handle handle) {
            this.handle = handle;
        }

        void paint(PlotGraphics plotGraphics, DoubleCoordinateTransformation doubleCoordinateTransformation, DoubleCoordinateTransformation doubleCoordinateTransformation2) {
            double d = doubleCoordinateTransformation.convert(this.handle.getX());
            double d2 = doubleCoordinateTransformation2.convert(this.handle.getY());
            plotGraphics.setColor(this == OverlayWithHandles.this.currentHandle ? Color.red : Color.black);
            plotGraphics.fillRect(d - 2.5, d2 - 2.5, d + 2.5, d2 + 2.5);
        }

        boolean contains(Point point) {
            DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)OverlayWithHandles.this.container.getXTransformation();
            DoubleCoordinateTransformation doubleCoordinateTransformation2 = (DoubleCoordinateTransformation)OverlayWithHandles.this.container.getYTransformation();
            double d = doubleCoordinateTransformation.convert(this.handle.getX()) - 2.5;
            double d2 = doubleCoordinateTransformation2.convert(this.handle.getY()) - 2.5;
            return (double)point.x >= d && (double)point.x <= d + 5.0 && (double)point.y >= d2 && (double)point.y > d2 && (double)point.y <= d2 + 5.0;
        }

        void moveTo(Point point) {
            DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)OverlayWithHandles.this.container.getXTransformation();
            DoubleCoordinateTransformation doubleCoordinateTransformation2 = (DoubleCoordinateTransformation)OverlayWithHandles.this.container.getYTransformation();
            this.handle.moveTo(doubleCoordinateTransformation.unConvert(point.x), doubleCoordinateTransformation2.unConvert(point.y));
        }
    }
}

