/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DataSource;
import jas.hist.HasStatistics;
import jas.hist.JASHistStyle;
import jas.hist.Statistics;
import jas.hist.XMLPrintWriter;
import jas.hist.normalization.Normalizer;
import jas.plot.LegendEntry;
import jas.plot.Overlay;
import java.util.Observable;
import java.util.Observer;

public abstract class JASHistData
extends Observable
implements Observer {
    static final long serialVersionUID = -3529869583896718619L;
    Normalizer normalization;
    int yAxisIndex;
    boolean isVisible = false;
    DataManager parent;
    private String legendText;
    public static final int YAXIS_LEFT = 0;
    public static final int YAXIS_RIGHT = 1;

    JASHistData(DataManager dataManager) {
        this.parent = dataManager;
    }

    public JASHistData() {
    }

    public void show(boolean bl) {
        if (bl != this.isVisible) {
            this.isVisible = bl;
            DataSource dataSource = this.getDataSource();
            if (dataSource instanceof Observable) {
                if (bl) {
                    ((Observable)((Object)dataSource)).addObserver(this);
                } else {
                    ((Observable)((Object)dataSource)).deleteObserver(this);
                }
            }
            if (bl) {
                this.parent.requestShow(this);
            } else {
                this.parent.requestHide(this);
            }
        }
    }

    abstract LegendEntry getLegendEntry();

    abstract Overlay getOverlay();

    public abstract DataSource getDataSource();

    public DataSource getFittableDataSource() {
        return this.getDataSource();
    }

    public abstract String getTitle();

    abstract void axisChanged();

    public abstract void setStyle(JASHistStyle var1);

    public abstract JASHistStyle getStyle();

    public void setYAxis(int n) {
        this.yAxisIndex = n;
        this.axisChanged();
    }

    public int getYAxis() {
        return this.yAxisIndex;
    }

    public void setShowing(boolean bl) {
        this.show(bl);
    }

    public boolean isShowing() {
        return this.isVisible;
    }

    public String toString() {
        return this.getTitle();
    }

    public void setLegendText(String string) {
        String string2 = null;
        if (string.length() > 0 && !string.equals(this.getTitle())) {
            string2 = string;
        }
        if (string2 != this.legendText) {
            this.legendText = string2;
            this.parent.getPlot().getLegend().legendTextChanged();
        }
    }

    public String getLegendText() {
        return this.legendText != null ? this.legendText : this.getTitle();
    }

    boolean isLegendChanged() {
        return this.legendText != null;
    }

    Statistics getStatistics() {
        DataSource dataSource = this.getDataSource();
        if (dataSource instanceof HasStatistics) {
            return ((HasStatistics)((Object)dataSource)).getStatistics();
        }
        return null;
    }

    abstract void writeAsXML(XMLPrintWriter var1, boolean var2);

    void destroy() {
        if (this.normalization instanceof Observable) {
            ((Observable)((Object)this.normalization)).deleteObserver(this);
        }
    }

    public void setNormalization(Normalizer normalizer) {
        if (normalizer != this.normalization) {
            if (this.normalization instanceof Observable) {
                ((Observable)((Object)this.normalization)).deleteObserver(this);
            }
            this.normalization = normalizer;
            if (normalizer instanceof Observable) {
                ((Observable)((Object)this.normalization)).addObserver(this);
            }
            this.normalizationChanged(true);
        }
    }

    abstract void normalizationChanged(boolean var1);

    public abstract void update(Observable var1, Object var2);
}

