/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.FitAdapter1D;
import jas.hist.FitFailed;
import jas.hist.FitUpdate;
import jas.hist.Fittable1DFunction;
import jas.hist.Rebinnable1DHistogramData;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;

public abstract class Fitter
extends Observable
implements Observer,
Runnable,
Serializable {
    public static final int FITTING = 0;
    public static final int FIT = 1;
    public static final int FAILED = 2;
    public static final int READYTOFIT = 3;
    public static final int NOTREADYTOFIT = 4;
    public static final int OUTAHERE = 5;
    static final long serialVersionUID = -7769799329320822801L;
    private Rebinnable1DHistogramData m_data;
    private Fittable1DFunction m_func;
    private int state = 4;
    private Thread thread;
    private boolean observing = false;

    public abstract double getChiSquared();

    public abstract double[] getParameterSigmas();

    protected abstract void fit(Fittable1DFunction var1, double[] var2, double[] var3, double[] var4) throws FitFailed;

    public void fit() throws FitFailed {
        if (this.state != 3) {
            throw new FitFailed("Not ready to fit");
        }
        this.internalFit();
        this.observeData();
    }

    public synchronized void start() {
        if (this.state == 3) {
            this.thread = new Thread((Runnable)this, "Fit thread");
            this.thread.start();
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.stop();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Fitter fitter;
        try {
            try {
                this.internalFit();
                this.observeData();
            }
            catch (FitFailed fitFailed) {
                Object var3_2 = null;
                Fitter fitter3 = this;
                synchronized (fitter3) {
                    this.thread = null;
                    return;
                }
            }
            Object var3_1 = null;
            fitter = this;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Fitter fitter2 = this;
            synchronized (fitter2) {
                this.thread = null;
                throw throwable;
            }
        }
        synchronized (fitter) {
            this.thread = null;
            return;
        }
    }

    public synchronized void update(Observable observable, Object object) {
        if (observable == this.m_data) {
            if (this.state == 1) {
                this.setState(3);
            }
            this.start();
        }
    }

    public int getState() {
        return this.state;
    }

    private synchronized void observeData() {
        if (!this.observing && this.m_data instanceof Observable) {
            ((Observable)((Object)this.m_data)).addObserver(this);
        }
    }

    private synchronized void setState(int n) {
        this.state = n;
        this.setChanged();
        this.notifyObservers(new FitUpdate(n));
    }

    private synchronized void setState(int n, FitFailed fitFailed) {
        this.state = n;
        this.setChanged();
        this.notifyObservers(new FitUpdate(n, fitFailed));
    }

    protected void setPercentComplete(int n) {
        this.setChanged();
        this.notifyObservers(new FitUpdate(this.state, n));
    }

    private void internalFit() throws FitFailed {
        this.setState(0);
        try {
            double[] dArray;
            int n = this.m_data.getBins();
            double d = this.m_data.getMin();
            double d2 = this.m_data.getMax();
            double d3 = (d2 - d) / (double)n;
            double[][] dArray2 = this.m_data.rebin(n, d, d2, true, false);
            double[] dArray3 = new double[n];
            double[] dArray4 = dArray2[0];
            if (dArray2.length > 2 && dArray2[1] != dArray2[2]) {
                throw new FitFailed("Cannot fit data with asymmetric error bars");
            }
            double d4 = d + d3 / 2.0;
            int n2 = 0;
            while (n2 < n) {
                dArray3[n2] = d4;
                d4 += d3;
                ++n2;
            }
            if (dArray2.length > 1) {
                dArray = dArray2[1];
            } else {
                dArray = new double[n];
                int n3 = 0;
                while (n3 < n) {
                    dArray[n3] = Math.sqrt(dArray4[n3]);
                    ++n3;
                }
            }
            this.fit(new FitAdapter1D(this.m_func), dArray3, dArray4, dArray);
            this.setState(1);
        }
        catch (FitFailed fitFailed) {
            this.setState(2, fitFailed);
            throw fitFailed;
        }
    }

    public synchronized void setFunction(Fittable1DFunction fittable1DFunction) {
        if (this.m_func != null && this.m_func.getFit() == this) {
            this.m_func.clearFit();
        }
        this.m_func = fittable1DFunction;
        if (this.m_func != null & this.m_data != null) {
            this.setState(3);
        }
    }

    public Fittable1DFunction getFunction() {
        return this.m_func;
    }

    public synchronized void setData(Rebinnable1DHistogramData rebinnable1DHistogramData) {
        if (this.observing) {
            ((Observable)((Object)this.m_data)).deleteObserver(this);
            this.observing = false;
        }
        this.m_data = rebinnable1DHistogramData;
        if (this.m_func != null & this.m_data != null) {
            this.setState(3);
        }
    }

    public Rebinnable1DHistogramData getData() {
        return this.m_data;
    }

    protected synchronized void dispose() {
        if (this.thread != null) {
            this.thread.stop();
        }
        this.setState(5);
        this.deleteObservers();
        this.setData(null);
        this.setFunction(null);
    }
}

