/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.ExtendedStatistics;
import jas.hist.Fitter;
import jas.hist.FunctionValueUndefined;
import jas.hist.InvalidFunctionParameter;
import jas.util.DoubleWithError;

public abstract class Fittable1DFunction
extends Basic1DFunction
implements ExtendedStatistics {
    private static final String chi2 = "\u03c7\u00b2";
    private Fitter m_fit;
    private boolean[] m_fitParms;

    public abstract double valueAt(double var1, double[] var3) throws FunctionValueUndefined;

    public abstract void setFit(Fitter var1, double[] var2) throws InvalidFunctionParameter;

    public boolean[] getIncludeParametersInFit() {
        this.initIncludeParametersInFit(this.getParameterNames().length);
        return this.m_fitParms;
    }

    public void clearFitParams() {
        this.m_fitParms = null;
    }

    public void setIncludeParameterInFit(int n, boolean bl) {
        this.initIncludeParametersInFit(this.getParameterNames().length);
        this.m_fitParms[n] = bl;
        this.clearFit();
        this.setChanged();
    }

    protected void initIncludeParametersInFit(int n) {
        if (this.m_fitParms == null || this.m_fitParms.length != n) {
            this.m_fitParms = new boolean[n];
            int n2 = 0;
            while (n2 < this.m_fitParms.length) {
                this.m_fitParms[n2] = true;
                ++n2;
            }
        }
    }

    public double[] getDerivatives(double d, double[] dArray) throws FunctionValueUndefined {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double[] dArray3 = this.getParameterDeltas();
        int n2 = 0;
        while (n2 < n) {
            double d2 = dArray[n2];
            double d3 = dArray3[n2];
            dArray[n2] = d2 + d3;
            double d4 = this.valueAt(d, dArray);
            dArray[n2] = d2 - d3;
            dArray2[n2] = (d4 - this.valueAt(d, dArray)) / (2.0 * d3);
            dArray[n2] = d2;
            ++n2;
        }
        return dArray2;
    }

    private double[] getParameterDeltas() {
        double[] dArray = (double[])this.getParameterValues().clone();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = 1.0E-7;
            ++n;
        }
        return dArray;
    }

    public Fitter getFit() {
        return this.m_fit;
    }

    protected void setFit(Fitter fitter) {
        this.m_fit = fitter;
    }

    public void clearFit() {
        Fitter fitter = this.m_fit;
        if (fitter != null) {
            this.m_fit = null;
            fitter.dispose();
        }
    }

    protected void destroy() {
        this.clearFit();
        super.destroy();
    }

    public String[] getStatisticNames() {
        String[] stringArray = null;
        if (this.m_fit != null) {
            if (this.getParameterNames() != null) {
                stringArray = new String[this.getParameterNames().length + 1];
                int n = 0;
                while (n < this.getParameterNames().length) {
                    stringArray[n] = this.getParameterNames()[n];
                    ++n;
                }
            } else {
                stringArray = new String[1];
            }
            stringArray[stringArray.length - 1] = chi2;
            return stringArray;
        }
        stringArray = super.getStatisticNames();
        return stringArray;
    }

    public double getStatistic(String string) {
        if (string.equals(chi2)) {
            return this.m_fit.getChiSquared();
        }
        return super.getStatistic(string);
    }

    public Object getExtendedStatistic(String string) {
        if (this.m_fit != null) {
            int n = 0;
            while (n < this.getParameterNames().length) {
                if (string.equals(this.getParameterNames()[n])) {
                    return new DoubleWithError(this.getParameterValues()[n], this.m_fit.getParameterSigmas()[n]);
                }
                ++n;
            }
        }
        return null;
    }
}

