/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.AxisNodeTraverser;
import jas.hist.ComponentNodeTraverser;
import jas.hist.Data1DTraverser;
import jas.hist.Data2DTraverser;
import jas.hist.DataSource;
import jas.hist.FitFailed;
import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.FitterRegistry;
import jas.hist.Function1DTraverser;
import jas.hist.JASHist;
import jas.hist.JASHistAxis;
import jas.hist.JASHistData;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.normalization.Normalizer;
import jas.plot.DataArea;
import jas.util.xml.XMLNodeTraverser;
import java.util.Hashtable;
import java.util.Observable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DataAreaNodeTraverser
extends ComponentNodeTraverser {
    private Hashtable map = new Hashtable();
    private DataArea da;
    private JASHist plot;
    private static AxisNodeTraverser at = new AxisNodeTraverser();

    DataAreaNodeTraverser() {
    }

    void traverse(Node node, DataArea dataArea, JASHist jASHist) throws XMLNodeTraverser.BadXMLException {
        this.da = dataArea;
        this.plot = jASHist;
        super.traverse(node, dataArea);
    }

    protected void handleElement(Element element, String string) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("axis")) {
            JASHistAxis jASHistAxis;
            NamedNodeMap namedNodeMap = element.getAttributes();
            String string2 = namedNodeMap.getNamedItem("location").getNodeValue();
            if (string2.equals("x0")) {
                jASHistAxis = this.plot.getXAxis();
            } else if (string2.equals("y0")) {
                jASHistAxis = this.plot.getYAxis();
            } else if (string2.equals("y1")) {
                jASHistAxis = this.plot.getYAxis(1);
            } else {
                throw new XMLNodeTraverser.BadXMLException("Illegal axis position" + string2);
            }
            at.traverse(element, jASHistAxis);
        } else if (string.equals("data1d")) {
            Normalizer normalizer;
            Data1DTraverser data1DTraverser = new Data1DTraverser(element);
            DataSource dataSource = data1DTraverser.getDataSource();
            String string3 = data1DTraverser.getRefName();
            if (string3 != null) {
                this.map.put(string3, dataSource);
            }
            JASHistData jASHistData = this.plot.addData(dataSource);
            jASHistData.setYAxis(data1DTraverser.getYAxis());
            JASHistStyle jASHistStyle = data1DTraverser.getStyle();
            if (jASHistStyle != null) {
                jASHistData.setStyle(jASHistStyle);
            }
            if ((normalizer = data1DTraverser.getNormalizer(dataSource, this.map)) != null) {
                jASHistData.setNormalization(normalizer);
            }
            jASHistData.show(true);
        } else if (string.equals("data2d")) {
            Data2DTraverser data2DTraverser = new Data2DTraverser(element);
            JASHistData jASHistData = this.plot.addData(data2DTraverser.getDataSource());
            JASHistStyle jASHistStyle = data2DTraverser.getStyle();
            if (jASHistStyle != null) {
                jASHistData.setStyle(jASHistStyle);
            }
            jASHistData.show(true);
        } else if (string.equals("function1d")) {
            Function1DTraverser function1DTraverser = new Function1DTraverser(element, this.plot);
            DataSource dataSource = function1DTraverser.getDataSource();
            if (dataSource != null) {
                Observable observable;
                Object object;
                String string4;
                String string5 = function1DTraverser.getRefName();
                if (string5 != null) {
                    this.map.put(string5, dataSource);
                }
                if ((string4 = function1DTraverser.getFitRef()) != null) {
                    object = (DataSource)this.map.get(string4);
                    if (object == null) {
                        throw new XMLNodeTraverser.BadXMLException("Cannot resolve reference " + string4);
                    }
                    if (!(object instanceof Rebinnable1DHistogramData)) {
                        throw new XMLNodeTraverser.BadXMLException("Cannot fit 2D data");
                    }
                    if (!(dataSource instanceof Fittable1DFunction)) {
                        throw new XMLNodeTraverser.BadXMLException("Function is not fittable");
                    }
                    observable = FitterRegistry.instance().getDefaultFitter();
                    ((Fitter)observable).setData((Rebinnable1DHistogramData)object);
                    ((Fitter)observable).setFunction((Fittable1DFunction)dataSource);
                    try {
                        ((Fitter)observable).fit();
                    }
                    catch (FitFailed fitFailed) {
                        fitFailed.printStackTrace();
                    }
                }
                object = this.plot.addData(dataSource);
                observable = function1DTraverser.getStyle();
                if (observable != null) {
                    ((JASHistData)object).setStyle((JASHistStyle)observable);
                }
                ((JASHistData)object).show(function1DTraverser.isVisible());
            }
        } else {
            super.handleElement(element, string);
        }
    }
}

