/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.BinnedDataAxisAttributesNodeTraverser;
import jas.hist.Bins2DNodeTraverser;
import jas.hist.ClassNodeTraverser;
import jas.hist.ConstructorNodeTraverser;
import jas.hist.DataSource;
import jas.hist.DataSourceNodeTraverser;
import jas.hist.JASHist2DHistogramStyle;
import jas.hist.JASHistScatterPlotStyle;
import jas.hist.JASHistStyle;
import jas.hist.PointDataAxisAttributesNodeTraverser;
import jas.hist.Points2DNodeTraverser;
import jas.hist.ScatterStyleNodeTraverser;
import jas.hist.StatisticsTraverser;
import jas.hist.Style2DNodeTraverser;
import jas.hist.XML2DHistDataSource;
import jas.hist.XML2DScatterDataSource;
import jas.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Data2DTraverser
extends XMLNodeTraverser {
    private String type;
    private int paxis = 0;
    private int baxis = 0;
    private JASHist2DHistogramStyle style;
    private ConstructorNodeTraverser ct = null;
    private StatisticsTraverser stats = null;
    private Style2DNodeTraverser st = new Style2DNodeTraverser();
    private ScatterStyleNodeTraverser scst = new ScatterStyleNodeTraverser();
    private Bins2DNodeTraverser b2d;
    private BinnedDataAxisAttributesNodeTraverser[] baa = new BinnedDataAxisAttributesNodeTraverser[2];
    private PointDataAxisAttributesNodeTraverser[] paa = new PointDataAxisAttributesNodeTraverser[2];
    private Points2DNodeTraverser p2d;

    Data2DTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        this.traverse(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleElement(Element element, String string) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("bins2d")) {
            this.b2d = new Bins2DNodeTraverser(element);
            return;
        } else if (string.equals("points")) {
            this.p2d = new Points2DNodeTraverser(element);
            return;
        } else if (string.equals("pointDataAxisAttributes")) {
            this.paa[this.paxis++] = new PointDataAxisAttributesNodeTraverser(element);
            return;
        } else if (string.equals("binnedDataAxisAttributes")) {
            this.baa[this.baxis++] = new BinnedDataAxisAttributesNodeTraverser(element);
            return;
        } else if (string.equals("class")) {
            this.ct = new ClassNodeTraverser(element);
            return;
        } else if (string.equals("datasource")) {
            this.ct = new DataSourceNodeTraverser(element);
            return;
        } else if (string.equals("statistics")) {
            this.stats = new StatisticsTraverser(element);
            return;
        } else if (string.equals("style2d")) {
            if (this.type.equals("scatter2d")) {
                JASHistScatterPlotStyle jASHistScatterPlotStyle = new JASHistScatterPlotStyle();
                this.style = jASHistScatterPlotStyle;
                this.scst.traverse((Node)element, jASHistScatterPlotStyle);
                return;
            } else {
                if (!this.type.equals("histogram2d")) throw new XMLNodeTraverser.BadXMLException("type attribute for data2d element must be scatter2d of histogram2d.");
                this.style = new JASHist2DHistogramStyle();
                this.st.traverse(element, this.style);
            }
            return;
        } else {
            super.handleElement(element, string);
        }
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("type")) {
            this.type = string2;
        } else {
            super.handleAttributeNode(attr, string, string2);
        }
    }

    DataSource getDataSource() throws XMLNodeTraverser.BadXMLException {
        if (this.ct != null) {
            return this.ct.getDataSource();
        }
        if (this.b2d != null) {
            return new XML2DHistDataSource(this.b2d, this.baa[0], this.baa[1], this.stats);
        }
        return new XML2DScatterDataSource(this.paa[0].getType(), this.paa[1].getType(), this.p2d.getTitle(), this.p2d.getData());
    }

    JASHistStyle getStyle() {
        return this.style;
    }
}

