/*
 * Decompiled with CFR 0.152.
 */
package htmllayout;

import htmllayout.Cell;
import htmllayout.HtmlLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HtmlLayoutTest
extends Frame {
    HtmlLayoutTest(String string, String string2) {
        super(string);
        HtmlLayout htmlLayout = new HtmlLayout(string2);
        this.setLayout(htmlLayout);
        this.addComps(htmlLayout.cells);
    }

    void addComps(Cell[] cellArray) {
        int n = 0;
        while (n < cellArray.length) {
            if (cellArray[n].name != null) {
                Button button = new Button(cellArray[n].name);
                this.add((Component)button, cellArray[n].name);
            } else if (cellArray[n].nested != null) {
                this.addComps(cellArray[n].nested.cells);
            }
            ++n;
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.hide();
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("HtmlLayoutTest filename [...]");
            System.err.println("\tReads in each file \"filename\" containing table html\n\tand creates a window layed out according to that html.\n\tButtons are created to fill in for the components.");
        }
        int n = 0;
        while (n < stringArray.length) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(stringArray[n], "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            randomAccessFile.close();
            HtmlLayoutTest htmlLayoutTest = new HtmlLayoutTest(stringArray[n], new String(byArray));
            htmlLayoutTest.pack();
            ((Component)htmlLayoutTest).setVisible(true);
            ++n;
        }
    }
}

