/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.Token;

public abstract class TokenMarker {
    protected Token firstToken;
    protected Token lastToken;
    protected LineInfo[] lineInfo;
    protected int length;
    protected boolean nextLineRequested;

    public Token markTokens(Segment segment, int n) {
        byte by;
        this.lastToken = null;
        LineInfo lineInfo = this.lineInfo[n];
        byte by2 = lineInfo.token;
        lineInfo.token = by = this.markTokensImpl(n == 0 ? (byte)0 : this.lineInfo[n - 1].token, segment, n);
        this.nextLineRequested = by2 != by && this.lastToken != null;
        this.addToken(0, (byte)127);
        return this.firstToken;
    }

    protected abstract byte markTokensImpl(byte var1, Segment var2, int var3);

    public void insertLines(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        this.length += n2;
        this.ensureCapacity(this.length);
        int n3 = n + n2;
        System.arraycopy(this.lineInfo, n, this.lineInfo, n3, this.lineInfo.length - n3);
        int n4 = n + n2 - 1;
        while (n4 >= n) {
            this.lineInfo[n4] = new LineInfo();
            --n4;
        }
    }

    public void deleteLines(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        int n3 = n + n2;
        this.length -= n2;
        System.arraycopy(this.lineInfo, n3, this.lineInfo, n, this.lineInfo.length - n3);
    }

    public boolean isNextLineRequested() {
        return this.nextLineRequested;
    }

    protected TokenMarker() {
    }

    protected void ensureCapacity(int n) {
        if (this.lineInfo == null) {
            this.lineInfo = new LineInfo[n + 1];
        } else if (this.lineInfo.length <= n) {
            LineInfo[] lineInfoArray = new LineInfo[(n + 1) * 2];
            System.arraycopy(this.lineInfo, 0, lineInfoArray, 0, this.lineInfo.length);
            this.lineInfo = lineInfoArray;
        }
    }

    protected void addToken(int n, byte by) {
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = new Token(n, by);
        } else if (this.lastToken == null) {
            this.lastToken = this.firstToken;
            this.firstToken.length = n;
            this.firstToken.id = by;
        } else if (this.lastToken.next == null) {
            this.lastToken = this.lastToken.next = new Token(n, by);
        } else {
            this.lastToken = this.lastToken.next;
            this.lastToken.length = n;
            this.lastToken.id = by;
        }
    }

    public class LineInfo {
        public byte token;
        public Object obj;

        public LineInfo() {
        }

        public LineInfo(byte by, Object object) {
            this.token = by;
            this.obj = object;
        }
    }
}

