/*
 * Decompiled with CFR 0.152.
 */
package jas.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.JToolBar;

public class ToolbarLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int align;
    int hgap;
    int vgap;

    public ToolbarLayout() {
        this(0, 5, 5);
    }

    public ToolbarLayout(int n) {
        this(n, 5, 5);
    }

    public ToolbarLayout(int n, int n2, int n3) {
        this.align = n;
        this.hgap = n2;
        this.vgap = n3;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int n) {
        this.align = n;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(String string, Component component) {
        try {
            ((JToolBar)component).setOrientation(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Serializable serializable;
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = 1;
            int n3 = insets.left + insets.right;
            int n4 = container.getSize().width;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n) {
                serializable = container.getComponent(n7);
                if (serializable.isVisible()) {
                    Dimension dimension2 = serializable.getPreferredSize();
                    n5 = Math.max(n5, dimension2.height);
                    if (n7 > 0) {
                        n3 += this.hgap;
                    }
                    if ((n3 += dimension2.width) + this.hgap > n4 && n6 > 0) {
                        ++n2;
                        n3 = insets.left + insets.right + dimension2.width;
                        n6 = 0;
                    }
                    ++n6;
                }
                ++n7;
            }
            dimension.width = n4;
            dimension.height = insets.top + insets.bottom + n2 * n5 + this.vgap * (n2 + 1);
            serializable = dimension;
            return serializable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension;
            Serializable serializable;
            Dimension dimension2 = new Dimension(0, 0);
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                serializable = container.getComponent(n2);
                if (((Component)serializable).isVisible()) {
                    dimension = ((Component)serializable).getMinimumSize();
                    dimension2.height = Math.max(dimension2.height, dimension.height);
                    if (n2 > 0) {
                        dimension2.width += this.hgap;
                    }
                    dimension2.width += dimension.width;
                }
                ++n2;
            }
            serializable = container.getInsets();
            dimension2.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
            dimension2.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
            dimension = dimension2;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        Object object = container.getTreeLock();
        synchronized (object) {
            switch (this.align) {
                case 0: {
                    break;
                }
                case 1: {
                    n += n3 / 2;
                    break;
                }
                case 2: {
                    n += n3;
                }
            }
            int n7 = n5;
            while (n7 < n6) {
                Component component = container.getComponent(n7);
                if (component.isVisible()) {
                    component.setLocation(n, n2 + (n4 - component.getSize().height) / 2);
                    n += this.hgap + component.getSize().width;
                }
                ++n7;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getSize().width - (insets.left + insets.right + this.hgap * 2);
            int n2 = container.getComponentCount();
            int n3 = 0;
            int n4 = insets.top + this.vgap;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                Component component = container.getComponent(n7);
                if (component.isVisible()) {
                    Dimension dimension = component.getPreferredSize();
                    component.setSize(dimension.width, dimension.height);
                    if (n3 == 0 || n3 + dimension.width <= n) {
                        if (n3 > 0) {
                            n3 += this.hgap;
                        }
                        n3 += dimension.width;
                        n5 = Math.max(n5, dimension.height);
                    } else {
                        this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, n7);
                        n3 = dimension.width;
                        n4 += this.vgap + n5;
                        n5 = dimension.height;
                        n6 = n7;
                    }
                }
                ++n7;
            }
            this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, n2);
        }
    }

    public String toString() {
        String string = "";
        switch (this.align) {
            case 0: {
                string = ",align=left";
                break;
            }
            case 1: {
                string = ",align=center";
                break;
            }
            case 2: {
                string = ",align=right";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + string + "]";
    }
}

