/*
 * Decompiled with CFR 0.152.
 */
package jas.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PnutsLayout
implements LayoutManager2,
Serializable {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int V_FIT = 16;
    public static final int H_FIT = 32;
    static final int V_FILL = 3;
    static final int H_FILL = 12;
    static Integer[] integer = new Integer[33];
    static int[] zero;
    Hashtable alignmentTable = new Hashtable();
    Hashtable spanTable = new Hashtable();
    Hashtable padTable = new Hashtable();
    Hashtable iPadTable = new Hashtable();
    private int[] widths;
    private int[] heights;
    private int[] hfit;
    private int[] vfit;
    private int hfits;
    private int vfits;
    int[] grid_x;
    int[] grid_y;
    int[] pos_x = new int[8];
    int[] pos_y = new int[8];
    private Dimension psize;
    private boolean valid = false;
    protected int align = 0;
    protected int padx;
    protected int pady;
    protected int ipadx;
    protected int ipady;
    protected int cols;
    protected int rows;
    protected boolean xfix;
    protected boolean yfix;

    static Integer getInteger(int n) {
        if (n < 32) {
            return integer[n];
        }
        return new Integer(n);
    }

    public PnutsLayout() {
        this(1);
    }

    public PnutsLayout(int n) {
        this(n, 0, 0);
    }

    public PnutsLayout(int n, int n2, int n3) {
        this.cols = n;
        this.padx = n2;
        this.pady = n3;
    }

    public PnutsLayout(String string) {
        Hashtable hashtable = PnutsLayout.str2table(string);
        this.cols = PnutsLayout.getInt(hashtable.get("cols"), 1);
        this.padx = PnutsLayout.getInt(hashtable.get("padx"), 0);
        this.pady = PnutsLayout.getInt(hashtable.get("pady"), 0);
        this.ipadx = PnutsLayout.getInt(hashtable.get("ipadx"), 0);
        this.ipady = PnutsLayout.getInt(hashtable.get("ipady"), 0);
        int n = 0;
        int n2 = 0;
        String string2 = (String)hashtable.get("halign");
        if (string2 != null) {
            if ("left".equalsIgnoreCase(string2)) {
                n |= 4;
            } else if ("right".equalsIgnoreCase(string2)) {
                n |= 8;
            } else if ("center".equalsIgnoreCase(string2)) {
                n |= 0;
            } else if ("fill".equalsIgnoreCase(string2)) {
                n |= 8;
                n |= 4;
            }
        } else {
            n = this.align & 0x2C;
        }
        String string3 = (String)hashtable.get("valign");
        if (string3 != null) {
            if ("top".equalsIgnoreCase(string3)) {
                n2 |= 1;
            } else if ("bottom".equalsIgnoreCase(string3)) {
                n2 |= 2;
            } else if ("center".equalsIgnoreCase(string3)) {
                n2 |= 0;
            } else if ("fill".equalsIgnoreCase(string3)) {
                n2 |= 1;
                n2 |= 2;
            }
        } else {
            n2 = this.align & 0x13;
        }
        String string4 = (String)hashtable.get("expand");
        if (string4 instanceof String) {
            if ("x".equalsIgnoreCase(string4)) {
                n |= 0x20;
            } else if ("y".equalsIgnoreCase(string4)) {
                n2 |= 0x10;
            } else if ("xy".equalsIgnoreCase(string4)) {
                n |= 0x20;
                n2 |= 0x10;
            }
        }
        this.align = n | n2;
        String string5 = (String)hashtable.get("uniform");
        if ("x".equals(string5)) {
            this.xfix = true;
        } else if ("y".equals(string5)) {
            this.yfix = true;
        } else if ("xy".equals(string5)) {
            this.xfix = true;
            this.yfix = true;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof Hashtable) {
            this.setConstraints(component, (Hashtable)object);
        } else if (object instanceof String) {
            this.setConstraints(component, (String)object);
        }
    }

    public void setConstraints(Component component, String string) {
        Object object;
        String string2;
        int n = this.align & 0x2C;
        int n2 = this.align & 0x13;
        Hashtable hashtable = PnutsLayout.str2table(string);
        Object v = hashtable.get("expand");
        if (v instanceof String) {
            string2 = (String)v;
            if ("x".equalsIgnoreCase(string2)) {
                n |= 0x20;
            } else if ("y".equalsIgnoreCase(string2)) {
                n2 |= 0x10;
            } else if ("xy".equalsIgnoreCase(string2)) {
                n |= 0x20;
                n2 |= 0x10;
            }
        }
        if ((string2 = hashtable.get("halign")) instanceof String) {
            n &= 0xFFFFFFF3;
            object = string2;
            if ("left".equalsIgnoreCase((String)object)) {
                n |= 4;
            } else if ("right".equalsIgnoreCase((String)object)) {
                n |= 8;
            } else if ("center".equalsIgnoreCase((String)object)) {
                n |= 0;
            } else if ("fill".equalsIgnoreCase((String)object)) {
                n |= 8;
                n |= 4;
            }
        }
        if ((object = hashtable.get("valign")) instanceof String) {
            n2 &= 0xFFFFFFFC;
            String string3 = (String)object;
            if ("top".equalsIgnoreCase(string3)) {
                n2 |= 1;
            } else if ("bottom".equalsIgnoreCase(string3)) {
                n2 |= 2;
            } else if ("center".equalsIgnoreCase(string3)) {
                n2 |= 0;
            } else if ("fill".equalsIgnoreCase(string3)) {
                n2 |= 1;
                n2 |= 2;
            }
        }
        hashtable.put("valign", PnutsLayout.getInteger(n2));
        hashtable.put("halign", PnutsLayout.getInteger(n));
        this.setConstraints(component, hashtable);
    }

    static int getInt(Object object, int n) {
        if (object == null) {
            return n;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return Integer.parseInt((String)object);
    }

    public void setConstraints(Component component, Hashtable hashtable) {
        int n = PnutsLayout.getInt(hashtable.get("halign"), this.align & 0xC);
        int n2 = PnutsLayout.getInt(hashtable.get("valign"), this.align & 3);
        this.alignmentTable.put(component, PnutsLayout.getInteger(n | n2));
        int n3 = PnutsLayout.getInt(hashtable.get("colspan"), 1);
        if (n3 <= this.cols) {
            this.spanTable.put(component, new Object[]{PnutsLayout.getInteger(n3), PnutsLayout.getInteger(PnutsLayout.getInt(hashtable.get("rowspan"), 1))});
        }
        this.padTable.put(component, new Object[]{PnutsLayout.getInteger(PnutsLayout.getInt(hashtable.get("padx"), this.padx)), PnutsLayout.getInteger(PnutsLayout.getInt(hashtable.get("pady"), this.pady))});
        this.iPadTable.put(component, new Object[]{PnutsLayout.getInteger(PnutsLayout.getInt(hashtable.get("ipadx"), this.ipadx)), PnutsLayout.getInteger(PnutsLayout.getInt(hashtable.get("ipady"), this.ipady))});
    }

    public String getConstraintString(Component component) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string;
        String string2;
        Hashtable hashtable = this.getConstraints(component);
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = (String)hashtable.get("halign");
        if (string3 != null) {
            stringBuffer.append("halign = " + string3);
        }
        if ((string2 = (String)hashtable.get("valign")) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("valign = " + string2);
        }
        if ((string = (String)hashtable.get("expand")) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("expand = " + string);
        }
        if ((n6 = ((Integer)hashtable.get("padx")).intValue()) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("padx = " + n6);
        }
        if ((n5 = ((Integer)hashtable.get("pady")).intValue()) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("pady = " + n5);
        }
        if ((n4 = ((Integer)hashtable.get("ipadx")).intValue()) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("ipadx = " + n4);
        }
        if ((n3 = ((Integer)hashtable.get("ipady")).intValue()) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("ipady = " + n3);
        }
        if ((n2 = ((Integer)hashtable.get("colspan")).intValue()) > 1) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("colspan = " + n2);
        }
        if ((n = ((Integer)hashtable.get("rowspan")).intValue()) > 1) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("rowspan = " + n);
        }
        return stringBuffer.toString();
    }

    public Hashtable getConstraints(Component component) {
        Object object;
        Object object2;
        Object object3;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Object v = this.alignmentTable.get(component);
        int n = this.align;
        if (v != null) {
            n = (Integer)v;
            object3 = "center";
            object2 = "center";
            switch (n & 0xC) {
                case 4: {
                    object3 = "left";
                    break;
                }
                case 8: {
                    object3 = "right";
                    break;
                }
                case 12: {
                    object3 = "fill";
                }
            }
            switch (n & 3) {
                case 1: {
                    object2 = "top";
                    break;
                }
                case 2: {
                    object2 = "bottom";
                    break;
                }
                case 3: {
                    object2 = "fill";
                }
            }
            if (!"center".equals(object3)) {
                hashtable.put("halign", object3);
            }
            if (!"center".equals(object2)) {
                hashtable.put("valign", object2);
            }
            object = "";
            if ((n & 0x20) == 32) {
                object = (String)object + "x";
            }
            if ((n & 0x10) == 16) {
                object = (String)object + "y";
            }
            if (((String)object).length() > 0) {
                hashtable.put("expand", object);
            }
        }
        if ((object3 = (Object[])this.padTable.get(component)) != null) {
            hashtable.put("padx", object3[0]);
            hashtable.put("pady", object3[1]);
        }
        if ((object2 = (Object[])this.iPadTable.get(component)) != null) {
            hashtable.put("ipadx", object2[0]);
            hashtable.put("ipady", object2[1]);
        }
        if ((object = (Object[])this.spanTable.get(component)) != null) {
            hashtable.put("colspan", object[0]);
            hashtable.put("rowspan", object[1]);
        }
        return hashtable;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension maximumLayoutSize(Container container) {
        return container.getMaximumSize();
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
        this.valid = false;
    }

    public void setCols(int n) {
        Enumeration enumeration = this.spanTable.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            int n2 = (Integer)objectArray[0];
            if (n2 <= n) continue;
            return;
        }
        this.cols = n;
        this.valid = false;
    }

    public void setUniform(boolean bl, boolean bl2) {
        this.xfix = bl;
        this.yfix = bl2;
        this.valid = false;
    }

    public boolean[] getUniform() {
        return new boolean[]{this.xfix, this.yfix};
    }

    public void setColspan(Component component, int n) {
        Object[] objectArray = (Object[])this.spanTable.get(component);
        if (objectArray != null) {
            objectArray[0] = PnutsLayout.getInteger(n);
            this.spanTable.put(component, objectArray);
        } else {
            this.spanTable.put(component, new Object[]{PnutsLayout.getInteger(n), PnutsLayout.getInteger(1)});
        }
        this.invalidateLayout(component.getParent());
    }

    public int getColspan(Component component) {
        Object[] objectArray = (Object[])this.spanTable.get(component);
        if (objectArray == null || objectArray.length < 2) {
            return 1;
        }
        return (Integer)objectArray[0];
    }

    public void setRowspan(Component component, int n) {
        Object[] objectArray = (Object[])this.spanTable.get(component);
        if (objectArray != null) {
            objectArray[1] = PnutsLayout.getInteger(n);
            this.spanTable.put(component, objectArray);
        } else {
            this.spanTable.put(component, new Object[]{PnutsLayout.getInteger(1), PnutsLayout.getInteger(n)});
        }
        this.invalidateLayout(component.getParent());
    }

    public int getRowspan(Component component) {
        Object[] objectArray = (Object[])this.spanTable.get(component);
        if (objectArray == null || objectArray.length < 2) {
            return 1;
        }
        return (Integer)objectArray[1];
    }

    public void setHAlign(Component component, String string) {
        int n = 0;
        n = "left".equalsIgnoreCase(string) ? 4 : ("right".equalsIgnoreCase(string) ? 8 : ("fill".equalsIgnoreCase(string) ? 12 : 0));
        this.alignmentTable.put(component, PnutsLayout.getInteger(n));
        this.invalidateLayout(component.getParent());
    }

    public void setVAlign(Component component, String string) {
        int n = 0;
        n = "left".equalsIgnoreCase(string) ? 1 : ("bottom".equalsIgnoreCase(string) ? 2 : ("fill".equalsIgnoreCase(string) ? 3 : 0));
        this.alignmentTable.put(component, PnutsLayout.getInteger(n));
        this.invalidateLayout(component.getParent());
    }

    public String getHAlign(Component component) {
        Integer n = (Integer)this.alignmentTable.get(component);
        int n2 = this.align;
        if (n != null) {
            n2 = n;
        }
        if ((n2 & 0xC) == 12) {
            return "fill";
        }
        if ((n2 & 4) == 4) {
            return "left";
        }
        if ((n2 & 8) == 8) {
            return "right";
        }
        return "center";
    }

    public String getVAlign(Component component) {
        Integer n = (Integer)this.alignmentTable.get(component);
        int n2 = this.align;
        if (n != null) {
            n2 = n;
        }
        if ((n2 & 3) == 3) {
            return "fill";
        }
        if ((n2 & 1) == 1) {
            return "top";
        }
        if ((n2 & 2) == 2) {
            return "bottom";
        }
        return "center";
    }

    public void setExpand(Component component, String string) {
        Integer n = (Integer)this.alignmentTable.get(component);
        int n2 = this.align;
        if (n != null) {
            n2 = n;
        }
        if ("x".equalsIgnoreCase(string)) {
            n2 |= 0x20;
        } else if ("y".equalsIgnoreCase(string)) {
            n2 |= 0x10;
        } else if ("xy".equalsIgnoreCase(string)) {
            n2 |= 0x20;
            n2 |= 0x10;
        }
        this.alignmentTable.put(component, PnutsLayout.getInteger(n2));
        this.invalidateLayout(component.getParent());
    }

    public String getExpand(Component component) {
        Integer n = (Integer)this.alignmentTable.get(component);
        int n2 = this.align;
        if (n != null) {
            n2 = n;
        }
        if ((n2 & 0x30) == 48) {
            return "xy";
        }
        if ((n2 & 0x20) == 32) {
            return "x";
        }
        if ((n2 & 0x10) == 16) {
            return "y";
        }
        return "";
    }

    public void setPadding(Component component, int n, int n2) {
        this.padTable.put(component, new Object[]{PnutsLayout.getInteger(n), PnutsLayout.getInteger(n2)});
        this.invalidateLayout(component.getParent());
    }

    public int getPadX(Component component) {
        Object[] objectArray = (Object[])this.padTable.get(component);
        if (objectArray != null) {
            return (Integer)objectArray[0];
        }
        return 0;
    }

    public int getPadY(Component component) {
        Object[] objectArray = (Object[])this.padTable.get(component);
        if (objectArray != null) {
            return (Integer)objectArray[1];
        }
        return 0;
    }

    public void setIPadding(Component component, int n, int n2) {
        this.iPadTable.put(component, new Object[]{PnutsLayout.getInteger(n), PnutsLayout.getInteger(n2)});
        this.invalidateLayout(component.getParent());
    }

    public int getIPadX(Component component) {
        Object[] objectArray = (Object[])this.iPadTable.get(component);
        if (objectArray != null) {
            return (Integer)objectArray[0];
        }
        return 0;
    }

    public int getIPadY(Component component) {
        Object[] objectArray = (Object[])this.iPadTable.get(component);
        if (objectArray != null) {
            return (Integer)objectArray[1];
        }
        return 0;
    }

    void clear(int[] nArray, int n) {
        int n2 = 0;
        while (n2 <= n - zero.length) {
            System.arraycopy(zero, 0, nArray, n2, zero.length);
            n2 += zero.length;
        }
        System.arraycopy(zero, 0, nArray, n2, n - n2);
    }

    void bindContainer(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.valid) {
            return;
        }
        BitSet[] bitSetArray = new BitSet[this.cols];
        int n6 = 0;
        while (n6 < this.cols) {
            bitSetArray[n6] = new BitSet();
            ++n6;
        }
        int n7 = container.getComponentCount();
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (this.pos_x.length < n7) {
            this.pos_x = new int[n7 * 2];
        }
        if (this.pos_y.length < n7) {
            this.pos_y = new int[n7 * 2];
        }
        this.clear(this.pos_x, n7);
        this.clear(this.pos_y, n7);
        int n11 = 0;
        while (n11 < n7) {
            Component component = container.getComponent(n11);
            Object[] objectArray = (Object[])this.spanTable.get(component);
            n5 = 1;
            n4 = 1;
            if (objectArray != null) {
                n5 = (Integer)objectArray[0];
                n4 = (Integer)objectArray[1];
            }
            while (!this.fit(n9, n8, n5, n4, bitSetArray)) {
                if (++n9 < this.cols) continue;
                n9 = 0;
                ++n8;
            }
            this.pos_y[n11] = n8;
            this.pos_x[n11] = n9;
            n3 = 0;
            while (n3 < n5) {
                int n12 = 0;
                while (n12 < n4) {
                    bitSetArray[n9 + n3].set(n8 + n12);
                    ++n12;
                }
                ++n3;
            }
            if (n10 < n8 + n4) {
                n10 = n8 + n4;
            }
            if (++n9 >= this.cols) {
                n9 = 0;
                ++n8;
            }
            ++n11;
        }
        this.rows = n10;
        this.grid_x = new int[this.cols + 1];
        this.grid_y = new int[this.rows + 1];
        this.widths = new int[this.cols];
        this.heights = new int[this.rows];
        this.vfit = new int[this.rows];
        this.hfit = new int[this.cols];
        int n13 = 0;
        int n14 = 0;
        n5 = 0;
        n4 = 0;
        n3 = 0;
        while (n5 < n7) {
            int n15;
            Component component = container.getComponent(n5);
            Dimension dimension = component.getPreferredSize();
            n2 = dimension.width;
            n = dimension.height;
            Object[] objectArray = (Object[])this.iPadTable.get(component);
            if (objectArray != null) {
                n2 = dimension.width + (Integer)objectArray[0];
                n = dimension.height + (Integer)objectArray[1];
            }
            Object[] objectArray2 = (Object[])this.padTable.get(component);
            int n16 = this.padx;
            int n17 = this.pady;
            if (objectArray2 != null) {
                n16 = (Integer)objectArray2[0];
                n17 = (Integer)objectArray2[1];
            }
            n3 = this.pos_y[n5];
            n4 = this.pos_x[n5];
            int n18 = 1;
            int n19 = 1;
            Object[] objectArray3 = (Object[])this.spanTable.get(component);
            if (objectArray3 != null) {
                n18 = (Integer)objectArray3[0];
                n19 = (Integer)objectArray3[1];
            }
            int n20 = 0;
            int n21 = 0;
            while (n21 < n18) {
                n20 += this.widths[n4 + n21];
                ++n21;
            }
            if (n20 < n2 + n16 * 2) {
                int n22 = 0;
                while (n22 < n18) {
                    int n23 = n4 + n22;
                    this.widths[n23] = this.widths[n23] + (n2 + n16 * 2 - n20) / n18;
                    if (this.xfix && n13 < this.widths[n4 + n22]) {
                        n13 = this.widths[n4 + n22];
                    }
                    ++n22;
                }
            }
            if (this.heights[n3] < (n + n17 * 2) / n19) {
                this.heights[n3] = (n + n17 * 2) / n19;
                if (this.yfix && n14 < this.heights[n3]) {
                    n14 = this.heights[n3];
                }
            }
            Object v = this.alignmentTable.get(component);
            int n24 = this.align;
            if (v != null && v instanceof Integer) {
                n24 = (Integer)v;
            }
            if ((n24 & 0x20) != 0) {
                n15 = 0;
                while (n15 < n18) {
                    int n25 = n4 + n15;
                    this.hfit[n25] = this.hfit[n25] | 1;
                    ++n15;
                }
            }
            if ((n24 & 0x10) != 0) {
                n15 = 0;
                while (n15 < n19) {
                    int n26 = n3 + n15;
                    this.vfit[n26] = this.vfit[n26] | 1;
                    ++n15;
                }
            }
            if ((n4 += n18) >= this.cols) {
                n4 = 0;
                ++n3;
            }
            ++n5;
        }
        if (this.xfix) {
            int n27 = 0;
            while (n27 < this.cols) {
                this.widths[n27] = n13;
                ++n27;
            }
        }
        if (this.yfix) {
            int n28 = 0;
            while (n28 < this.rows) {
                this.heights[n28] = n14;
                ++n28;
            }
        }
        int n29 = 0;
        int n30 = 0;
        n2 = 0;
        while (n2 < this.cols) {
            n29 += this.widths[n2];
            ++n2;
        }
        n = 0;
        while (n < this.rows) {
            n30 += this.heights[n];
            ++n;
        }
        this.hfits = 0;
        int n31 = 0;
        while (n31 < this.hfit.length) {
            if ((this.hfit[n31] & 1) != 0) {
                ++this.hfits;
            }
            ++n31;
        }
        this.vfits = 0;
        int n32 = 0;
        while (n32 < this.vfit.length) {
            if ((this.vfit[n32] & 1) != 0) {
                ++this.vfits;
            }
            ++n32;
        }
        Insets insets = container.getInsets();
        this.psize = new Dimension(n29 += insets.left + insets.right + this.padx * this.cols, n30 += insets.top + insets.bottom + this.pady * this.rows);
        this.valid = true;
    }

    public Dimension preferredLayoutSize(Container container) {
        this.bindContainer(container);
        return this.psize;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        int n;
        Insets insets = container.getInsets();
        int n2 = container.getComponentCount();
        this.bindContainer(container);
        int n3 = container.getSize().width;
        int n4 = container.getSize().height;
        int n5 = this.psize.width;
        int n6 = this.psize.height;
        int n7 = 0;
        int n8 = 0;
        if (this.hfits > 0) {
            n7 = (n3 - n5) / this.hfits;
        }
        if (this.vfits > 0) {
            n8 = (n4 - n6) / this.vfits;
        }
        int n9 = insets.top;
        this.grid_x[0] = n = insets.left;
        int n10 = 1;
        while (n10 <= this.cols) {
            this.grid_x[n10] = this.grid_x[n10 - 1] + this.widths[n10 - 1] + this.padx;
            if ((this.hfit[n10 - 1] & 1) != 0) {
                int n11 = n10;
                this.grid_x[n11] = this.grid_x[n11] + n7;
            }
            ++n10;
        }
        this.grid_y[0] = n9;
        int n12 = 1;
        while (n12 <= this.rows) {
            this.grid_y[n12] = this.grid_y[n12 - 1] + this.heights[n12 - 1] + this.pady;
            if ((this.vfit[n12 - 1] & 1) != 0) {
                int n13 = n12;
                this.grid_y[n13] = this.grid_y[n13] + n8;
            }
            ++n12;
        }
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        while (n14 < n2) {
            int n17;
            int n18;
            Component component = container.getComponent(n14);
            Dimension dimension = component.getPreferredSize();
            int n19 = dimension.width;
            int n20 = dimension.height;
            Object[] objectArray = (Object[])this.iPadTable.get(component);
            if (objectArray != null) {
                n19 = dimension.width + (Integer)objectArray[0];
                n20 = dimension.height + (Integer)objectArray[1];
            }
            n16 = this.pos_y[n14];
            n15 = this.pos_x[n14];
            int n21 = 1;
            int n22 = 1;
            Object[] objectArray2 = (Object[])this.spanTable.get(component);
            if (objectArray2 != null) {
                n21 = (Integer)objectArray2[0];
                n22 = (Integer)objectArray2[1];
            }
            int n23 = this.align;
            Object v = this.alignmentTable.get(component);
            if (v != null && v instanceof Integer) {
                n23 = (Integer)v;
            }
            int n24 = n19;
            int n25 = n20;
            Object[] objectArray3 = (Object[])this.padTable.get(component);
            int n26 = this.padx;
            int n27 = this.pady;
            if (objectArray3 != null) {
                n26 = (Integer)objectArray3[0];
                n27 = (Integer)objectArray3[1];
            }
            if ((n23 & 4) != 0) {
                n18 = this.grid_x[n15] + n26;
                if ((n23 & 8) != 0) {
                    n24 = this.grid_x[n15 + n21] - this.grid_x[n15] - n26 * 2;
                }
            } else {
                n18 = (n23 & 8) != 0 ? this.grid_x[n15 + n21] - n24 - n26 : (this.grid_x[n15] + this.grid_x[n15 + n21] - n24) / 2;
            }
            if ((n23 & 1) != 0) {
                n17 = this.grid_y[n16] + n27;
                if ((n23 & 2) != 0) {
                    n25 = this.grid_y[n16 + n22] - this.grid_y[n16] - n27 * 2;
                }
            } else {
                n17 = (n23 & 2) != 0 ? this.grid_y[n16 + n22] - n25 - n27 : (this.grid_y[n16] + this.grid_y[n16 + n22] - n25) / 2;
            }
            component.setBounds(n18, n17, n24, n25);
            ++n14;
        }
    }

    boolean fit(int n, int n2, int n3, int n4, BitSet[] bitSetArray) {
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                if (n + n5 >= this.cols) {
                    return false;
                }
                if (bitSetArray[n + n5].get(n2 + n6)) {
                    return false;
                }
                ++n6;
            }
            ++n5;
        }
        return true;
    }

    static Hashtable str2table(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "= ");
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            hashtable.put(string3, string4);
        }
        return hashtable;
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        if (!this.valid) {
            throw new RuntimeException("PnutsLayout not valid");
        }
        return this.rows;
    }

    public Point getGridPoint(Container container, int n, int n2) {
        if (!this.valid) {
            return null;
        }
        return new Point(this.grid_x[n], this.grid_y[n2]);
    }

    public Rectangle getGridRectangle(Container container, int n) {
        if (!this.valid) {
            return null;
        }
        int n2 = this.pos_x[n];
        int n3 = this.pos_y[n];
        int n4 = this.grid_x[n2];
        int n5 = this.grid_y[n3];
        Object[] objectArray = (Object[])this.spanTable.get(container.getComponent(n));
        int n6 = 1;
        int n7 = 1;
        if (objectArray != null) {
            n6 = (Integer)objectArray[0];
            n7 = (Integer)objectArray[1];
        }
        return new Rectangle(n4, n5, this.grid_x[n2 + n6] - n4, this.grid_y[n3 + n7] - n5);
    }

    public String toString() {
        return this.getClass().getName() + "[cols=" + this.cols + ",padx=" + this.padx + ",pady=" + this.pady + ",ipadx=" + this.ipadx + ",ipady=" + this.ipady + "]";
    }

    static {
        int n = 0;
        while (n < integer.length) {
            PnutsLayout.integer[n] = new Integer(n);
            ++n;
        }
        zero = new int[16];
        n = 0;
        while (n < zero.length) {
            PnutsLayout.zero[n] = 0;
            ++n;
        }
    }
}

