/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.DoubleWithError;
import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class ScientificFormat
extends Format {
    private int sigDigit = 5;
    private int maxWidth = 8;
    private boolean SciNote = false;
    private static final double k = 1.0 / Math.log(10.0);

    public ScientificFormat() {
    }

    public ScientificFormat(int n, int n2, boolean bl) {
        this.setSigDigits(n);
        this.setMaxWidth(n2);
        this.setScientificNotationStyle(bl);
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Number) {
            String string = this.format(((Number)object).doubleValue());
            return stringBuffer.append(string);
        }
        if (object instanceof DoubleWithError) {
            DoubleWithError doubleWithError = (DoubleWithError)object;
            stringBuffer.append(this.format(doubleWithError.getValue()));
            stringBuffer.append("\u00b1");
            int n = this.resolveErrorSigDigit(doubleWithError.getValue(), doubleWithError.getError());
            stringBuffer.append(this.formatError(n, doubleWithError.getError()));
            return stringBuffer;
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return null;
    }

    public int getSigDigits() {
        return this.sigDigit;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public boolean getScientificNotationStyle() {
        return this.SciNote;
    }

    public void setSigDigits(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("sigDigit");
        }
        this.sigDigit = n;
    }

    public void setMaxWidth(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("maxWidth");
        }
        this.maxWidth = n;
    }

    public void setScientificNotationStyle(boolean bl) {
        this.SciNote = bl;
    }

    private double Log10(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        return Math.log(d) * k;
    }

    private int resolveErrorSigDigit(double d, double d2) {
        d2 = Math.abs(d2);
        d = Math.abs(d);
        if (d2 == 0.0 || Double.isInfinite(d2) || Double.isNaN(d2) || d2 >= d) {
            return this.sigDigit;
        }
        if (d == 0.0 || Double.isInfinite(d) || Double.isNaN(d)) {
            return this.sigDigit;
        }
        int n = (int)Math.round(this.Log10(d2 / d));
        int n2 = this.sigDigit + n;
        if (n2 < 1) {
            return 1;
        }
        return n2;
    }

    public String format(double d) {
        if (Double.isInfinite(d)) {
            return this.maxWidth < 8 ? "INF" : "Infinite";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        String string = "";
        double d2 = 0.0;
        int n = 0;
        int n2 = 0;
        if (d == 0.0) {
            return "0";
        }
        d2 = d;
        n2 = (int)Math.floor(this.Log10(d = Math.abs(d2)));
        if (n2 > -1 && d % Math.pow(10.0, n2 + 1) == 0.0) {
            ++n2;
        }
        n = this.Log10(d) < 0.0 ? this.sigDigit - n2 - 1 : this.sigDigit - n2;
        long l = Math.round(Math.pow(10.0, n) * d);
        String string2 = String.valueOf(l);
        BigDecimal bigDecimal = new BigDecimal(Math.pow(10.0, n) * d);
        long l2 = bigDecimal.longValue();
        String string3 = String.valueOf(l2);
        if (string2.length() > string3.length()) {
            ++n2;
        }
        if (!this.SciNote) {
            if (n2 < 0) {
                String string4 = "";
                int n3 = 0;
                while (n3 < Math.abs(n2) - 1) {
                    string4 = string4 + "0";
                    ++n3;
                }
                string = "0." + string4 + string2;
            } else {
                String[] stringArray = new String[n2 + 1];
                int n4 = 0;
                while (n4 <= n2) {
                    stringArray[n4] = "0";
                    ++n4;
                }
                int n5 = 0;
                while (n5 < string2.length() && n5 <= n2) {
                    stringArray[n5] = string2.substring(n5, n5 + 1);
                    ++n5;
                }
                int n6 = 0;
                while (n6 <= stringArray.length - 1) {
                    string = string + stringArray[n6];
                    ++n6;
                }
                int n7 = string.length();
                if (n7 < this.sigDigit) {
                    String string5 = "";
                    int n8 = -1;
                    if (n2 == 0) {
                        while (n7 < this.sigDigit) {
                            string5 = string5 + string2.substring(string.length() + n8 + 1, string.length() + n8 + 2);
                            ++n7;
                            ++n8;
                        }
                    } else {
                        n8 = 0;
                        while (n7 < this.sigDigit) {
                            string5 = string5 + string2.substring(string.length() + n8, string.length() + n8 + 1);
                            ++n7;
                            ++n8;
                        }
                    }
                    string = string + "." + string5;
                }
            }
            if (string.length() > this.maxWidth) {
                string = string2.substring(0, 1) + "." + string2.substring(1, this.sigDigit) + "E" + n2;
            }
        }
        if (this.SciNote) {
            string = string2.substring(0, 1) + "." + string2.substring(1, this.sigDigit) + "E" + n2;
        }
        if (d2 > 0.0) {
            return string;
        }
        return "-" + string;
    }

    public String formatError(int n, double d) {
        if (Double.isInfinite(d)) {
            return this.maxWidth < 8 ? "INF" : "Infinite";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        int n2 = n;
        String string = "";
        double d2 = 0.0;
        int n3 = 0;
        int n4 = 0;
        if (d == 0.0) {
            return "0";
        }
        d2 = d;
        n4 = (int)Math.floor(this.Log10(d = Math.abs(d2)));
        if (n4 > -1 && d % Math.pow(10.0, n4 + 1) == 0.0) {
            ++n4;
        }
        n3 = this.Log10(d) < 0.0 ? n2 - n4 - 1 : n2 - n4;
        long l = Math.round(Math.pow(10.0, n3) * d);
        String string2 = String.valueOf(l);
        BigDecimal bigDecimal = new BigDecimal(Math.pow(10.0, n3) * d);
        long l2 = bigDecimal.longValue();
        String string3 = String.valueOf(l2);
        if (string2.length() > string3.length()) {
            ++n4;
        }
        if (!this.SciNote) {
            if (n4 < 0) {
                String string4 = "";
                int n5 = 0;
                while (n5 < Math.abs(n4) - 1) {
                    string4 = string4 + "0";
                    ++n5;
                }
                string = "0." + string4 + string2;
            } else {
                String[] stringArray = new String[n4 + 1];
                int n6 = 0;
                while (n6 <= n4) {
                    stringArray[n6] = "0";
                    ++n6;
                }
                int n7 = 0;
                while (n7 < string2.length() && n7 <= n4) {
                    stringArray[n7] = string2.substring(n7, n7 + 1);
                    ++n7;
                }
                int n8 = 0;
                while (n8 <= stringArray.length - 1) {
                    string = string + stringArray[n8];
                    ++n8;
                }
                int n9 = string.length();
                if (n9 < n2) {
                    String string5 = "";
                    int n10 = -1;
                    if (n4 == 0) {
                        while (n9 < n2) {
                            string5 = string5 + string2.substring(string.length() + n10 + 1, string.length() + n10 + 2);
                            ++n9;
                            ++n10;
                        }
                    } else {
                        n10 = 0;
                        while (n9 < n2) {
                            string5 = string5 + string2.substring(string.length() + n10, string.length() + n10 + 1);
                            ++n9;
                            ++n10;
                        }
                    }
                    string = string + "." + string5;
                }
            }
            if (string.length() > this.maxWidth) {
                string = string2.substring(0, 1) + "." + string2.substring(1, n2) + "E" + n4;
            }
        }
        if (this.SciNote) {
            string = string2.substring(0, 1) + "." + string2.substring(1, n2) + "E" + n4;
        }
        if (d2 > 0.0) {
            return string;
        }
        return "-" + string;
    }
}

