/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.ScientificFormat;
import jas.util.SpinBox;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SciFormatPanel
extends JPanel
implements ActionListener {
    private ScientificFormat f;
    private JLabel WidthLabel;
    private JLabel SigLabel;
    private JPanel DisplayStyle;
    private JRadioButton PureSci;
    private JRadioButton StandardSci;
    private SpinBox widthdigits;
    private SpinBox sigdigits;

    public SciFormatPanel(ScientificFormat scientificFormat) {
        this.f = scientificFormat;
        this.createPanel();
    }

    private void createPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.SigLabel = new JLabel("Significant Digits");
        this.WidthLabel = new JLabel("Maximum Digits");
        this.sigdigits = new SpinBox(this.f.getSigDigits(), 1, 15);
        this.widthdigits = new SpinBox(this.f.getMaxWidth(), 1, 100);
        this.sigdigits.setValue(this.f.getSigDigits());
        this.widthdigits.setValue(this.f.getMaxWidth());
        this.sigdigits.addActionListener(new MySpinBoxListener());
        this.widthdigits.addActionListener(new MySpinBoxListener());
        if (this.f.getScientificNotationStyle()) {
            this.widthdigits.setEnabled(false);
            this.WidthLabel.setEnabled(false);
        }
        jPanel.add(this.SigLabel);
        jPanel.add(this.sigdigits);
        jPanel.add(this.WidthLabel);
        jPanel.add(this.widthdigits);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        this.PureSci = new JRadioButton("Use Pure Scientific Notation", this.f.getScientificNotationStyle());
        this.PureSci.setActionCommand("PureSci");
        this.PureSci.addActionListener(this);
        this.StandardSci = new JRadioButton("Use Standard Scientific Notation", !this.f.getScientificNotationStyle());
        this.StandardSci.setActionCommand("StandSci");
        this.StandardSci.addActionListener(this);
        jPanel2.add(this.PureSci);
        jPanel2.add(this.StandardSci);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.PureSci);
        buttonGroup.add(this.StandardSci);
        this.DisplayStyle = new JPanel();
        this.DisplayStyle.setLayout(new GridLayout(2, 1));
        this.DisplayStyle.add(jPanel);
        this.DisplayStyle.add(jPanel2);
    }

    public void updateSciFormat() {
        this.f.setMaxWidth(this.widthdigits.getValue());
        this.f.setSigDigits(this.sigdigits.getValue());
        this.f.setScientificNotationStyle(this.PureSci.isSelected());
    }

    public JPanel getPanel() {
        return this.DisplayStyle;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "StandSci") {
            this.WidthLabel.setEnabled(true);
            this.widthdigits.setEnabled(true);
        } else if (actionEvent.getActionCommand() == "PureSci") {
            this.WidthLabel.setEnabled(false);
            this.widthdigits.setEnabled(false);
        }
    }

    class MySpinBoxListener
    implements ActionListener {
        MySpinBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SciFormatPanel.this.widthdigits.getValue() < SciFormatPanel.this.sigdigits.getValue()) {
                SciFormatPanel.this.widthdigits.setValue(SciFormatPanel.this.sigdigits.getValue());
            }
        }
    }
}

