/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.DateListener;
import jas.util.DateModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

class CalendarPane
extends JComponent
implements DateListener,
ActionListener {
    private JButton selectedButton;
    private Color fg;
    private Color bg;
    private Dimension buttonSize;
    private Dimension panelSize;
    private Point hidden;
    private DateModel model;
    private JButton[] days;
    private static final String[] labels = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

    CalendarPane(DateModel dateModel) {
        this.model = dateModel;
        dateModel.addDateListener(this);
        this.setLayout(null);
        Insets insets = new Insets(1, 1, 1, 1);
        this.days = new JButton[31];
        int n = 0;
        while (n < 31) {
            this.days[n] = new JButton(String.valueOf(n + 1));
            this.days[n].addActionListener(this);
            this.add(this.days[n]);
            ++n;
        }
        this.fg = this.days[30].getForeground();
        this.bg = this.days[30].getBackground();
        this.buttonSize = this.days[30].getPreferredSize();
        this.panelSize = new Dimension(this.buttonSize.width * 7, this.buttonSize.height * 7);
        this.hidden = new Point(this.buttonSize.width * 10, this.buttonSize.height * 10);
        int n2 = 0;
        while (n2 < 31) {
            this.days[n2].setSize(this.buttonSize);
            ++n2;
        }
        int n3 = 0;
        while (n3 < 7) {
            JLabel jLabel = new JLabel(labels[n3], 0);
            this.add(jLabel);
            jLabel.setLocation(n3 * this.buttonSize.width, 0);
            jLabel.setSize(this.buttonSize);
            ++n3;
        }
        this.layoutCalendar();
    }

    public Dimension getPreferredSize() {
        return this.panelSize;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = Integer.valueOf(string);
        this.model.set(5, n);
    }

    public void dateChanged() {
        this.layoutCalendar();
    }

    void layoutCalendar() {
        Calendar calendar = this.model.getCalendar();
        int n = calendar.get(5) - 1;
        if (this.selectedButton != this.days[n]) {
            if (this.selectedButton != null) {
                this.selectedButton.setForeground(this.fg);
                this.selectedButton.setBackground(this.bg);
                this.selectedButton.repaint();
            }
            this.selectedButton = this.days[n];
            this.selectedButton.setForeground(UIManager.getColor("textHighlightText"));
            this.selectedButton.setBackground(UIManager.getColor("textHighlight"));
            this.selectedButton.repaint();
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(5, 1);
        int n2 = 0;
        while (n2 < this.model.getDaysInMonth()) {
            int n3 = (calendar2.get(7) - 1) * this.buttonSize.width;
            int n4 = calendar2.get(4) * this.buttonSize.height;
            this.days[n2].setLocation(n3, n4);
            calendar2.add(5, 1);
            ++n2;
        }
        while (n2 < 31) {
            this.days[n2].setLocation(this.hidden);
            ++n2;
        }
    }
}

