/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio.adaptor;

import jas.swingstudio.TreeAdaptor;
import jas.util.OnScreenPopupMenu;
import jas.util.tree.OrderedNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class FolderTreeAdaptor
extends TreeAdaptor
implements ActionListener {
    private Object folder;
    private JRadioButtonMenuItem b1;
    private JRadioButtonMenuItem b2;
    private JRadioButtonMenuItem b3;
    private JCheckBoxMenuItem b4;

    public void init() {
        this.folder = this.getAssociatedObject();
    }

    public void onSelect() {
        if (this.folder != null) {
            this.getPluginContext().sendMessage(this.folder.toString());
        }
    }

    protected JPopupMenu getPopupMenu() {
        OrderedNode orderedNode = (OrderedNode)((Object)this.getAdaptorSite());
        FolderComparator folderComparator = (FolderComparator)orderedNode.getOrder();
        OnScreenPopupMenu onScreenPopupMenu = new OnScreenPopupMenu();
        JMenu jMenu = new JMenu("Sort");
        this.b1 = new JRadioButtonMenuItem("As Parent Folder", folderComparator == null);
        this.b2 = new JRadioButtonMenuItem("By Creation Time", folderComparator != null && !folderComparator.alphabetical());
        this.b3 = new JRadioButtonMenuItem("Alphabetically", folderComparator != null && folderComparator.alphabetical());
        this.b4 = new JCheckBoxMenuItem("Folders First", folderComparator != null && folderComparator.foldersFirst());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.b1);
        buttonGroup.add(this.b2);
        buttonGroup.add(this.b3);
        this.b1.addActionListener(this);
        this.b2.addActionListener(this);
        this.b3.addActionListener(this);
        this.b4.addActionListener(this);
        jMenu.add(this.b1);
        jMenu.add(this.b2);
        jMenu.add(this.b3);
        jMenu.add(this.b4);
        onScreenPopupMenu.add(jMenu);
        return onScreenPopupMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OrderedNode orderedNode = (OrderedNode)((Object)this.getAdaptorSite());
        Object object = actionEvent.getSource();
        boolean bl = this.b4.isSelected();
        if (object == this.b1) {
            orderedNode.clearOrder();
        } else {
            orderedNode.setOrder(new FolderComparator(this.b3.isSelected(), bl));
        }
    }

    private static class FolderComparator
    implements Comparator {
        private boolean foldersFirst;
        private boolean alphabetical;

        FolderComparator(boolean bl, boolean bl2) {
            this.foldersFirst = bl2;
            this.alphabetical = bl;
        }

        public int compare(Object object, Object object2) {
            OrderedNode orderedNode = (OrderedNode)object;
            OrderedNode orderedNode2 = (OrderedNode)object2;
            if (this.foldersFirst) {
                boolean bl;
                boolean bl2 = (orderedNode.getFlags() & 4) != 0;
                boolean bl3 = bl = (orderedNode2.getFlags() & 4) != 0;
                if (bl2 && !bl) {
                    return -1;
                }
                if (!bl2 && bl) {
                    return 1;
                }
            }
            if (this.alphabetical) {
                return orderedNode.getName().compareTo(orderedNode2.getName());
            }
            return orderedNode.getNaturalIndex() - orderedNode2.getNaturalIndex();
        }

        boolean alphabetical() {
            return this.alphabetical;
        }

        boolean foldersFirst() {
            return this.foldersFirst;
        }
    }
}

