/*
 * Decompiled with CFR 0.152.
 */
package jas.job;

import hep.analysis.EndOfDataException;
import hep.analysis.EventAnalyzer;
import hep.analysis.EventData;
import hep.analysis.EventGenerator;
import hep.analysis.EventSource;
import hep.analysis.Job;
import hep.analysis.PeerSupport;
import jas.jds.module.AnnotatedEventSource;
import jas.job.AnalysisException;
import jas.job.BasicJob;
import jas.job.JobFolder;
import jas.job.LoaderException;
import jas.job.NoSuchItemError;
import jas.util.tree.SimpleNode;
import jas.util.tree.TreeItem;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;

public abstract class AbstractJob
extends Observable
implements BasicJob {
    private transient Job m_hepJob;
    private boolean m_stopEventLoop;
    private ClassLoader m_loader;
    private EventData m_event;
    private boolean m_persistent = false;
    private Thread m_eventLoopThread;
    private String m_name;
    private String m_state;
    private Thread m_active;
    private SimpleNode m_source;
    private EventSourceStatus m_status;
    private Hashtable m_statusMap = new Hashtable();
    private SimpleNode m_dataSets;
    private SimpleNode m_programs;
    private JobFolder m_root;
    private EventAnalyzer[] m_analyzer = new EventAnalyzer[10];
    private int m_nAnalyzers = 0;
    static /* synthetic */ Class class$hep$analysis$EventGenerator;
    static /* synthetic */ Class class$hep$analysis$EventAnalyzer;

    public AbstractJob(String string) {
        this.m_state = "Active";
        this.m_name = string;
    }

    protected void setRoot(JobFolder jobFolder) {
        this.m_root = jobFolder;
    }

    public AbstractJob() {
    }

    public void setHepAnalysisJob(Job job) {
        this.m_hepJob = job;
    }

    public Job getHepAnalysisJob() {
        return this.m_hepJob;
    }

    public SimpleNode getTreeRoot() {
        return this.m_root;
    }

    public final void setEventSource(EventGenerator eventGenerator) {
        if (this.m_programs == null) {
            this.createProgramNode();
        }
        String string = eventGenerator.getClass().getName();
        if (this.m_dataSets != null && this.m_dataSets.findChild(string) != null) {
            int n = 2;
            while (this.m_dataSets.findChild(string = eventGenerator.getClass().getName() + " (" + n + ")") != null) {
                ++n;
            }
        }
        SimpleNode simpleNode = this.m_programs.add(new TreeItem(string, "generator"), eventGenerator);
        this.setCurrentEventSource(simpleNode);
        this.notifyInfo();
    }

    public final void setEventSource(EventSource eventSource) {
        SimpleNode simpleNode;
        String string;
        if (this.m_dataSets == null) {
            this.createDataSetNode();
        }
        if (this.m_dataSets.findChild(string = eventSource.getName()) != null) {
            int n = 2;
            while (this.m_dataSets.findChild(string = eventSource.getName() + " (" + n + ")") != null) {
                ++n;
            }
        }
        TreeItem treeItem = new TreeItem(string, "dataset", 458752);
        if (eventSource instanceof AnnotatedEventSource) {
            SimpleNode simpleNode2;
            boolean bl = false;
            TreeItem[] treeItemArray = ((AnnotatedEventSource)eventSource).getItems();
            int n = 0;
            while (n < treeItemArray.length) {
                if (treeItemArray[n].type.equals("eventSourceFolder")) {
                    treeItemArray[n].flags |= 0x20000;
                    if (!bl) {
                        bl = true;
                        treeItemArray[n].flags |= 0x40000;
                    }
                }
                ++n;
            }
            if (bl) {
                treeItem.flags &= 0xFFF9FFFF;
            }
            simpleNode = simpleNode2 = this.m_dataSets.add(treeItem, eventSource);
            int n2 = 0;
            while (n2 < treeItemArray.length) {
                SimpleNode simpleNode3 = simpleNode2.add(treeItemArray[n2]);
                if ((treeItemArray[n2].flags & 0x40000) != 0) {
                    simpleNode = simpleNode3;
                }
                ++n2;
            }
        } else {
            simpleNode = this.m_dataSets.add(treeItem, eventSource);
        }
        this.setCurrentEventSource(simpleNode);
        this.notifyInfo();
    }

    public void closeDataset(TreeItem treeItem) {
        SimpleNode simpleNode = this.m_root.find(treeItem);
        EventSource eventSource = (EventSource)simpleNode.getObject();
        if (this.m_source.isAncestorOf(simpleNode)) {
            this.setCurrentEventSource(null);
        }
        this.m_statusMap.remove(simpleNode);
        Enumeration enumeration = this.m_statusMap.keys();
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode2 = (SimpleNode)enumeration.nextElement();
            if (!simpleNode2.isAncestorOf(simpleNode)) continue;
            this.m_statusMap.remove(simpleNode2);
        }
        simpleNode.destroy();
        eventSource.close();
        this.notifyInfo();
    }

    public void setEventSource(TreeItem treeItem) {
        SimpleNode simpleNode = this.m_root.find(treeItem);
        this.setCurrentEventSource(simpleNode);
        this.notifyInfo();
    }

    public final Class getEventDataClass(TreeItem treeItem) {
        try {
            return ((EventSource)this.getItem(treeItem)).getEventDataClass();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setCurrentEventSource(SimpleNode simpleNode) {
        if (this.m_source != null) {
            this.m_source.clearFlags(262144);
        }
        this.m_source = simpleNode;
        if (this.m_source != null) {
            this.m_source.setFlags(262144);
            this.m_status = (EventSourceStatus)this.m_statusMap.get(this.m_source);
            if (this.m_status == null) {
                this.m_status = new EventSourceStatus();
                this.m_statusMap.put(this.m_source, this.m_status);
            }
        }
    }

    public final void addEventAnalyzer(EventAnalyzer eventAnalyzer) {
        if (this.m_programs == null) {
            this.createProgramNode();
        }
        this.m_programs.add(new TreeItem(eventAnalyzer.getClass().getName(), "analyzer"), eventAnalyzer);
        if (this.m_nAnalyzers >= this.m_analyzer.length) {
            EventAnalyzer[] eventAnalyzerArray = new EventAnalyzer[this.m_nAnalyzers * 2];
            System.arraycopy(this.m_analyzer, 0, eventAnalyzerArray, 0, this.m_nAnalyzers);
            this.m_analyzer = eventAnalyzerArray;
        }
        this.m_analyzer[this.m_nAnalyzers++] = eventAnalyzer;
        this.notifyInfo();
    }

    public final void removeAllEventAnalyzers() {
        this.m_nAnalyzers = 0;
        this.notifyInfo();
    }

    public final void removeEventAnalyzer(EventAnalyzer eventAnalyzer) {
    }

    public void close() {
        this.setCurrentEventSource(null);
        if (this.m_dataSets != null) {
            Enumeration enumeration = this.m_dataSets.elements();
            while (enumeration.hasMoreElements()) {
                EventSource eventSource = (EventSource)enumeration.nextElement();
                eventSource.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadObject(String string) throws LoaderException {
        try {
            try {
                Object[] objectArray = new Class[]{};
                this.setActiveThread();
                Class<?> clazz = this.m_loader.loadClass(string);
                this.resetFolders();
                if ((class$hep$analysis$EventGenerator == null ? (class$hep$analysis$EventGenerator = AbstractJob.class$("hep.analysis.EventGenerator")) : class$hep$analysis$EventGenerator).isAssignableFrom(clazz)) {
                    Constructor<?> constructor = clazz.getConstructor((Class<?>[])objectArray);
                    this.setEventSource((EventGenerator)constructor.newInstance(objectArray));
                    Object var8_11 = null;
                    this.setActiveThread(null);
                    return;
                }
                if (!(class$hep$analysis$EventAnalyzer == null ? (class$hep$analysis$EventAnalyzer = AbstractJob.class$("hep.analysis.EventAnalyzer")) : class$hep$analysis$EventAnalyzer).isAssignableFrom(clazz)) throw new LoaderException("Class " + string + " must extend EventGenerator or EventAnalyzer");
                Constructor<?> constructor = clazz.getConstructor((Class<?>[])objectArray);
                this.addEventAnalyzer((EventAnalyzer)constructor.newInstance(objectArray));
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                PrintWriter printWriter = new PrintWriter(this.getErrorStream());
                printWriter.println("Error occured during instantiation of " + string);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                throw new LoaderException("Error instantiating " + string + " (See Output window for details)", throwable);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new LoaderException("Class " + string + " must be public and have public constructor with zero arguments", noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new LoaderException("Class " + string + " must be public and have public constructor with zero arguments", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new LoaderException("Error creating object of class " + string, instantiationException);
            }
            catch (Throwable throwable) {
                throw new LoaderException("Could not load class " + string, throwable);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.setActiveThread(null);
            throw throwable;
        }
        Object var8_12 = null;
        this.setActiveThread(null);
    }

    public void unloadAll() {
        this.m_nAnalyzers = 0;
        if (this.m_source != null && this.m_source.getObject() instanceof EventGenerator) {
            EventGenerator eventGenerator = (EventGenerator)this.m_source.getObject();
            eventGenerator.close();
        }
        if (this.m_programs != null) {
            this.m_programs.destroy();
            this.m_programs = null;
        }
    }

    protected final void setClassLoader(ClassLoader classLoader) {
        this.m_loader = classLoader;
    }

    public Object getItem(TreeItem treeItem) {
        SimpleNode simpleNode = this.m_root.find(treeItem);
        if (simpleNode == null) {
            throw new NoSuchItemError("Cannot find node " + treeItem);
        }
        Object object = simpleNode.getObject();
        if (object == null) {
            throw new NoSuchItemError("Cannot find object " + treeItem);
        }
        return object;
    }

    protected void setState(String string) {
        this.m_state = string;
    }

    private final void beforeFirstEvent() {
        ((EventSource)this.m_source.getObject()).beforeFirstEvent();
        int n = 0;
        while (n < this.m_nAnalyzers) {
            this.resetFolders();
            this.m_analyzer[n].beforeFirstEvent();
            ++n;
        }
    }

    private final void afterLastEvent() {
        ((EventSource)this.m_source.getObject()).afterLastEvent();
        int n = 0;
        while (n < this.m_nAnalyzers) {
            this.resetFolders();
            this.m_analyzer[n].afterLastEvent();
            ++n;
        }
    }

    private final void processEvent(EventData eventData) {
        int n = 0;
        while (n < this.m_nAnalyzers) {
            this.resetFolders();
            this.m_analyzer[n].processEvent(eventData);
            ++n;
        }
    }

    public final boolean isRunnable() {
        return this.m_eventLoopThread == null && this.m_source != null;
    }

    public final boolean isAtEndOfData() {
        return this.m_status == null ? false : this.m_status.m_atEndOfData;
    }

    public final boolean isAtStartOfData() {
        return this.m_status == null ? true : this.m_status.m_atStartOfData;
    }

    public final boolean isRunning() {
        return this.m_eventLoopThread != null;
    }

    public final boolean isPersistent() {
        return this.m_persistent;
    }

    public final void rewind() {
        this.m_hepJob.rewind();
    }

    void doRewind() {
        this.m_status.m_atStartOfData = true;
        this.m_status.m_atEndOfData = false;
        this.m_status.m_eventsAnalyzed = 0;
        this.notifyInfo();
    }

    protected Thread createEventLoopThread(Runnable runnable) {
        return new Thread(runnable, "EventAnalysisThread");
    }

    public final void go(int n) {
        this.m_hepJob.go(n);
    }

    void doGo(int n) {
        EventLoop eventLoop = new EventLoop(n);
        this.m_eventLoopThread = this.createEventLoopThread(eventLoop);
        this.setState("running");
        this.notifyInfo();
        this.m_eventLoopThread.start();
    }

    public final void stop() {
        this.m_stopEventLoop = true;
        if (this.m_source.getObject() instanceof SlowEventSource) {
            ((SlowEventSource)this.m_source.getObject()).stop();
        }
        this.notifyInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void kill() {
        AbstractJob abstractJob = this;
        synchronized (abstractJob) {
            if (this.m_eventLoopThread != null) {
                this.m_eventLoopThread.stop();
            }
        }
        this.notifyInfo();
    }

    private final void setActiveThread(Thread thread) {
        this.m_active = thread;
    }

    public final void setActiveThread() {
        this.m_active = Thread.currentThread();
    }

    protected final Thread getActiveThread() {
        return this.m_active;
    }

    public final String getName() {
        return this.m_name;
    }

    public final EventData getEvent() {
        return this.m_event;
    }

    public final String getState() {
        return this.m_state;
    }

    public final int eventsTotal() {
        return this.m_source == null ? 0 : ((EventSource)this.m_source.getObject()).getTotalNumberOfEvents();
    }

    public final int eventsAnalyzed() {
        return this.m_status == null ? 0 : this.m_status.m_eventsAnalyzed;
    }

    public void receiveMessage(Object object) {
    }

    public final void setPersistent(boolean bl) {
        this.m_persistent = bl;
    }

    private void createDataSetNode() {
        if (this.m_dataSets == null) {
            this.m_dataSets = this.m_root.add(new TreeItem("Data"));
        }
    }

    private void createProgramNode() {
        if (this.m_programs == null) {
            this.m_programs = this.m_root.add(new TreeItem("Programs"));
        }
    }

    private final void resetFolders() {
        PeerSupport.resetFolders((Job)this.m_hepJob);
    }

    void goEnded() {
        PeerSupport.done((Job)this.m_hepJob);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof EventSource) {
            this.notifyInfo();
        }
    }

    protected abstract void notifyInfo();

    protected abstract void notifyInfo(int var1);

    protected abstract OutputStream getErrorStream();

    protected abstract OutputStream getLogStream();

    protected abstract void sendMessage(String var1);

    protected abstract void reportError(AnalysisException var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EventLoop
    implements Runnable {
        private int m_maxEvents;

        EventLoop(int n) {
            this.m_maxEvents = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            AbstractJob.this.m_stopEventLoop = false;
            EventData eventData = null;
            long l = System.currentTimeMillis();
            int n = ((AbstractJob)AbstractJob.this).m_status.m_eventsAnalyzed;
            EventSource eventSource = (EventSource)AbstractJob.this.m_source.getObject();
            try {
                try {
                    long l2 = System.currentTimeMillis() + 100L;
                    if (((AbstractJob)AbstractJob.this).m_status.m_atStartOfData) {
                        AbstractJob.this.beforeFirstEvent();
                        ((AbstractJob)AbstractJob.this).m_status.m_atStartOfData = false;
                    }
                    try {
                        int n2 = 0;
                        while (this.m_maxEvents == 0 || n2 < this.m_maxEvents) {
                            long l3 = System.currentTimeMillis();
                            if (l3 > l2) {
                                AbstractJob.this.notifyInfo(((AbstractJob)AbstractJob.this).m_status.m_eventsAnalyzed);
                                l2 = l3 + 100L;
                            }
                            eventData = eventSource.getNextEvent();
                            AbstractJob.this.processEvent(eventData);
                            ++((AbstractJob)AbstractJob.this).m_status.m_eventsAnalyzed;
                            if (!AbstractJob.this.m_stopEventLoop && !Thread.interrupted()) {
                                ++n2;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (EndOfDataException endOfDataException) {
                        ((AbstractJob)AbstractJob.this).m_status.m_atEndOfData = true;
                        eventData = null;
                        AbstractJob.this.afterLastEvent();
                    }
                    Object var12_12 = null;
                }
                catch (EventSourceStopped eventSourceStopped) {
                    Object var12_13 = null;
                    long l8 = System.currentTimeMillis();
                    AbstractJob.this.goEnded();
                    AbstractJob.this.m_event = eventData;
                    AbstractJob.this.setState("Active");
                    AbstractJob abstractJob2 = AbstractJob.this;
                    synchronized (abstractJob2) {
                        AbstractJob.this.m_eventLoopThread = null;
                    }
                    AbstractJob.this.notifyInfo();
                    long l7 = l8 - l;
                    int n2 = ((AbstractJob)AbstractJob.this).m_status.m_eventsAnalyzed - n;
                    AbstractJob.this.sendMessage("Analyzed " + n2 + " events in " + l7 + " milliseconds");
                    return;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    PrintWriter printWriter = new PrintWriter(AbstractJob.this.getErrorStream());
                    throwable.printStackTrace(printWriter);
                    printWriter.flush();
                    AbstractJob.this.reportError(new AnalysisException(throwable.getMessage()));
                    Object var12_14 = null;
                    long l10 = System.currentTimeMillis();
                    AbstractJob.this.goEnded();
                    AbstractJob.this.m_event = eventData;
                    AbstractJob.this.setState("Active");
                    AbstractJob abstractJob3 = AbstractJob.this;
                    synchronized (abstractJob3) {
                        AbstractJob.this.m_eventLoopThread = null;
                    }
                    AbstractJob.this.notifyInfo();
                    long l2 = l10 - l;
                    int n3 = ((AbstractJob)AbstractJob.this).m_status.m_eventsAnalyzed - n;
                    AbstractJob.this.sendMessage("Analyzed " + n3 + " events in " + l2 + " milliseconds");
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                long l4 = System.currentTimeMillis();
                AbstractJob.this.goEnded();
                AbstractJob.this.m_event = eventData;
                AbstractJob.this.setState("Active");
                AbstractJob abstractJob = AbstractJob.this;
                synchronized (abstractJob) {
                    AbstractJob.this.m_eventLoopThread = null;
                }
                AbstractJob.this.notifyInfo();
                long l9 = l4 - l;
                int n4 = ((AbstractJob)AbstractJob.this).m_status.m_eventsAnalyzed - n;
                AbstractJob.this.sendMessage("Analyzed " + n4 + " events in " + l9 + " milliseconds");
                throw throwable;
            }
            long l6 = System.currentTimeMillis();
            AbstractJob.this.goEnded();
            AbstractJob.this.m_event = eventData;
            AbstractJob.this.setState("Active");
            AbstractJob abstractJob = AbstractJob.this;
            synchronized (abstractJob) {
                AbstractJob.this.m_eventLoopThread = null;
            }
            AbstractJob.this.notifyInfo();
            long l3 = l6 - l;
            int n5 = ((AbstractJob)AbstractJob.this).m_status.m_eventsAnalyzed - n;
            AbstractJob.this.sendMessage("Analyzed " + n5 + " events in " + l3 + " milliseconds");
        }
    }

    public static class EventSourceStopped
    extends RuntimeException {
    }

    public static interface SlowEventSource {
        public void stop();
    }

    private class EventSourceStatus {
        int m_eventsAnalyzed = 0;
        boolean m_atStartOfData = true;
        boolean m_atEndOfData = false;

        private EventSourceStatus() {
        }
    }
}

