/*
 * Decompiled with CFR 0.152.
 */
package jas.jds;

import hep.analysis.Job;
import jas.jds.ConnectionMonitor;
import jas.jds.JDSClassLoader;
import jas.jds.JavaDataServerMonitor;
import jas.jds.JobNotFoundError;
import jas.jds.interfaces.RemoteClassLoader;
import jas.jds.interfaces.RemoteEventUpdate;
import jas.jds.interfaces.RemoteJobInfo;
import jas.jds.interfaces.RemoteJobUpdate;
import jas.jds.interfaces.RemotePrintBuffer;
import jas.jds.module.ServerRegistry;
import jas.job.AbstractJob;
import jas.job.AnalysisException;
import jas.job.JobFolder;
import jas.util.tree.SimpleNode;
import jas.util.tree.SimpleNodeListener;
import jas.util.tree.TreeItem;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class JDSJob
extends AbstractJob {
    private boolean m_readOnly = false;
    private String m_user;
    private String m_node;
    private ConnectionMonitor m_monitor;
    private Vector m_menus = new Vector();
    private RemoteClassLoader m_remoteLoader;
    private int m_jobNumber;
    private Date m_creationTime = new Date();
    private static int m_nextJobNumber = 1;
    private static int m_jobNumberRange = 1000;
    private static int m_maxJobNumber = 0;
    private static JavaDataServerMonitor monitor = JavaDataServerMonitor.getMonitor();
    private static Vector jobList = new Vector();
    private OutputStream m_logStream = new JDSLogStream("Log Messages");
    private OutputStream m_errorStream = new JDSLogStream("Error Messages");
    static /* synthetic */ Class class$jas$jds$interfaces$RemoteClassLoader;

    public JDSJob(String string, Job job) {
        super(string);
        this.setHepAnalysisJob(job);
        this.m_user = "unknown";
        this.m_node = "unknown";
        this.m_jobNumber = this.nextJobNumber();
        jobList.addElement(this);
        if (monitor != null) {
            this.m_monitor = monitor.addJob(this);
        }
    }

    protected void setRoot(JobFolder jobFolder) {
        super.setRoot(jobFolder);
        jobFolder.addNodeListener(new SimpleNodeListener(){

            public void treeChanged(TreeItem treeItem) {
                JDSJob.this.notifyObservers(treeItem);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextJobNumber() {
        Vector vector = jobList;
        synchronized (vector) {
            int n;
            if (jobList.size() >= m_jobNumberRange / 2) {
                m_jobNumberRange *= 10;
            }
            block3: while (true) {
                if (++m_nextJobNumber >= m_jobNumberRange) {
                    m_nextJobNumber = 1;
                }
                if (n > m_maxJobNumber) {
                    m_maxJobNumber = n;
                    break;
                }
                Enumeration enumeration = jobList.elements();
                while (enumeration.hasMoreElements()) {
                    JDSJob jDSJob = (JDSJob)enumeration.nextElement();
                    if (jDSJob.m_jobNumber == n) continue block3;
                }
                break;
            }
            int n2 = n;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] listJobs() {
        Vector vector = jobList;
        synchronized (vector) {
            String[] stringArray;
            String[] stringArray2 = new String[jobList.size() + 1];
            stringArray2[0] = "Entry\\Name\\User\\Node\\Status\\Created";
            Enumeration enumeration = jobList.elements();
            int n = 1;
            while (enumeration.hasMoreElements()) {
                stringArray = (JDSJob)enumeration.nextElement();
                stringArray2[n] = stringArray.m_jobNumber + "\\" + stringArray.getName() + "\\" + stringArray.m_user + "\\" + stringArray.m_node + "\\" + stringArray.getState() + "\\" + stringArray.m_creationTime;
                ++n;
            }
            stringArray = stringArray2;
            return stringArray;
        }
    }

    public void listItems() {
        this.listItems(this.getTreeRoot(), this.getTreeRoot());
        this.notifyInfo();
    }

    private void listItems(SimpleNode simpleNode, SimpleNode simpleNode2) {
        Enumeration enumeration = simpleNode.children();
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode3 = (SimpleNode)enumeration.nextElement();
            this.notifyObservers(simpleNode3.getTreeItem(simpleNode2));
            this.listItems(simpleNode3, simpleNode2);
        }
    }

    public boolean hasChanged() {
        return true;
    }

    public void setOwner(String string, String string2) {
        this.m_user = string;
        this.m_node = string2;
    }

    void setRemoteLoader(RemoteClassLoader remoteClassLoader) {
        this.m_remoteLoader = remoteClassLoader;
        try {
            Class<?> clazz = Class.forName("jas.jds.JDSClassLoader2");
            Class[] classArray = new Class[]{class$jas$jds$interfaces$RemoteClassLoader == null ? (class$jas$jds$interfaces$RemoteClassLoader = JDSJob.class$("jas.jds.interfaces.RemoteClassLoader")) : class$jas$jds$interfaces$RemoteClassLoader};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{remoteClassLoader};
            ClassLoader classLoader = (ClassLoader)constructor.newInstance(objectArray);
            this.setClassLoader(classLoader);
        }
        catch (Throwable throwable) {
            this.setClassLoader(new JDSClassLoader(this.m_remoteLoader));
        }
    }

    public void unloadAll() {
        this.setClassLoader(new JDSClassLoader(this.m_remoteLoader));
        super.unloadAll();
    }

    public boolean isChanged() {
        return true;
    }

    void connect(String string, String string2) {
        this.m_user = string;
        this.m_node = string2;
        this.setState("Active");
    }

    public void close() {
        if (this.isPersistent()) {
            this.setState("Disconnected");
            return;
        }
        this.kill();
        super.close();
        jobList.removeElement(this);
        if (monitor != null) {
            monitor.deleteJob(this);
        }
    }

    public void finalize() {
        System.out.println("Job is finalized:" + this);
    }

    public void openDataSource(TreeItem treeItem) {
        this.setEventSource(ServerRegistry.open(treeItem));
    }

    public OutputStream getLogStream() {
        return this.m_logStream;
    }

    public OutputStream getErrorStream() {
        return this.m_errorStream;
    }

    public void sendMessage(String string) {
        this.notify(string);
    }

    protected void setState(String string) {
        super.setState(string);
        if (monitor != null) {
            monitor.updateJob(this);
        }
    }

    public void save() {
    }

    String getUser() {
        return this.m_user;
    }

    String getNode() {
        return this.m_node;
    }

    int getJobNumber() {
        return this.m_jobNumber;
    }

    ConnectionMonitor getMonitor() {
        return this.m_monitor;
    }

    public static Job currentJob() {
        Thread thread = Thread.currentThread();
        if (thread instanceof JobThread) {
            return ((JobThread)thread).getJob();
        }
        Enumeration enumeration = JDSJob.elements();
        while (enumeration.hasMoreElements()) {
            JDSJob jDSJob = (JDSJob)enumeration.nextElement();
            if (jDSJob.getActiveThread() != thread) continue;
            return jDSJob.getHepAnalysisJob();
        }
        throw new JobNotFoundError("No current job!");
    }

    protected Thread createEventLoopThread(Runnable runnable) {
        return new JobThread(runnable);
    }

    static Enumeration elements() {
        return jobList.elements();
    }

    static Enumeration elements(String string) {
        return jobList.elements();
    }

    static int countJobs() {
        return jobList.size();
    }

    static int countJobs(String string) {
        Enumeration enumeration = JDSJob.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (!((JDSJob)enumeration.nextElement()).getUser().equals(string)) continue;
            ++n;
        }
        return n;
    }

    static JDSJob findJob(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        Enumeration enumeration = JDSJob.elements();
        while (enumeration.hasMoreElements()) {
            JDSJob jDSJob = (JDSJob)enumeration.nextElement();
            if (n != jDSJob.m_jobNumber && !jDSJob.getName().equals(string)) continue;
            return jDSJob;
        }
        throw new JobNotFoundError("Could not find job " + string);
    }

    public RemoteJobInfo getJobInfo() {
        RemoteJobInfo remoteJobInfo = new RemoteJobInfo();
        remoteJobInfo.m_atEndOfData = this.isAtEndOfData();
        remoteJobInfo.m_atStartOfData = this.isAtStartOfData();
        remoteJobInfo.m_runnable = this.isRunnable();
        remoteJobInfo.m_running = this.isRunning();
        remoteJobInfo.m_name = this.getName();
        remoteJobInfo.m_eventsAnalyzed = this.eventsAnalyzed();
        remoteJobInfo.m_eventsTotal = this.eventsTotal();
        remoteJobInfo.m_persistent = this.isPersistent();
        remoteJobInfo.m_readOnly = this.m_readOnly;
        return remoteJobInfo;
    }

    protected void notifyInfo() {
        this.notifyObservers(new RemoteJobUpdate(this.getJobInfo()));
    }

    protected void notifyInfo(int n) {
        this.notifyObservers(new RemoteEventUpdate(n));
    }

    public final void notify(TreeItem treeItem) {
        this.notifyObservers(treeItem);
    }

    public final void notify(RemotePrintBuffer remotePrintBuffer) {
        this.notifyObservers(remotePrintBuffer);
    }

    private final void notify(String string) {
        this.notifyObservers(string);
    }

    protected final void reportError(AnalysisException analysisException) {
        this.notifyObservers(analysisException);
    }

    public void notifyObservers(Object object) {
        this.setChanged();
        super.notifyObservers(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class JDSLogStream
    extends OutputStream {
        private byte[] b = new byte[1];
        private String title;

        JDSLogStream(String string) {
            this.title = string;
        }

        public void write(int n) {
            this.b[0] = (byte)n;
            this.write(this.b);
        }

        public void write(byte[] byArray) {
            JDSJob.this.notify(new RemotePrintBuffer(this.title, byArray));
        }

        public void write(byte[] byArray, int n, int n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.write(byArray2);
        }
    }

    private class JobThread
    extends Thread {
        JobThread(Runnable runnable) {
            super(runnable);
            this.setName("EventLoopThread" + JDSJob.this.m_jobNumber);
        }

        Job getJob() {
            return JDSJob.this.getHepAnalysisJob();
        }
    }
}

