/*
 * Decompiled with CFR 0.152.
 */
package htmllayout;

import htmllayout.BadTableHtmlException;
import htmllayout.Cell;
import htmllayout.HtmlLayout;
import htmllayout.Scanner;

class TableParser {
    Scanner in;
    int rows = -1;
    int cols = -1;
    int hgap;
    int vgap;
    int hpad;
    int vpad;
    int horz = 4;
    int vert = 4;
    Cell[][] cells;
    int curRow;
    int curCol;
    int gridcount;
    int cellCount;
    boolean[][] taken;
    static final String[] values = new String[]{"HORZ", "VERT", "ROWS", "COLS", "HGAP", "VGAP", "HPAD", "VPAD", "COLSPAN", "ROWSPAN", "COMPONENT"};
    int pairValue;

    TableParser(Scanner scanner, boolean bl, TableParser tableParser) {
        this.in = scanner;
        if (bl && (scanner.scan() != 0 || scanner.scanU() != 4 || !scanner.currentString.equals("TABLE"))) {
            this.error("description must start with TABLE tag");
        }
        if (tableParser != null) {
            this.hgap = tableParser.hgap;
            this.vgap = tableParser.vgap;
            this.hpad = tableParser.hpad;
            this.vpad = tableParser.vpad;
        }
        this.parseTable();
        this.finishTable();
    }

    int lookup(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        this.error("Invalid value " + string);
        return -1;
    }

    int parsePair() {
        int n = this.lookup(values, this.in.currentString);
        this.scan(3);
        this.scan(4);
        if (n == 10) {
            return n;
        }
        if (n < 2) {
            String string = this.in.currentString.toUpperCase();
            int n2 = this.lookup(HtmlLayout.ALIGNNAMES, string);
            if (n == 0 && n2 > 4 || n == 1 && n2 < 2) {
                this.error(string + " illegal value for " + values[n]);
            }
            this.pairValue = n2;
            return n;
        }
        try {
            this.pairValue = Integer.parseInt(this.in.currentString);
        }
        catch (NumberFormatException numberFormatException) {
            this.error(values[n] + " value must be an integer");
        }
        return n;
    }

    void parseTable() {
        int n;
        while ((n = this.in.scanU()) == 4) {
            switch (this.parsePair()) {
                case 0: {
                    this.horz = this.pairValue;
                    break;
                }
                case 1: {
                    this.vert = this.pairValue;
                    break;
                }
                case 2: {
                    this.rows = this.pairValue;
                    break;
                }
                case 3: {
                    this.cols = this.pairValue;
                    break;
                }
                case 4: {
                    this.hgap = this.pairValue;
                    break;
                }
                case 5: {
                    this.vgap = this.pairValue;
                    break;
                }
                case 6: {
                    this.hpad = this.pairValue;
                    break;
                }
                case 7: {
                    this.vpad = this.pairValue;
                    break;
                }
                default: {
                    this.error("Invalid attribute for TABLE");
                }
            }
        }
        if (n != 1) {
            this.error("wrong token");
        }
        if (this.cols < 1 || this.rows < 1) {
            this.error("must specify positive rows and columns for TABLE");
        }
        this.cells = new Cell[this.rows][this.cols];
        this.taken = new boolean[this.rows][this.cols];
        while (this.in.scan() == 0 && this.in.scanU() == 4) {
            if (this.in.currentString.equals("TR")) {
                if (!this.parseTR()) continue;
                return;
            }
            if (this.in.currentString.equals("/TABLE")) {
                this.scan(1);
                return;
            }
            this.error("Unexpected tag " + this.in.currentString);
        }
        this.scan(-1);
    }

    boolean parseTR() {
        int n;
        int n2 = this.vgap;
        if (this.curRow >= this.rows) {
            this.error("Excess rows in table");
        }
        while ((n = this.in.scanU()) == 4) {
            switch (this.parsePair()) {
                case 5: {
                    n2 = this.pairValue;
                    break;
                }
                default: {
                    this.error("Invalid  attribute for TR");
                }
            }
        }
        if (n != 1) {
            this.error("wrong token");
        }
        while (this.in.scan() == 0 && this.in.scanU() == 4) {
            if (this.in.currentString.equals("TD")) {
                this.parseTD(n2);
                if (this.in.lastTok != 4) continue;
            }
            if (this.in.currentString.equals("TR")) {
                this.finishRow(n2);
                return this.parseTR();
            }
            if (this.in.currentString.equals("/TR")) {
                this.scan(1);
                this.finishRow(n2);
                return false;
            }
            if (this.in.currentString.equals("/TABLE")) {
                this.scan(1);
                this.finishRow(n2);
                return true;
            }
            this.error("Unexpected tag " + this.in.currentString);
        }
        this.scan(-1);
        this.finishRow(n2);
        return true;
    }

    private void finishRow(int n) {
        while (this.curCol < this.cols) {
            if (!this.taken[this.curRow][this.curCol]) {
                Cell cell = new Cell(this.hgap, n, 0, 0);
                this.addCell(cell);
                continue;
            }
            ++this.curCol;
        }
        this.curCol = 0;
        ++this.curRow;
    }

    private void finishTable() {
        while (this.curRow < this.rows) {
            this.finishRow(this.vgap);
        }
    }

    void parseTD(int n) {
        int n2;
        Cell cell = new Cell(this.hgap, n, this.hpad, this.vpad);
        while ((n2 = this.in.scanU()) == 4) {
            switch (this.parsePair()) {
                case 0: {
                    cell.hfill = this.pairValue;
                    break;
                }
                case 1: {
                    cell.vfill = this.pairValue;
                    break;
                }
                case 4: {
                    cell.hgap = this.pairValue;
                    break;
                }
                case 5: {
                    cell.vgap = this.pairValue;
                    break;
                }
                case 6: {
                    cell.hpad = this.pairValue;
                    break;
                }
                case 7: {
                    cell.vpad = this.pairValue;
                    break;
                }
                case 8: {
                    if (this.pairValue < 1) {
                        this.error("colspan must be >= 1");
                    }
                    cell.colspan = this.pairValue;
                    break;
                }
                case 9: {
                    if (this.pairValue < 1) {
                        this.error("rowspan must be >= 1");
                    }
                    cell.rowspan = this.pairValue;
                    break;
                }
                case 10: {
                    cell.name = this.in.currentString;
                    break;
                }
                default: {
                    this.error("Invalid attribute for TR");
                }
            }
        }
        if (n2 != 1) {
            this.error("wrong token");
        }
        this.addCell(cell);
        n2 = this.in.scan();
        if (n2 == 4) {
            if (cell.name != null) {
                this.error("TDs can only have a component or text");
            }
            cell.labelText = this.in.currentString;
            n2 = this.in.scan();
        }
        while (true) {
            if (n2 == -1) {
                return;
            }
            if (n2 != 0 || this.in.scanU() != 4) {
                this.error("Parse error");
            }
            if (this.in.currentString.equals("TD")) {
                this.parseTD(n);
                return;
            }
            if (this.in.currentString.equals("/TD")) {
                this.scan(1);
                return;
            }
            if (!this.in.currentString.equals("TABLE")) break;
            if (cell.name != null || cell.labelText != null) {
                this.error("TDs can't have a component or text with a TABLE");
            }
            cell.nested = new HtmlLayout(this);
            n2 = this.in.scan();
        }
    }

    private void addCell(Cell cell) {
        while (this.taken[this.curRow][this.curCol]) {
            ++this.curCol;
            if (this.curCol != this.cols) continue;
            this.error("excess elements");
        }
        cell.row = this.curRow;
        cell.col = this.curCol;
        if (cell.row + cell.rowspan > this.rows || cell.col + cell.colspan > this.cols) {
            this.error("element exceeds table bounds");
        }
        int n = cell.row;
        while (n < cell.row + cell.rowspan) {
            int n2 = cell.col;
            while (n2 < cell.col + cell.colspan) {
                if (this.taken[n][n2]) {
                    this.error("table elements overlap");
                }
                this.taken[n][n2] = true;
                ++n2;
            }
            ++n;
        }
        this.curCol += cell.colspan;
        this.cells[cell.row][cell.col] = cell;
        ++this.cellCount;
    }

    void error(String string) {
        String string2 = this.in.source.substring(Math.max(0, this.in.pos - 10), Math.min(this.in.pos + 1, this.in.source.length()));
        throw new BadTableHtmlException("Bad html at or before character " + this.in.pos + " : " + string + " : " + string2 + " <--");
    }

    void scan(int n) {
        if (this.in.scan() != n) {
            this.error("wrong token");
        }
    }
}

