/*
 * Decompiled with CFR 0.152.
 */
package htmllayout;

import htmllayout.Cell;
import htmllayout.Scanner;
import htmllayout.TableParser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class HtmlLayout
implements LayoutManager {
    static final String anonLabelName = new String("Anonymous label");
    boolean labelsAdded;
    static final int MIN = 0;
    static final int PREF = 1;
    static final int LEFT = 0;
    static final int RIGHT = 1;
    static final int CENTER = 2;
    static final int FIT = 3;
    static final int MAX = 4;
    static final int TOP = 5;
    static final int BOTTOM = 6;
    static final String[] ALIGNNAMES = new String[]{"LEFT", "RIGHT", "CENTER", "FIT", "MAX", "TOP", "BOTTOM"};
    Hashtable nameToCell;
    Hashtable compToCell;
    Cell[] cells;
    Cell[] cellsColFirst;
    int rows;
    int cols;
    int horzAlign = 4;
    int vertAlign = 4;
    Dimension prefDim = new Dimension(-1, -1);

    public HtmlLayout(String string) {
        this.nameToCell = new Hashtable(30);
        this.compToCell = new Hashtable(30);
        this.parse(new Scanner(string), true, null);
        this.addCellsToTable(this.nameToCell);
    }

    HtmlLayout(TableParser tableParser) {
        this.parse(tableParser.in, false, tableParser);
    }

    public void addLabels(Container container) {
        int n = 0;
        while (n < this.cells.length) {
            this.cells[n].addLabels(container);
            ++n;
        }
        this.labelsAdded = true;
    }

    public void addLayoutComponent(String string, Component component) {
        this.prefDim.width = -1;
        if (string == anonLabelName) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("null component name");
        }
        Cell cell = (Cell)this.nameToCell.get(string);
        if (cell == null) {
            throw new IllegalArgumentException("Cannot add to layout: unknown component name " + string);
        }
        this.compToCell.put(component, cell);
        cell.comp = component;
    }

    public void removeLayoutComponent(Component component) {
        this.prefDim.width = -1;
        Cell cell = (Cell)this.compToCell.remove(component);
        if (cell != null) {
            cell.comp = null;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.layoutSize(container, 1);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.layoutSize(container, 0);
    }

    void parse(Scanner scanner, boolean bl, TableParser tableParser) {
        TableParser tableParser2 = new TableParser(scanner, bl, tableParser);
        this.rows = tableParser2.rows;
        this.cols = tableParser2.cols;
        this.horzAlign = tableParser2.horz;
        this.vertAlign = tableParser2.vert;
        this.cells = new Cell[tableParser2.cellCount];
        int n = 0;
        this.cellsColFirst = new Cell[tableParser2.cellCount];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rows * this.cols) {
            if (tableParser2.cells[n3 / this.cols][n3 % this.cols] != null) {
                this.cells[n] = tableParser2.cells[n3 / this.cols][n3 % this.cols];
                ++n;
            }
            if (tableParser2.cells[n3 % this.rows][n3 / this.rows] != null) {
                this.cellsColFirst[n2] = tableParser2.cells[n3 % this.rows][n3 / this.rows];
                ++n2;
            }
            ++n3;
        }
    }

    Dimension layoutSize(Container container, int n) {
        if (!this.labelsAdded) {
            this.addLabels(container);
        }
        return this.layoutSize(container.getInsets(), n);
    }

    Dimension layoutSize(Insets insets, int n) {
        int[] nArray = new int[this.rows + 1];
        int[] nArray2 = new int[this.cols + 1];
        int n2 = 0;
        while (n2 < this.cells.length) {
            this.cells[n2].updateSize(n);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.cells.length) {
            this.cells[n3].addToYTable(nArray);
            this.cellsColFirst[n3].addToXTable(nArray2);
            ++n3;
        }
        Dimension dimension = new Dimension(nArray2[this.cols], nArray[this.rows]);
        this.prefDim.width = dimension.width;
        this.prefDim.height = dimension.height;
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void layoutContainer(Container container) {
        if (!this.labelsAdded) {
            this.addLabels(container);
        }
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = insets.top;
        int n2 = dimension.height - insets.bottom;
        int n3 = insets.left;
        int n4 = dimension.width - insets.right;
        this.preferredLayoutSize(container);
        if (n4 - n3 < this.prefDim.width || n2 - n < this.prefDim.height) {
            this.minimumLayoutSize(container);
        }
        this.layout(n, n2, n3, n4);
    }

    void layout(int n, int n2, int n3, int n4) {
        if (n4 - n3 > this.prefDim.width && this.horzAlign != 4 && this.horzAlign != 3) {
            n3 = HtmlLayout.calcTopOrLeft(n3, n4, this.prefDim.width, this.horzAlign);
            n4 = n3 + this.prefDim.width;
        }
        if (n2 - n > this.prefDim.height && this.vertAlign != 4 && this.vertAlign != 3) {
            n = HtmlLayout.calcTopOrLeft(n, n2, this.prefDim.height, this.vertAlign);
            n2 = n + this.prefDim.height;
        }
        this.doLayout(n, n2, n3, n4);
    }

    private void doLayout(int n, int n2, int n3, int n4) {
        int[] nArray = new int[this.rows + 1];
        int[] nArray2 = new int[this.cols + 1];
        this.layoutDim(nArray2, n3, n4, true);
        this.layoutDim(nArray, n, n2, false);
        int n5 = 0;
        while (n5 < this.cells.length) {
            this.cells[n5].finalLayout(nArray2, nArray);
            ++n5;
        }
    }

    private void layoutDim(int[] nArray, int n, int n2, boolean bl) {
        nArray[0] = n;
        boolean[] blArray = new boolean[nArray.length - 1];
        int n3 = 0;
        while (n3 < this.cells.length) {
            if (bl) {
                this.cellsColFirst[n3].firstXLayout(nArray, blArray);
            } else {
                this.cells[n3].firstYLayout(nArray, blArray);
            }
            ++n3;
        }
        int n4 = n2 - nArray[blArray.length];
        if (n4 < 0) {
            this.squeeze(-n4, nArray, bl);
        } else if (n4 > 0) {
            this.grow(n4, nArray, blArray);
        }
        nArray[nArray.length - 1] = n2;
    }

    /*
     * Unable to fully structure code
     */
    private void squeeze(int var1_1, int[] var2_2, boolean var3_3) {
        var4_4 = new int[var2_2.length][var3_3 != false ? this.rows : this.cols];
        var5_5 = new int[var2_2.length];
        var6_6 = var2_2[var2_2.length - 1] - var1_1;
        if (var6_6 >= 2) ** GOTO lbl33
        return;
lbl-1000:
        // 1 sources

        {
            var7_7 = new int[var2_2.length];
            var8_8 = 0;
            while (var8_8 < var5_5.length) {
                var5_5[var8_8] = 0x7FFFFFFF;
                ++var8_8;
            }
            var9_9 = 0;
            while (var9_9 < this.cells.length) {
                if (var3_3) {
                    this.cellsColFirst[var9_9].squeezeX(var2_2, var4_4, var7_7, var5_5);
                } else {
                    this.cells[var9_9].squeezeY(var2_2, var4_4, var7_7, var5_5);
                }
                ++var9_9;
            }
            var10_10 = new boolean[var2_2.length];
            var11_11 = this.maxSqueeze(var2_2.length - 1, var4_4, var7_7, var5_5, var2_2, var10_10);
            var12_12 = Math.min(var1_1, var11_11);
            var13_13 = var2_2[var2_2.length - 1] - var2_2[0];
            var14_14 = 0;
            var15_15 = 0;
            while (var15_15 < var2_2.length) {
                if (var10_10[var15_15]) {
                    var14_14 = var12_12 * (var2_2[var15_15] - var2_2[0]) / var13_13;
                }
                v0 = var15_15++;
                var2_2[v0] = var2_2[v0] - var14_14;
            }
            var1_1 -= var14_14;
lbl33:
            // 2 sources

            ** while (var2_2[var2_2.length - 1] > var6_6)
        }
lbl34:
        // 1 sources

    }

    private int maxSqueeze(int n, int[][] nArray, int[] nArray2, int[] nArray3, int[] nArray4, boolean[] blArray) {
        blArray[n] = true;
        int n2 = nArray3[n];
        int n3 = 0;
        while (n3 < nArray2[n]) {
            int n4 = this.maxSqueeze(nArray[n][n3], nArray, nArray2, nArray3, nArray4, blArray);
            if (n4 < n2) {
                n2 = n4;
            }
            ++n3;
        }
        return n2;
    }

    private void grow(int n, int[] nArray, boolean[] blArray) {
        boolean bl;
        int n2 = 0;
        int n3 = 0;
        while (n3 < blArray.length) {
            if (blArray[n3]) {
                ++n2;
            }
            ++n3;
        }
        boolean bl2 = bl = n2 == 0;
        if (bl) {
            n2 = blArray.length;
        }
        double d = ((double)n - 0.001) / (double)n2;
        double d2 = 0.0;
        int n4 = 0;
        while (n4 < blArray.length) {
            if (bl || blArray[n4]) {
                d2 += d;
            }
            int n5 = n4 + 1;
            nArray[n5] = nArray[n5] + (int)d2;
            ++n4;
        }
    }

    static int calcTopOrLeft(int n, int n2, int n3, int n4) {
        int n5;
        switch (n4) {
            case 0: 
            case 5: {
                n5 = n;
                break;
            }
            case 1: 
            case 6: {
                n5 = n2 - n3;
                break;
            }
            case 2: {
                n5 = n + (n2 - n - n3) / 2;
                break;
            }
            default: {
                throw new Error("illegal align value");
            }
        }
        return n5;
    }

    void addCellsToTable(Hashtable hashtable) {
        int n = 0;
        while (n < this.cells.length) {
            this.cells[n].addToNameTable(hashtable);
            ++n;
        }
    }

    private String descString() {
        return " dim = " + this.cols + ", " + this.rows + " fill = " + this.horzAlign + ", " + this.vertAlign;
    }

    void dump(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.err.print(' ');
            ++n2;
        }
        System.err.println("HtmlLayout" + this.descString());
        int n3 = 0;
        while (n3 < this.cells.length) {
            this.cells[n3].dump(n + 2);
            ++n3;
        }
    }

    public String toString() {
        String string = "[HtmlLayout" + this.descString() + " cells =";
        int n = 0;
        while (n < this.cells.length) {
            string = string + " " + this.cells[n];
            ++n;
        }
        return string + "]";
    }
}

