/*
 * Decompiled with CFR 0.152.
 */
package htmllayout;

import htmllayout.BadTableHtmlException;
import htmllayout.HtmlLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Label;
import java.util.Hashtable;

class Cell {
    int hfill = 0;
    int vfill = 2;
    String name;
    HtmlLayout nested;
    String labelText;
    Component comp;
    int row;
    int col;
    int rowspan = 1;
    int colspan = 1;
    int hgap;
    int vgap;
    int hpad;
    int vpad;
    private int reqwidth;
    private int reqheight;
    static final Insets zeroInsets = new Insets(0, 0, 0, 0);

    Cell(int n, int n2, int n3, int n4) {
        this.hgap = n;
        this.vgap = n2;
        this.hpad = n3;
        this.vpad = n4;
    }

    void addToNameTable(Hashtable hashtable) {
        if (this.name != null) {
            if (hashtable.put(this.name, this) != null) {
                throw new BadTableHtmlException("Duplicate component name: " + this.name);
            }
        } else if (this.nested != null) {
            this.nested.addCellsToTable(hashtable);
        }
    }

    void addLabels(Container container) {
        if (this.labelText != null && this.comp == null) {
            this.comp = new Label(this.labelText);
            container.add(this.comp, HtmlLayout.anonLabelName);
        } else if (this.nested != null) {
            this.nested.addLabels(container);
        }
    }

    void finalLayout(int[] nArray, int[] nArray2) {
        if (this.comp == null && this.nested == null) {
            return;
        }
        int n = this.row + this.rowspan;
        int n2 = this.col + this.colspan;
        int n3 = nArray[this.col];
        int n4 = nArray2[this.row];
        int n5 = nArray[n2];
        int n6 = nArray2[n];
        int n7 = n3;
        int n8 = n5;
        int n9 = n4;
        int n10 = n6;
        if (this.col != 0) {
            n7 += this.hgap;
        }
        if (this.row != 0) {
            n9 += this.vgap;
        }
        if (this.hfill != 4 && this.hfill != 3) {
            n7 = HtmlLayout.calcTopOrLeft(n7, n8, this.reqwidth, this.hfill);
            n8 = n7 + this.reqwidth;
        }
        if (this.vfill != 4 && this.vfill != 3) {
            n9 = HtmlLayout.calcTopOrLeft(n9, n10, this.reqheight, this.vfill);
            n10 = n9 + this.reqheight;
        }
        this.position(n3, n4, n5, n6, n7, n9, n8, n10);
    }

    private void position(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n5 < n) {
            n5 = n;
        }
        if (n6 < n2) {
            n6 = n2;
        }
        if (n7 > n3) {
            n7 = n3;
        }
        if (n8 > n4) {
            n8 = n4;
        }
        if (this.comp != null) {
            this.comp.setBounds(n5, n6, n7 - n5, n8 - n6);
        } else {
            this.nested.layout(n6, n8, n5, n7);
        }
    }

    void firstXLayout(int[] nArray, boolean[] blArray) {
        this.addToXTable(nArray);
        if (this.hfill == 4) {
            int n = this.col;
            while (n < this.col + this.colspan) {
                blArray[n] = true;
                ++n;
            }
        }
    }

    void firstYLayout(int[] nArray, boolean[] blArray) {
        this.addToYTable(nArray);
        if (this.vfill == 4) {
            int n = this.row;
            while (n < this.row + this.rowspan) {
                blArray[n] = true;
                ++n;
            }
        }
    }

    void updateSize(int n) {
        Dimension dimension = this.getSize(n);
        this.reqwidth = dimension.width;
        this.reqheight = dimension.height;
    }

    private void squeeze(int[] nArray, int[][] nArray2, int[] nArray3, int[] nArray4, int n, int n2, int n3) {
        int n4 = nArray[n2] - nArray[n];
        if (n4 > n3) {
            int n5 = n4 - n3;
            if (n5 < nArray4[n2]) {
                nArray4[n2] = n5;
            }
        } else {
            int n6 = n2;
            int n7 = nArray3[n6];
            nArray3[n6] = n7 + 1;
            nArray2[n2][n7] = n;
        }
    }

    void squeezeX(int[] nArray, int[][] nArray2, int[] nArray3, int[] nArray4) {
        this.squeeze(nArray, nArray2, nArray3, nArray4, this.col, this.col + this.colspan, this.reqwidth + (this.col == 0 ? 0 : this.hgap));
    }

    void squeezeY(int[] nArray, int[][] nArray2, int[] nArray3, int[] nArray4) {
        this.squeeze(nArray, nArray2, nArray3, nArray4, this.row, this.row + this.rowspan, this.reqheight + (this.row == 0 ? 0 : this.vgap));
    }

    void addToXTable(int[] nArray) {
        int n = this.col + this.colspan;
        int n2 = nArray[this.col] + this.reqwidth + (this.col == 0 ? 0 : this.hgap);
        if (nArray[n] < n2) {
            nArray[n] = n2;
        }
    }

    void addToYTable(int[] nArray) {
        int n = this.row + this.rowspan;
        int n2 = nArray[this.row] + this.reqheight + (this.row == 0 ? 0 : this.vgap);
        if (nArray[n] < n2) {
            nArray[n] = n2;
        }
    }

    Dimension getSize(int n) {
        Dimension dimension;
        if (this.nested != null) {
            return this.nested.layoutSize(zeroInsets, n);
        }
        if (this.comp == null || !this.comp.isVisible()) {
            return new Dimension(0, 0);
        }
        if (n == 0) {
            dimension = this.comp.getMinimumSize();
        } else if (n == 1) {
            dimension = this.comp.getPreferredSize();
        } else {
            throw new IllegalArgumentException("Bad whichSize " + n);
        }
        if (this.vpad != 0 || this.hpad != 0) {
            dimension = new Dimension(dimension.width + this.hpad, dimension.height + this.vpad);
        }
        return dimension;
    }

    private String descString() {
        return " pos = " + this.row + ", " + this.col + " span = " + this.rowspan + ", " + this.colspan + " fill = " + this.hfill + ", " + this.vfill + " gap = " + this.hgap + ", " + this.vgap + " pad = " + this.hpad + ", " + this.vpad + (this.name != null ? " name = " + this.name : (this.nested != null ? " nested = " : (this.labelText != null ? " label = " + this.labelText : " empty ")));
    }

    void dump(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.err.print(' ');
            ++n2;
        }
        System.err.println("Cell" + this.descString());
        if (this.nested != null) {
            this.nested.dump(n + 3);
        }
    }

    public String toString() {
        return "[Cell pos = " + this.descString() + (this.nested != null ? this.nested.toString() : "") + "]";
    }
}

