/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.gjt.sp.jedit.syntax.SyntaxDocument;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class SyntaxView
extends PlainView {
    private Segment line = new Segment();
    private Rectangle newRect = new Rectangle();

    public SyntaxView(Element element) {
        super(element);
    }

    public void drawLine(int n, Graphics graphics, int n2, int n3) {
        TokenMarker tokenMarker;
        SyntaxDocument syntaxDocument;
        Document document = this.getDocument();
        if (document instanceof SyntaxDocument) {
            syntaxDocument = (SyntaxDocument)document;
            tokenMarker = syntaxDocument.getTokenMarker();
        } else {
            syntaxDocument = null;
            tokenMarker = null;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Color color = this.getDefaultColor();
        try {
            Element element = this.getElement().getElement(n);
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset();
            document.getText(n4, n5 - (n4 + 1), this.line);
            if (tokenMarker == null) {
                graphics.setColor(color);
                Utilities.drawTabbedText(this.line, n2, n3, graphics, (TabExpander)this, 0);
            } else {
                this.paintSyntaxLine(this.line, n, n2, n3, graphics, syntaxDocument, tokenMarker, color);
                if (tokenMarker.isNextLineRequested()) {
                    this.forceRepaint(graphics, n2, n3);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    protected Color getDefaultColor() {
        return this.getContainer().getForeground();
    }

    private void paintSyntaxLine(Segment segment, int n, int n2, int n3, Graphics graphics, SyntaxDocument syntaxDocument, TokenMarker tokenMarker, Color color) {
        byte by;
        Color[] colorArray = syntaxDocument.getColors();
        Token token = tokenMarker.markTokens(segment, n);
        int n4 = 0;
        while ((by = token.id) != 127) {
            int n5 = token.length;
            Color color2 = by == 0 ? color : colorArray[by];
            graphics.setColor(color2 == null ? color : color2);
            segment.count = n5;
            n2 = Utilities.drawTabbedText(segment, n2, n3, graphics, (TabExpander)this, n4);
            segment.offset += n5;
            n4 += n5;
            token = token.next;
        }
    }

    private void forceRepaint(Graphics graphics, int n, int n2) {
        Container container = this.getContainer();
        Dimension dimension = container.getSize();
        container.repaint(n, n2, dimension.width - n, dimension.height - n2);
    }
}

