/*
 * Decompiled with CFR 0.152.
 */
package jas.util.pluginmanager;

import jas.util.JASDialog;
import jas.util.JASState;
import jas.util.pluginmanager.InstallPluginsUI;
import jas.util.pluginmanager.PluginManager;
import jas.util.pluginmanager.PluginProperties;
import jas.util.pluginmanager.UpdatePluginsUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class PluginManagerUI
extends JASDialog
implements ActionListener {
    private static JFrame frame;
    private Vector loadedplugins;
    private JTree tree;
    private JLabel path;
    private JLabel name;
    private JLabel author;
    private JLabel currversion;
    private JButton remove;
    private JButton update;
    private JButton install;
    private PluginManager pluginmanager;
    private JTextArea textarea;
    private DefaultMutableTreeNode loadedtree;
    private JOptionPane updatepane;
    private Container c;

    public PluginManagerUI(PluginManager pluginManager) {
        super((Frame)frame, "Plugin Manager", true, 13);
        this.pluginmanager = pluginManager;
    }

    public void showManagerGUI() {
        super.setHelpTopic("userInterface.pluginmanager");
        this.c = this.getContentPane();
        this.c.removeAll();
        this.c.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tree = new JTree();
        this.tree.setCellRenderer(new Renderer());
        this.tree.setRootVisible(false);
        this.tree.setVisibleRowCount(8);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeHandler());
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add("Center", jScrollPane);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(5, 1));
        jPanel3.add(new JLabel("Name: ", 4));
        jPanel3.add(new JLabel("Author: ", 4));
        jPanel3.add(new JLabel("Version: ", 4));
        jPanel3.add(new JLabel("Install path: ", 4));
        jPanel3.add(new JLabel("Description ", 4));
        jPanel2.add("West", jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.textarea = new JTextArea(6, 30);
        this.textarea.setEditable(false);
        this.textarea.setLineWrap(true);
        this.textarea.setWrapStyleWord(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.textarea);
        jPanel4.add("North", this.textarea);
        JPanel jPanel5 = new JPanel(new GridLayout(5, 1));
        this.name = new JLabel();
        jPanel5.add(this.name);
        this.author = new JLabel();
        jPanel5.add(this.author);
        this.currversion = new JLabel();
        jPanel5.add(this.currversion);
        this.path = new JLabel();
        jPanel5.add(this.path);
        jPanel2.add("Center", jPanel5);
        jPanel2.add("South", jPanel4);
        jPanel.add("South", jPanel2);
        this.c.add("Center", jPanel);
        JPanel jPanel6 = new JPanel();
        this.remove = new JButton("Remove selected plugins");
        this.remove.addActionListener(this);
        this.remove.setActionCommand("remove");
        jPanel6.add(this.remove);
        this.update = new JButton("Update installed plugins");
        this.update.addActionListener(this);
        this.update.setActionCommand("update");
        jPanel6.add(this.update);
        this.install = new JButton("Install a plugin");
        this.install.addActionListener(this);
        this.install.setActionCommand("install");
        jPanel6.add(this.install);
        this.c.add("South", jPanel6);
        this.updateTree();
        this.show();
    }

    protected void updateTree() {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode, true);
        this.loadedplugins = this.pluginmanager.getLoadedPluginList();
        this.loadedtree = new DefaultMutableTreeNode("Loaded Plugins", true);
        defaultTreeModel.insertNodeInto(this.loadedtree, defaultMutableTreeNode, 0);
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (this.loadedplugins != null) {
            n = 0;
            while (n < this.loadedplugins.size()) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.loadedplugins.elementAt(n), false);
                defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, this.loadedtree, 0);
                ++n;
            }
        }
        defaultMutableTreeNode.insert(this.loadedtree, 0);
        this.tree.setModel(defaultTreeModel);
        n = 0;
        while (n < this.tree.getRowCount()) {
            this.tree.expandRow(n);
            ++n;
        }
        this.remove.setEnabled(false);
        if (this.pluginmanager.getNotInstalledPluginList().size() > 0) {
            this.install.setEnabled(true);
        } else {
            this.install.setEnabled(false);
        }
        if (this.pluginmanager.getOutDatedPluginList().size() > 0) {
            this.update.setEnabled(true);
        } else {
            this.update.setEnabled(false);
        }
        this.path.setText(null);
        this.name.setText(null);
        this.author.setText(null);
        this.currversion.setText(null);
        this.pack();
    }

    private void removePlugins() throws IOException {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Object[] objectArray = new String[]{"OK"};
        boolean bl = false;
        if (treePathArray != null) {
            int n;
            int n2 = 0;
            while (n2 < treePathArray.length) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n2].getLastPathComponent();
                if (defaultMutableTreeNode.getParent() == this.loadedtree) {
                    PluginProperties pluginProperties = (PluginProperties)defaultMutableTreeNode.getUserObject();
                    if (pluginProperties.removeable) {
                        File file = new File(pluginProperties.path);
                        if (!file.canWrite()) {
                            n = JOptionPane.showOptionDialog(this.c, "You do not have write access to " + file.getAbsolutePath() + ".The plugin " + pluginProperties.name + " cannot be removed.", "Removing Plugins", -1, 0, null, objectArray, objectArray[0]);
                        } else {
                            n = !pluginProperties.installable ? JOptionPane.showConfirmDialog(this.c, "The plugin " + pluginProperties.name + " cannot be reinstalled by JAS. If you still wish to remove it click 'Ok'.", "Removing Plugin", 2, 2) : 0;
                            if (n == 0) {
                                int n3 = 0;
                                while (n3 < pluginProperties.files.length) {
                                    file = new File(pluginProperties.path, pluginProperties.files[n3]);
                                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                                    try {
                                        fileOutputStream.write(null);
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        // empty catch block
                                    }
                                    fileOutputStream.close();
                                    ++n3;
                                }
                                bl = true;
                                pluginProperties.setState(0);
                            }
                        }
                    } else {
                        n = JOptionPane.showOptionDialog(this.c, "The plugin " + pluginProperties.name + " is not removeable.", "Removing Plugins", -1, 1, null, objectArray, objectArray[0]);
                    }
                }
                ++n2;
            }
            if (bl) {
                n = JOptionPane.showOptionDialog(this.c, "For these changes to take effect you will need to restart JAS.", "Removing Plugins", -1, 1, null, objectArray, objectArray[0]);
            }
        }
        this.updateTree();
        this.show();
    }

    public void onOK() {
        this.dispose();
    }

    protected void enableHelp(JASState jASState) {
        jASState.setEnabled(true);
    }

    public void onCancel() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "install") {
            InstallPluginsUI installPluginsUI = new InstallPluginsUI(this.pluginmanager, this);
        } else if (actionEvent.getActionCommand() == "remove") {
            if (this.remove.isEnabled()) {
                try {
                    this.removePlugins();
                }
                catch (IOException iOException) {
                    System.out.println(iOException + "Exception occured while trying to remove plugins.");
                }
            }
        } else if (actionEvent.getActionCommand() == "update") {
            UpdatePluginsUI updatePluginsUI = new UpdatePluginsUI(this.pluginmanager, this);
        }
    }

    class Renderer
    extends JLabel
    implements TreeCellRenderer {
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private Border focusBorder = new LineBorder(UIManager.getColor("Tree.selectionBorderColor"), 1);

        Renderer() {
            this.setOpaque(true);
            this.setFont(UIManager.getFont("Tree.font"));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (bl) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBackground(jTree.getBackground());
                this.setForeground(jTree.getForeground());
            }
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            if (jTree.getPathForRow(n) != null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getPathForRow(n).getLastPathComponent();
            }
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof PluginProperties) {
                PluginProperties pluginProperties = (PluginProperties)defaultMutableTreeNode.getUserObject();
                this.setText(pluginProperties.name);
            } else {
                this.setText(object.toString());
            }
            this.setBorder(bl4 ? this.focusBorder : this.noFocusBorder);
            return this;
        }
    }

    class TreeHandler
    implements TreeSelectionListener {
        TreeHandler() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            TreePath[] treePathArray;
            TreePath treePath = treeSelectionEvent.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = treePath == null ? null : (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode.getUserObject() instanceof PluginProperties) {
                treePathArray = (TreePath[])defaultMutableTreeNode.getUserObject();
                string5 = treePathArray.path;
                string4 = treePathArray.name;
                string3 = treePathArray.author;
                string2 = treePathArray.currversion;
                string = treePathArray.description;
            } else {
                string2 = "";
                string3 = "";
                string4 = "";
                string5 = "";
                string = "Information describing the use of the available plugins will be displayed here.";
            }
            PluginManagerUI.this.path.setText(string5);
            PluginManagerUI.this.name.setText(string4);
            PluginManagerUI.this.author.setText(string3);
            PluginManagerUI.this.currversion.setText(string2);
            defaultMutableTreeNode = null;
            treePathArray = PluginManagerUI.this.tree.getSelectionPaths();
            if (treePathArray != null) {
                int n = 0;
                while (n < treePathArray.length) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
                    if (defaultMutableTreeNode.getUserObject() instanceof PluginProperties) {
                        PluginManagerUI.this.remove.setEnabled(true);
                        break;
                    }
                    if (defaultMutableTreeNode == PluginManagerUI.this.loadedtree) {
                        PluginManagerUI.this.remove.setEnabled(false);
                    }
                    ++n;
                }
            }
            PluginManagerUI.this.textarea.setText(string);
        }
    }
}

