/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;

public class UserProperties
extends Properties {
    private final String custFile = System.getProperty("user.home").concat(File.separator + "jas.properties");
    private static UserProperties theUserProperties;

    public UserProperties() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.custFile);
            this.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            if ((double)this.getFloat("property-version", 0.0f) < 0.9) {
                ((Hashtable)this).clear();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setFloat("property-version", 0.91f);
        theUserProperties = this;
    }

    protected UserProperties(Properties properties) {
        super(properties);
        theUserProperties = this;
    }

    public Rectangle getRectangle(String string, Rectangle rectangle) {
        try {
            Rectangle rectangle2 = new Rectangle();
            rectangle2.x = this.getInteger(string.concat("-x"));
            rectangle2.y = this.getInteger(string.concat("-y"));
            rectangle2.width = this.getInteger(string.concat("-w"));
            rectangle2.height = this.getInteger(string.concat("-h"));
            return rectangle2;
        }
        catch (Exception exception) {
            return rectangle;
        }
    }

    public void setRectangle(String string, Rectangle rectangle) {
        ((Hashtable)this).put(string.concat("-x"), String.valueOf(rectangle.x));
        ((Hashtable)this).put(string.concat("-y"), String.valueOf(rectangle.y));
        ((Hashtable)this).put(string.concat("-w"), String.valueOf(rectangle.width));
        ((Hashtable)this).put(string.concat("-h"), String.valueOf(rectangle.height));
    }

    public Color getColor(String string, Color color) {
        try {
            return new Color(this.getInteger(string.concat("-r")), this.getInteger(string.concat("-g")), this.getInteger(string.concat("-b")));
        }
        catch (Exception exception) {
            return color;
        }
    }

    public void setColor(String string, Color color) {
        ((Hashtable)this).put(string.concat("-r"), String.valueOf(color.getRed()));
        ((Hashtable)this).put(string.concat("-g"), String.valueOf(color.getGreen()));
        ((Hashtable)this).put(string.concat("-b"), String.valueOf(color.getBlue()));
    }

    public String[] getStringArray(String string, String[] stringArray) {
        try {
            String[] stringArray2 = new String[this.getInteger(string + "-length")];
            int n = 0;
            while (n < stringArray2.length) {
                stringArray2[n] = this.getProperty(string + "-" + n);
                ++n;
            }
            return stringArray2;
        }
        catch (Exception exception) {
            return stringArray;
        }
    }

    public void setStringArray(String string, String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        ((Hashtable)this).put(string + "-length", String.valueOf(stringArray.length));
        int n = 0;
        while (n < stringArray.length) {
            ((Hashtable)this).put(string + "-" + n, stringArray[n]);
            ++n;
        }
    }

    public String getString(String string, String string2) {
        try {
            String string3 = this.getProperty(string);
            return string3 == null ? string2 : string3;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public void setString(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        ((Hashtable)this).put(string, string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getProperty(string);
        return string2 == null ? bl : Boolean.valueOf(string2);
    }

    public void setBoolean(String string, boolean bl) {
        ((Hashtable)this).put(string, String.valueOf(bl));
    }

    public int getInteger(String string) throws NumberFormatException {
        return Integer.valueOf(this.getProperty(string));
    }

    public int getInteger(String string, int n) {
        try {
            return Integer.valueOf(this.getProperty(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    public void setFloat(String string, float f) {
        ((Hashtable)this).put(string, String.valueOf(f));
    }

    public float getFloat(String string, float f) {
        try {
            return Float.valueOf(this.getProperty(string)).floatValue();
        }
        catch (Exception exception) {
            return f;
        }
    }

    public void setInteger(String string, int n) {
        ((Hashtable)this).put(string, String.valueOf(n));
    }

    public void save() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.custFile);
        this.save(fileOutputStream, "Java Analysis Studio Custom Properties");
        ((OutputStream)fileOutputStream).close();
    }

    public static String[] updateStringArray(String[] stringArray, String string) {
        return UserProperties.updateStringArray(stringArray, string, 4);
    }

    public String[] updateStringArray(String[] stringArray, String string, String string2) {
        return UserProperties.updateStringArray(stringArray, string, this.getInteger(string2, 4));
    }

    public static String[] updateStringArray(String[] stringArray, String string, int n) {
        if (string == null) {
            return stringArray;
        }
        if (stringArray != null && stringArray.length > 0) {
            if (stringArray[0].equals(string)) {
                return stringArray;
            }
            int n2 = 1;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals(string)) {
                    while (n2 > 0) {
                        stringArray[n2] = stringArray[n2 - 1];
                        --n2;
                    }
                    stringArray[0] = string;
                    return stringArray;
                }
                ++n2;
            }
            if (stringArray.length < n) {
                String[] stringArray2 = new String[stringArray.length + 1];
                stringArray2[0] = string;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    stringArray2[n3 + 1] = stringArray[n3];
                    ++n3;
                }
                return stringArray2;
            }
            int n4 = n - 1;
            while (n4 > 0) {
                stringArray[n4] = stringArray[n4 - 1];
                --n4;
            }
            stringArray[0] = string;
            return stringArray;
        }
        stringArray = new String[]{string};
        return stringArray;
    }

    public static UserProperties getUserProperties() {
        return theUserProperties;
    }
}

