/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.plot.HasPopupItems;
import jas.plugin.PageContext;
import jas.plugin.PageEvent;
import jas.plugin.PageListener;
import jas.swingstudio.Closable;
import jas.swingstudio.FullScreenWindow;
import jas.swingstudio.HasCommandProcessor;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.PageListenerInfo;
import jas.swingstudio.WindowItem;
import jas.swingstudio.WindowManager;
import jas.util.xml.HasXMLRepresentation;
import jas.util.xml.XMLWriter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

final class JASWindowManager
extends JTabbedPane
implements WindowManager,
HasPopupItems {
    private Component fullScreen = null;
    private Vector m_listeners;
    private boolean m_changed = false;
    private Component prevSelected;
    private final JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();

    JASWindowManager() {
    }

    public void closeAllWindows() {
        int n = this.getTabCount() - 1;
        while (n >= 0) {
            if (!this.closeWindow(n)) {
                return;
            }
            --n;
        }
        int n2 = this.getTabCount();
        if (n2 == 0) {
            this.m_app.setNPages(0);
        }
    }

    public boolean closeWindow(int n) {
        Component component = this.getWindow(n);
        try {
            if (component instanceof Closable && !((Closable)((Object)component)).pleaseClose()) {
                return false;
            }
        }
        catch (Exception exception) {
            this.m_app.error("Error closing window", exception);
            return false;
        }
        this.firePageClosed(this.getWindow(n));
        this.firePageSelected(this.getWindow(this.getSelectedWindow()));
        this.detachWindow(n);
        if (this.getTabCount() == 0) {
            this.m_app.setNPages(0);
        }
        return true;
    }

    private Component detachWindow(int n) {
        Component component = this.getWindow(n);
        this.removeTabAt(n);
        this.getLayout().layoutContainer(this);
        component.setVisible(true);
        this.repaint();
        this.m_changed = true;
        return component;
    }

    public void doFullScreen() {
        Component component;
        int n = this.getSelectedWindow();
        final String string = this.getWindowName(n);
        this.fullScreen = component = this.detachWindow(n);
        final FullScreenWindow fullScreenWindow = new FullScreenWindow(this.m_app.getFrame(), (JComponent)component);
        fullScreenWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                fullScreenWindow.dispose();
            }

            public void windowClosed(WindowEvent windowEvent) {
                JASWindowManager.this.fullScreen = null;
                JASWindowManager.this.newWindow(string, component);
            }
        });
    }

    public Component getWindow(int n) {
        return this.getComponentAt(n);
    }

    public String getWindowName(int n) {
        return this.getTitleAt(n);
    }

    public void newWindow(String string, final Component component) {
        int n = this.getTabCount();
        this.addTab(string, component);
        this.setSelectedIndex(n);
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                JASWindowManager.this.firePageSelected(component);
            }
        });
        this.m_changed = true;
    }

    public Vector openPages(Class clazz) {
        Vector<Component> vector = new Vector<Component>();
        int n = this.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponentAt(n2);
            if (clazz == null || clazz.isInstance(component)) {
                vector.addElement(component);
            }
            ++n2;
        }
        return vector;
    }

    public void initialize(WindowItem[] windowItemArray, Vector vector) {
        this.m_listeners = vector;
        this.closeAllWindows();
        int n = 0;
        int n2 = 0;
        while (n2 < windowItemArray.length) {
            String string = windowItemArray[n2].name;
            this.newWindow(string, windowItemArray[n2].Component);
            if (string.startsWith("Page ")) {
                ++n;
            }
            ++n2;
        }
        this.m_app.setNPages(n);
        this.m_changed = false;
    }

    public WindowItem[] getItems() {
        WindowItem[] windowItemArray = new WindowItem[this.getTabCount()];
        int n = 0;
        while (n < windowItemArray.length) {
            windowItemArray[n] = new WindowItem(this.getTitleAt(n), this.getComponentAt(n));
            ++n;
        }
        return windowItemArray;
    }

    public void selectWindow(int n) {
        this.setSelectedIndex(n);
        this.m_changed = true;
    }

    public int getSelectedWindow() {
        return this.getSelectedIndex();
    }

    public int getWindowCount() {
        return this.getTabCount();
    }

    public void setCurrentTitle(String string) {
        this.setTitleAt(this.getSelectedIndex(), string);
        this.repaint();
        this.m_changed = true;
    }

    public void fireStateChanged() {
        int n;
        if (this.prevSelected instanceof HasCommandProcessor) {
            this.m_app.getCommandManager().remove(((HasCommandProcessor)((Object)this.prevSelected)).getCommandProcessor());
        }
        if ((n = this.getSelectedIndex()) >= 0) {
            this.prevSelected = this.getSelectedComponent();
            if (this.prevSelected instanceof HasCommandProcessor) {
                this.m_app.getCommandManager().add(((HasCommandProcessor)((Object)this.prevSelected)).getCommandProcessor());
            }
        }
        super.fireStateChanged();
    }

    public void saveState(XMLWriter xMLWriter) {
        int n = -1;
        int n2 = 0;
        int n3 = this.getTabCount();
        int n4 = 0;
        while (n4 < n3) {
            Component component = this.getWindow(n4);
            if (component instanceof HasXMLRepresentation) {
                ++n2;
                if (n4 == this.getSelectedIndex()) {
                    n = n4;
                }
            }
            ++n4;
        }
        xMLWriter.setAttribute("count", n2);
        if (n >= 0) {
            xMLWriter.setAttribute("selected", n);
        }
        xMLWriter.openTag("windows");
        int n5 = 0;
        while (n5 < n3) {
            Component component = this.getWindow(n5);
            if (component instanceof HasXMLRepresentation) {
                xMLWriter.setAttribute("name", this.getWindowName(n5));
                xMLWriter.openTag("window");
                ((HasXMLRepresentation)((Object)component)).writeAsXML(xMLWriter);
                xMLWriter.closeTag();
            }
            ++n5;
        }
        xMLWriter.closeTag();
        this.m_changed = false;
    }

    public boolean windowListChanged() {
        return this.m_changed;
    }

    public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        jPopupMenu.add(new JSeparator());
        jPopupMenu.add(new JMenuItem("Close window"){

            protected final void fireActionPerformed(ActionEvent actionEvent) {
                JASWindowManager.this.closeWindow(JASWindowManager.this.getSelectedIndex());
            }
        });
    }

    public int find(Component component) {
        int n = this.getWindowCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getWindow(n2) == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void addPageListener(Component component, PageListener pageListener, PageContext pageContext) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector(4, 2);
        }
        this.m_listeners.addElement(new PageListenerInfo(component, pageListener, pageContext));
    }

    public void removePageListener(PageListener pageListener) {
        if (this.m_listeners != null) {
            int n = this.m_listeners.size();
            int n2 = 0;
            while (n2 < n) {
                PageListenerInfo pageListenerInfo = (PageListenerInfo)this.m_listeners.elementAt(n2);
                if (pageListenerInfo.listener == pageListener) {
                    this.m_listeners.removeElementAt(n2);
                    --n;
                    continue;
                }
                ++n2;
            }
        }
    }

    private void removeListenersForComponent(Component component) {
        if (this.m_listeners != null) {
            int n = this.m_listeners.size();
            int n2 = 0;
            while (n2 < n) {
                PageListenerInfo pageListenerInfo = (PageListenerInfo)this.m_listeners.elementAt(n2);
                if (pageListenerInfo.Component == component) {
                    this.m_listeners.removeElementAt(n2);
                    --n;
                    continue;
                }
                ++n2;
            }
        }
    }

    private void firePageClosed(Component component) {
        this.notifyListenersForComponent(component, 4001);
        this.removeListenersForComponent(component);
    }

    private void firePageSelected(Component component) {
        if (component instanceof Closable) {
            ((Closable)((Object)component)).pageSelected(true);
        }
        this.notifyListenersForComponent(component, 3999);
    }

    private void firePageDeselected(Component component) {
        if (component instanceof Closable) {
            ((Closable)((Object)component)).pageSelected(false);
        }
        this.notifyListenersForComponent(component, 4000);
    }

    private void notifyListenersForComponent(Component component, int n) {
        if (this.m_listeners != null) {
            Enumeration enumeration = this.m_listeners.elements();
            while (enumeration.hasMoreElements()) {
                PageListenerInfo pageListenerInfo = (PageListenerInfo)enumeration.nextElement();
                if (pageListenerInfo.Component != component) continue;
                pageListenerInfo.listener.pageChanged(new PageEvent(pageListenerInfo.context, n));
            }
        }
    }

    public void setSelectedIndex(int n) {
        int n2 = this.getSelectedWindow();
        if (n2 >= 0) {
            this.firePageDeselected(this.getWindow(n2));
        }
        super.setSelectedIndex(n);
        if (n >= 0) {
            this.firePageSelected(this.getWindow(n));
        }
    }

    public Vector getPageListeners() {
        return this.m_listeners;
    }
}

