/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.swingstudio.JASCommandProcessor;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.JobToolBar;
import jas.swingstudio.RebinSlider;
import jas.util.Application;
import jas.util.JASCheckboxMenuItem;
import jas.util.JASCheckboxState;
import jas.util.UserProperties;
import jas.util.layout.ToolbarLayout;
import jas.util.xmlmenus.XMLMenuBuilder;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class JASToolbarHolder
extends JPanel {
    private boolean doNotTouchCheckBoxMenu = false;
    private JToolBar m_applicationToolBar;
    private JToolBar m_codeToolBar;
    private JToolBar m_jobToolBar;
    private JToolBar m_webToolBar;
    private JToolBar m_rebinSlider;
    private ToolbarCommand m_command = new ToolbarCommand();
    private static final int VIEW_MENU = 4;
    private static final int TOOLBAR_MENU = 0;
    private boolean largeIcons = false;
    private boolean showText = false;
    private JPopupMenu theToolBarPopupMenu;
    private UserProperties userProp = Application.getApplication().getUserProperties();
    private static final String applicationToolbarProp = "ApplicationToolbarVisible";
    private static final String jobToolbarProp = "JobToolbarVisible";
    private static final String codeToolbarProp = "CodeToolbarVisible";
    private static final String webToolbarProp = "WebToolbarVisible";
    private static final String rebinSliderProp = "RebinSliderVisible";

    public JASToolbarHolder(XMLMenuBuilder xMLMenuBuilder) {
        this.m_applicationToolBar = xMLMenuBuilder.getToolBar("applicationToolBar");
        this.m_jobToolBar = xMLMenuBuilder.getToolBar("jobToolBar");
        this.m_codeToolBar = xMLMenuBuilder.getToolBar("codeToolBar");
        this.m_webToolBar = xMLMenuBuilder.getToolBar("webToolBar");
        this.m_rebinSlider = xMLMenuBuilder.getToolBar("rebinSlider");
        this.addIfVisible(this.m_applicationToolBar);
        this.addIfVisible(this.m_jobToolBar);
        this.addIfVisible(this.m_codeToolBar);
        this.addIfVisible(this.m_webToolBar);
        this.addIfVisible(this.m_rebinSlider);
        this.theToolBarPopupMenu = JavaAnalysisStudio.getApp().getXMLMenuBuilder().getPopupMenu("toolbarPopupMenu");
        JavaAnalysisStudio.getApp().getCommandManager().add(this.m_command);
        this.setLayout(new ToolbarLayout(0, 5, 5));
        this.enableEvents(16L);
    }

    public Component add(Component component) {
        this.setToolbarCheckBoxMenuEnabled(component, true, false);
        return super.add(component);
    }

    public Component add(Component component, int n) {
        this.setToolbarCheckBoxMenuEnabled(component, true, false);
        return super.add(component, n);
    }

    public void add(Component component, Object object) {
        this.setToolbarCheckBoxMenuEnabled(component, true, false);
        super.add(component, object);
    }

    public void add(Component component, Object object, int n) {
        this.setToolbarCheckBoxMenuEnabled(component, true, false);
        super.add(component, object, n);
    }

    public Component add(String string, Component component) {
        this.setToolbarCheckBoxMenuEnabled(component, true, false);
        return super.add(string, component);
    }

    public void remove(Component component) {
        super.remove(component);
        this.setToolbarCheckBoxMenuEnabled(component, false, true);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.theToolBarPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void addIfVisible(JToolBar jToolBar) {
        if (jToolBar.getName().equals("applicationToolBar")) {
            if (this.getApplicationToolbarVisible()) {
                this.add(this.m_applicationToolBar);
            }
        } else if (jToolBar.getName().equals("jobToolBar")) {
            if (this.getJobToolbarVisible()) {
                this.add(this.m_jobToolBar);
            }
        } else if (jToolBar.getName().equals("codeToolBar")) {
            if (this.getCodeToolbarVisible()) {
                this.add(this.m_codeToolBar);
            }
        } else if (jToolBar.getName().equals("webToolBar")) {
            if (this.getWebToolbarVisible()) {
                this.add(this.m_webToolBar);
            }
        } else if (jToolBar.getName().equals("rebinSlider") && this.getRebinSliderVisible()) {
            this.add(this.m_rebinSlider);
        }
    }

    private void changeMenu(int n, boolean bl, boolean bl2) {
        if (bl2) {
            JMenu jMenu = (JMenu)JavaAnalysisStudio.getApp().getMenuBar().getMenu(4).getPopupMenu().getComponent(0);
            ((JASCheckboxMenuItem)jMenu.getItem(n)).setCorrespondingToolBarFloating(true);
        } else {
            JMenu jMenu = (JMenu)JavaAnalysisStudio.getApp().getMenuBar().getMenu(4).getPopupMenu().getComponent(0);
            ((JASCheckboxMenuItem)jMenu.getItem(n)).setCorrespondingToolBarFloating(false);
        }
        JavaAnalysisStudio.getApp().getMenuBar().getMenu(4).getPopupMenu().getComponent(n).setEnabled(bl);
        if (this.theToolBarPopupMenu != null) {
            this.theToolBarPopupMenu.getComponent(n).setEnabled(bl);
        }
    }

    private void setToolbarCheckBoxMenuEnabled(Component component, boolean bl, boolean bl2) {
        String string = component.getName();
        if (!this.doNotTouchCheckBoxMenu) {
            if (string.equals("applicationToolBar")) {
                this.changeMenu(0, bl, bl2);
            } else if (string.equals("jobToolBar")) {
                this.changeMenu(1, bl, bl2);
            } else if (string.equals("codeToolBar")) {
                this.changeMenu(2, bl, bl2);
            } else if (string.equals("webToolBar")) {
                this.changeMenu(3, bl, bl2);
            } else if (string.equals("rebinSlider")) {
                this.changeMenu(4, bl, bl2);
            } else {
                System.out.println("ERROR: unknown toolbar");
            }
        }
    }

    private void setAToolbarVisible(JToolBar jToolBar, String string, boolean bl) {
        if (bl) {
            this.add(jToolBar);
        } else {
            this.doNotTouchCheckBoxMenu = true;
            this.remove(jToolBar);
            this.doNotTouchCheckBoxMenu = false;
        }
        this.userProp.setBoolean(string, bl);
        this.revalidate();
        this.repaint();
    }

    private void setApplicationToolbarVisible(boolean bl) {
        this.setAToolbarVisible(this.m_applicationToolBar, applicationToolbarProp, bl);
    }

    private void setJobToolbarVisible(boolean bl) {
        this.setAToolbarVisible(this.m_jobToolBar, jobToolbarProp, bl);
    }

    private void setCodeToolbarVisible(boolean bl) {
        this.setAToolbarVisible(this.m_codeToolBar, codeToolbarProp, bl);
    }

    private void setWebToolbarVisible(boolean bl) {
        this.setAToolbarVisible(this.m_webToolBar, webToolbarProp, bl);
    }

    private void setRebinSliderVisible(boolean bl) {
        this.setAToolbarVisible(this.m_rebinSlider, rebinSliderProp, bl);
    }

    private boolean getApplicationToolbarVisible() {
        return this.userProp.getBoolean(applicationToolbarProp, true);
    }

    private boolean getJobToolbarVisible() {
        return this.userProp.getBoolean(jobToolbarProp, true);
    }

    private boolean getCodeToolbarVisible() {
        return this.userProp.getBoolean(codeToolbarProp, true);
    }

    private boolean getWebToolbarVisible() {
        return this.userProp.getBoolean(webToolbarProp, true);
    }

    private boolean getRebinSliderVisible() {
        return this.userProp.getBoolean(rebinSliderProp, true);
    }

    JComboBox getEventSourceComboBox() {
        return ((JobToolBar)this.m_jobToolBar).getEventSourceComboBox();
    }

    void setRebinModel(BoundedRangeModel boundedRangeModel, BoundedRangeModel boundedRangeModel2) {
        ((RebinSlider)this.m_rebinSlider).setModel(boundedRangeModel, boundedRangeModel2);
    }

    private class ToolbarCommand
    extends JASCommandProcessor {
        private ToolbarCommand() {
        }

        public void onApplicationToolbar(boolean bl) {
            JASToolbarHolder.this.setApplicationToolbarVisible(bl);
            this.setChanged();
        }

        public void onJobToolbar(boolean bl) {
            JASToolbarHolder.this.setJobToolbarVisible(bl);
            this.setChanged();
        }

        public void onCodeToolbar(boolean bl) {
            JASToolbarHolder.this.setCodeToolbarVisible(bl);
            this.setChanged();
        }

        public void onWebToolbar(boolean bl) {
            JASToolbarHolder.this.setWebToolbarVisible(bl);
            this.setChanged();
        }

        public void onRebinSlider(boolean bl) {
            JASToolbarHolder.this.setRebinSliderVisible(bl);
            this.setChanged();
        }

        public void enableApplicationToolbar(JASCheckboxState jASCheckboxState) {
            jASCheckboxState.setCheckbox(JASToolbarHolder.this.getApplicationToolbarVisible());
            jASCheckboxState.setEnabled(true);
        }

        public void enableJobToolbar(JASCheckboxState jASCheckboxState) {
            jASCheckboxState.setCheckbox(JASToolbarHolder.this.getJobToolbarVisible());
            jASCheckboxState.setEnabled(true);
        }

        public void enableCodeToolbar(JASCheckboxState jASCheckboxState) {
            jASCheckboxState.setCheckbox(JASToolbarHolder.this.getCodeToolbarVisible());
            jASCheckboxState.setEnabled(true);
        }

        public void enableWebToolbar(JASCheckboxState jASCheckboxState) {
            jASCheckboxState.setCheckbox(JASToolbarHolder.this.getWebToolbarVisible());
            jASCheckboxState.setEnabled(true);
        }

        public void enableRebinSlider(JASCheckboxState jASCheckboxState) {
            jASCheckboxState.setCheckbox(JASToolbarHolder.this.getRebinSliderVisible());
            jASCheckboxState.setEnabled(true);
        }

        public void onLargeIcons(boolean bl) {
            JASToolbarHolder.this.largeIcons = bl;
            this.setChanged();
        }

        public void onShowText(boolean bl) {
            JASToolbarHolder.this.showText = bl;
            this.setChanged();
        }

        public void enableLargeIcons(JASCheckboxState jASCheckboxState) {
            jASCheckboxState.setCheckbox(JASToolbarHolder.this.largeIcons);
            jASCheckboxState.setEnabled(true);
        }

        public void enableShowText(JASCheckboxState jASCheckboxState) {
            jASCheckboxState.setCheckbox(JASToolbarHolder.this.showText);
            jASCheckboxState.setEnabled(true);
        }
    }
}

