/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.hist.HasScatterPlotData;
import jas.hist.ScatterEnumeration;
import jas.jds.interfaces.Remote2DHistogramInfo;
import jas.jds.interfaces.RemoteScatterEnumeration;
import jas.jds.interfaces.RemoteScatterInfo;
import jas.jds.interfaces.RemoteScatterSource;
import jas.swingstudio.JAS2DRebinAdaptor;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.rmi.RMIDestination;
import jas.util.rmi.RMIEventDelivery;
import java.rmi.RemoteException;

final class JASScatterAdaptor
extends JAS2DRebinAdaptor
implements HasScatterPlotData {
    private final RemoteScatterSource m_remote;

    JASScatterAdaptor(RemoteScatterSource remoteScatterSource, RMIDestination rMIDestination, RMIEventDelivery rMIEventDelivery) {
        super(remoteScatterSource, rMIDestination, rMIEventDelivery);
        this.m_remote = remoteScatterSource;
    }

    public boolean hasScatterPlotData() {
        Remote2DHistogramInfo remote2DHistogramInfo = this.info;
        if (remote2DHistogramInfo == null) {
            remote2DHistogramInfo = this.setInfo();
        }
        return ((RemoteScatterInfo)remote2DHistogramInfo).m_hasScatterPlotData;
    }

    public synchronized ScatterEnumeration startEnumeration(double d, double d2, double d3, double d4) {
        try {
            RemoteScatterEnumeration remoteScatterEnumeration = this.m_remote.startEnumeration(d, d2, d3, d4);
            JASScatterEnumerationAdaptor jASScatterEnumerationAdaptor = new JASScatterEnumerationAdaptor(remoteScatterEnumeration, d, d2, d3, d4);
            return jASScatterEnumerationAdaptor;
        }
        catch (RemoteException remoteException) {
            JavaAnalysisStudio.getApp().error("Remote exception, could not get points.", remoteException);
            return null;
        }
    }

    public synchronized ScatterEnumeration startEnumeration() {
        double d = this.getXMin();
        double d2 = this.getXMax();
        double d3 = this.getYMin();
        double d4 = this.getYMax();
        return this.startEnumeration(d, d2, d3, d4);
    }

    private final class JASScatterEnumerationAdaptor
    implements ScatterEnumeration {
        private final RemoteScatterEnumeration m_remote;
        private short[] m_points;
        private int m_index;
        private final double xMin;
        private final double yMin;
        private final double xDiff;
        private final double yDiff;
        boolean m_isValid = true;
        private final short[] m_cache = new short[1000];
        private int m_nInCache = 0;

        JASScatterEnumerationAdaptor(RemoteScatterEnumeration remoteScatterEnumeration, double d, double d2, double d3, double d4) {
            this.m_remote = remoteScatterEnumeration;
            this.xMin = d;
            this.yMin = d3;
            this.xDiff = d2 - d;
            this.yDiff = d4 - d3;
        }

        public boolean getNextPoint(double[] dArray) {
            if (!this.m_isValid) {
                return false;
            }
            if (this.m_points == null || this.m_points == this.m_cache && this.m_index >= this.m_nInCache || this.m_index >= this.m_points.length) {
                this.m_index = 0;
                try {
                    JASScatterAdaptor jASScatterAdaptor = JASScatterAdaptor.this;
                    synchronized (jASScatterAdaptor) {
                        if (!this.m_isValid) {
                            boolean bl = false;
                            return bl;
                        }
                        this.m_points = this.m_remote.getNextPoints();
                        if (this.m_points == null) {
                            boolean bl = false;
                            return bl;
                        }
                        int n = Math.min(this.m_cache.length - this.m_nInCache, this.m_points.length);
                        if (n > 0) {
                            System.arraycopy(this.m_points, 0, this.m_cache, this.m_nInCache, n);
                            this.m_nInCache += n;
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    JavaAnalysisStudio.getApp().error("Remote exception, points may be lost.", remoteException);
                    return false;
                }
            }
            dArray[0] = this.xMin + this.xDiff * (double)this.m_points[this.m_index++] / 32767.0;
            dArray[1] = this.yMin + this.yDiff * (double)this.m_points[this.m_index++] / 32767.0;
            return true;
        }

        public void resetEndPoint() {
            try {
                this.m_remote.resetEndPoint();
            }
            catch (RemoteException remoteException) {
                JavaAnalysisStudio.getApp().error("Remote exception, points may be lost.", remoteException);
            }
        }

        public void restart() {
            try {
                try {
                    this.m_remote.restart(this.m_nInCache);
                }
                catch (RemoteException remoteException) {
                    JavaAnalysisStudio.getApp().error("Remote exception, points may be lost.", remoteException);
                    Object var3_2 = null;
                    this.m_points = this.m_cache;
                    this.m_index = 0;
                }
                Object var3_1 = null;
                this.m_points = this.m_cache;
                this.m_index = 0;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.m_points = this.m_cache;
                this.m_index = 0;
                throw throwable;
            }
        }
    }
}

