/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import hep.analysis.EventSource;
import jas.jds.module.LocalDIM;
import jas.jds.module.LocalJobBuilder;
import jas.jds.module.ModuleException;
import jas.swingstudio.JASJob;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.LocalJob;
import javax.swing.BoundedRangeModel;

class JASLocalJobBuilder
implements LocalJobBuilder {
    private LocalJob m_job;
    private LocalDIM m_dim;
    private final JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private String m_jobName;

    JASLocalJobBuilder() {
    }

    JASLocalJobBuilder(LocalJob localJob) {
        this.m_job = localJob;
    }

    void setJobName(String string) {
        this.m_jobName = string;
    }

    void setDIM(LocalDIM localDIM) {
        this.m_dim = localDIM;
    }

    public void createJob(String string) {
        if (this.m_job == null) {
            this.m_app.closeCurrentJob();
            JASJob jASJob = new JASJob(this.m_jobName);
            this.m_job = new LocalJob(jASJob, this.m_jobName, this.m_dim, string);
            try {
                this.m_job.open();
                jASJob.setJob(this.m_job);
                this.m_app.setJob(jASJob, true);
            }
            catch (ModuleException moduleException) {
                this.m_app.closeCurrentJob();
                this.m_app.setToEmptyJob();
                this.m_app.error("Could not open job.", moduleException);
            }
        } else {
            try {
                EventSource eventSource = this.m_dim.openDataSet(string);
                if (eventSource != null) {
                    this.m_job.setEventSource(eventSource);
                }
            }
            catch (ModuleException moduleException) {
                this.m_app.error("Could not open dataset.", moduleException);
            }
        }
    }

    public void setEventSource(EventSource eventSource) {
        this.m_job.setEventSource(eventSource);
    }

    public void setMessage(String string) {
        this.m_app.setMessage(string);
    }

    public void setProgressModel(BoundedRangeModel boundedRangeModel) {
        this.m_app.setModel(boundedRangeModel);
    }

    public void clearProgressModel() {
        this.m_app.setModel(null);
    }
}

