/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import hep.analysis.EventData;
import jas.jds.interfaces.ConnectionRejected;
import jas.jds.interfaces.JavaDataServer;
import jas.jds.interfaces.PluginEvent;
import jas.jds.interfaces.RemoteCut;
import jas.jds.interfaces.RemoteEventSourceFolder;
import jas.jds.interfaces.RemoteEventUpdate;
import jas.jds.interfaces.RemoteHistogramAccess;
import jas.jds.interfaces.RemoteJob;
import jas.jds.interfaces.RemoteJobInfo;
import jas.jds.interfaces.RemoteJobUpdate;
import jas.jds.interfaces.RemotePageAccess;
import jas.jds.interfaces.RemotePlotAccess;
import jas.jds.interfaces.RemotePrintBuffer;
import jas.jds.interfaces.SecureJavaDataServer;
import jas.jds.interfaces.Version;
import jas.jds.module.ModuleException;
import jas.jds.security.PasswordHandler;
import jas.jds.security.PasswordRequiredException;
import jas.job.AnalysisException;
import jas.job.LoaderException;
import jas.job.NoSuchItemError;
import jas.job.OpenJobException;
import jas.plugin.RunEvent;
import jas.plugin.RunListener;
import jas.swingstudio.ConnectFailed;
import jas.swingstudio.JASClassLoader;
import jas.swingstudio.JASCutAdaptor;
import jas.swingstudio.JASEventSourceFolderAdaptor;
import jas.swingstudio.JASHistogramAccessAdaptor;
import jas.swingstudio.JASJob;
import jas.swingstudio.JASPageAccessAdaptor;
import jas.swingstudio.JASPlotAccessAdaptor;
import jas.swingstudio.JASRebinAdaptor;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.Job;
import jas.util.JASWizardPage;
import jas.util.NestedRuntimeException;
import jas.util.rmi.RMIDestination;
import jas.util.rmi.RMIEventDelivery;
import jas.util.rmi.RMIEventDeliveryEvent;
import jas.util.rmi.RMIEventDeliveryListener;
import jas.util.tree.TreeItem;
import java.awt.Component;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;

final class JASJobAdaptor
implements Observer,
Serializable,
Job,
RMIEventDeliveryListener {
    static final long serialVersionUID = 2237223357910298193L;
    private transient int m_port = 0;
    private transient String m_service = null;
    private transient boolean m_treeChanged;
    private transient RMIEventDelivery m_ed;
    private transient int m_maxEvents = 0;
    private transient RemoteJob m_remote;
    private transient RemoteJobInfo m_info;
    private transient BoundedRangeModel m_progress;
    private transient int m_changes = 0;
    private transient URL m_loaderURL;
    private transient Component m_parent;
    private String m_jobName;
    private transient JASJob m_jasJob;
    private transient Vector m_runListeners = new Vector();
    private String m_serverName;
    private Vector m_openDataSets = new Vector();
    private Vector m_loaded = new Vector();
    private transient JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private static boolean RMIInit = false;
    private static final boolean debugLoader = System.getProperty("debugLoader") != null;
    static /* synthetic */ Class class$hep$analysis$EventData;

    JASJobAdaptor(JASJob jASJob, String string, String string2, String string3, int n, Component component) {
        this.m_parent = component;
        this.m_port = n;
        this.m_service = string3;
        this.m_jasJob = jASJob;
        this.m_jobName = string;
        this.m_serverName = string2;
        this.m_progress = new DefaultBoundedRangeModel();
        this.m_app.setModel(this.m_progress);
    }

    JASJobAdaptor(JASJob jASJob, String string, JavaDataServer javaDataServer, Component component) throws ModuleException, RemoteException {
        this.m_parent = component;
        this.m_jasJob = jASJob;
        this.m_jobName = string;
        this.m_progress = new DefaultBoundedRangeModel();
        this.m_app.setModel(this.m_progress);
        this.m_ed = new RMIEventDelivery(true);
        this.m_ed.addRMIEventDeliveryListener(this);
        RMIDestination rMIDestination = this.m_ed.getRMIDestination();
        rMIDestination.addObserver(this);
        this.m_remote = javaDataServer.connectToJob(string, this.m_ed, rMIDestination, new JASClassLoader());
    }

    private URL remoteCodebase() throws MalformedURLException, RemoteException {
        String string;
        if (this.m_loaderURL == null && (string = this.m_remote.getRemoteCodeBase()) != null) {
            this.m_loaderURL = new URL(string);
        }
        return this.m_loaderURL;
    }

    public Class loadClientClass(String string) throws ClassNotFoundException {
        try {
            return this.m_app.getExtensionLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.loadRemoteClass(string);
        }
    }

    public boolean open() throws ModuleException {
        try {
            JavaDataServer javaDataServer = JASJobAdaptor.connectToServer(this.m_serverName, this.m_service, this.m_port, this.m_parent);
            if (javaDataServer == null) {
                return false;
            }
            this.m_ed = new RMIEventDelivery(true);
            this.m_ed.addRMIEventDeliveryListener(this);
            RMIDestination rMIDestination = this.m_ed.getRMIDestination();
            rMIDestination.addObserver(this);
            this.m_remote = javaDataServer.newJob(this.m_jobName, this.m_ed, rMIDestination, new JASClassLoader());
            return true;
        }
        catch (Exception exception) {
            throw new ModuleException("Error opening remote job", exception);
        }
    }

    public void reopen(ObjectInputStream objectInputStream, JASJob jASJob) throws OpenJobException {
        this.m_jasJob = jASJob;
        this.m_progress = new DefaultBoundedRangeModel();
        this.m_app = JavaAnalysisStudio.getApp();
        this.m_app.setModel(this.m_progress);
        try {
            boolean bl;
            int n;
            this.open();
            Enumeration enumeration = this.m_openDataSets.elements();
            while (enumeration.hasMoreElements()) {
                this.m_remote.openDataSource((TreeItem)enumeration.nextElement());
            }
            enumeration = this.m_loaded.elements();
            while (enumeration.hasMoreElements()) {
                this.m_remote.loadRemoteObject((String)enumeration.nextElement());
            }
            try {
                n = objectInputStream.readInt();
                bl = objectInputStream.readBoolean();
            }
            catch (EOFException eOFException) {
                n = 0;
                bl = false;
            }
            if (bl) {
                this.m_remote.go();
            } else if (n > 0) {
                this.m_remote.go(n);
            }
        }
        catch (Exception exception) {
            throw new OpenJobException(exception);
        }
    }

    public void close() {
        try {
            this.m_remote.setPersistent(false);
            this.m_remote.close();
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
        this.m_remote = null;
    }

    void disconnect() {
        try {
            this.m_remote.setPersistent(true);
            this.m_remote.close();
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
        this.m_remote = null;
    }

    public void receiveMessage(Object object) {
        try {
            this.m_remote.receiveMessage(null, null, object);
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.m_changes = 0;
    }

    public void closeDataset(TreeItem treeItem) {
        try {
            this.m_remote.closeDataset(treeItem);
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
    }

    public void setEventSource(TreeItem treeItem) {
        try {
            this.m_remote.setEventSource(treeItem);
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
    }

    public Class getEventDataClass(TreeItem treeItem) {
        try {
            String string = this.m_remote.getEventDataClass(treeItem);
            return this.loadClientClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
        return class$hep$analysis$EventData == null ? (class$hep$analysis$EventData = JASJobAdaptor.class$("hep.analysis.EventData")) : class$hep$analysis$EventData;
    }

    Class loadRemoteClass(String string) throws ClassNotFoundException {
        try {
            URL uRL = this.remoteCodebase();
            if (uRL != null) {
                Class<?> clazz = RMIClassLoader.loadClass(uRL, string);
                if (debugLoader) {
                    System.out.println("RemoteLoader: loaded " + string + " using codebase " + uRL);
                }
                return clazz;
            }
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
        catch (MalformedURLException malformedURLException) {
            this.m_app.error("Remote exception", malformedURLException);
        }
        throw new ClassNotFoundException(string);
    }

    public EventData getEvent() {
        try {
            return this.m_remote.getEvent();
        }
        catch (RemoteException remoteException) {
            throw new NestedRuntimeException("Error getting event", remoteException);
        }
    }

    public void stop() {
        try {
            this.m_remote.stop();
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Could not stop job", remoteException);
        }
    }

    public void reload() {
        try {
            this.m_remote.unloadAll();
            Enumeration enumeration = this.m_loaded.elements();
            while (enumeration.hasMoreElements()) {
                this.m_remote.loadRemoteObject((String)enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            this.m_app.error("Could not reload job", exception);
        }
    }

    public boolean isChanged() {
        return this.m_changes > 0;
    }

    public TreeItem[] listItems() {
        try {
            return this.m_remote.listItems();
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Could not list remote items", remoteException);
            return null;
        }
    }

    public Object getItem(TreeItem treeItem) {
        try {
            RMIDestination rMIDestination = this.m_ed.getRMIDestination();
            RemoteObject remoteObject = this.m_remote.getItem(treeItem, rMIDestination);
            if (remoteObject == null) {
                return null;
            }
            if (remoteObject instanceof RemoteEventSourceFolder) {
                return new JASEventSourceFolderAdaptor((RemoteEventSourceFolder)((Object)remoteObject));
            }
            if (remoteObject instanceof RemoteCut) {
                return new JASCutAdaptor((RemoteCut)((Object)remoteObject), this.m_ed);
            }
            if (remoteObject instanceof RemotePageAccess) {
                return new JASPageAccessAdaptor((RemotePageAccess)((Object)remoteObject), this.m_ed);
            }
            if (remoteObject instanceof RemotePlotAccess) {
                return new JASPlotAccessAdaptor((RemotePlotAccess)((Object)remoteObject), this.m_ed);
            }
            if (remoteObject instanceof RemoteHistogramAccess) {
                return new JASHistogramAccessAdaptor((RemoteHistogramAccess)((Object)remoteObject), this.m_ed);
            }
            return JASRebinAdaptor.getAdaptor(remoteObject, this.m_ed, rMIDestination);
        }
        catch (RemoteException remoteException) {
            if (remoteException.detail instanceof NoSuchItemError) {
                throw (NoSuchItemError)remoteException.detail;
            }
            System.err.println("Error from remote getItem " + remoteException);
            Thread.dumpStack();
            return null;
        }
    }

    public boolean isRunnable() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_runnable;
    }

    public boolean isRunning() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_running;
    }

    public boolean isAtEndOfData() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_atEndOfData;
    }

    public boolean isAtStartOfData() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_atStartOfData;
    }

    public boolean isPersistent() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_persistent;
    }

    public int eventsAnalyzed() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_eventsAnalyzed;
    }

    public int eventsTotal() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_eventsTotal;
    }

    public String getName() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_name;
    }

    public void kill() {
        try {
            this.m_remote.kill();
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
    }

    public void go(int n) {
        try {
            this.m_remote.go(n);
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
    }

    public void rewind() {
        try {
            this.m_remote.restart();
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
    }

    public void unloadAll() {
        try {
            this.m_remote.unloadAll();
            this.m_loaded.removeAllElements();
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
    }

    public TreeItem[] listDataSources() {
        try {
            return this.m_remote.listDataSources();
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
            return null;
        }
    }

    public TreeItem[] getSubItems(TreeItem treeItem) {
        try {
            return this.m_remote.getSubItems(treeItem);
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
            return null;
        }
    }

    public void openDataSource(TreeItem treeItem) throws OpenJobException {
        try {
            this.m_remote.openDataSource(treeItem);
            this.m_openDataSets.addElement(treeItem);
        }
        catch (RemoteException remoteException) {
            throw new OpenJobException(remoteException);
        }
    }

    public void loadObject(String string) {
        try {
            this.m_remote.loadRemoteObject(string);
            this.m_loaded.addElement(string);
        }
        catch (LoaderException loaderException) {
            this.m_app.error("Could not load", loaderException);
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote Exception", remoteException);
        }
    }

    public boolean isLoaded(String string) {
        return this.m_loaded.contains(string);
    }

    public void setPersistent(boolean bl) {
        try {
            this.m_remote.setPersistent(bl);
        }
        catch (RemoteException remoteException) {
            this.m_app.error("Remote exception", remoteException);
        }
    }

    public void eventDelivery(RMIEventDeliveryEvent rMIEventDeliveryEvent) {
        if (rMIEventDeliveryEvent.start()) {
            this.m_treeChanged = false;
        } else if (this.m_treeChanged) {
            this.m_jasJob.updateTree();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof TreeItem) {
            this.m_treeChanged = true;
            TreeItem treeItem = (TreeItem)object;
            if ((treeItem.flags & 2) != 0) {
                this.m_jasJob.deleteNode(treeItem);
            } else {
                this.m_jasJob.addNode(treeItem);
            }
        } else if (object instanceof AnalysisException) {
            this.m_app.error("Error running remote analysis (see Error Message window for details)");
        } else if (object instanceof String) {
            this.m_app.setMessage((String)object);
        } else if (object instanceof RemotePrintBuffer) {
            try {
                RemotePrintBuffer remotePrintBuffer = (RemotePrintBuffer)object;
                this.m_app.getOutputStream(remotePrintBuffer.getTitle()).write(remotePrintBuffer.getBuffer());
            }
            catch (IOException iOException) {}
        } else if (object instanceof RemoteJobUpdate) {
            this.update((RemoteJobUpdate)object);
        } else if (object instanceof RemoteEventUpdate) {
            this.update(((RemoteEventUpdate)object).getEvents());
        } else if (object instanceof PluginEvent) {
            try {
                String string = ((PluginEvent)object).getName();
                this.m_jasJob.loadPlugin(string);
            }
            catch (Exception exception) {
                this.m_app.error("Error loading plugin", exception);
            }
        }
    }

    JASWizardPage getCustomWizardPage() {
        return null;
    }

    public void addRunListener(RunListener runListener) {
        this.m_runListeners.addElement(runListener);
    }

    public void removeRunListener(RunListener runListener) {
        this.m_runListeners.removeElement(runListener);
    }

    private void fireRunListeners(RunEvent runEvent) {
        Enumeration enumeration = this.m_runListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((RunListener)enumeration.nextElement()).runStateChanged(runEvent);
        }
    }

    private void update(RemoteJobUpdate remoteJobUpdate) {
        this.m_info = remoteJobUpdate.getInfo();
        this.m_jasJob.setCommandChanged();
        this.m_maxEvents = this.m_info.m_eventsTotal > 0 ? this.m_info.m_eventsTotal : 100;
        this.m_progress.setMaximum(this.m_maxEvents);
        this.m_progress.setValue(this.m_info.m_eventsAnalyzed);
        if (!this.m_runListeners.isEmpty()) {
            this.fireRunListeners(new RunEvent(this, this.m_info.m_running ? 3000 : 2999));
        }
    }

    private void update(int n) {
        if (this.m_info != null) {
            this.m_info.m_eventsAnalyzed = n;
        }
        if (this.m_info.m_eventsAnalyzed > this.m_maxEvents) {
            this.m_maxEvents *= 3;
            this.m_progress.setMaximum(this.m_maxEvents);
        }
        this.m_progress.setValue(this.m_info.m_eventsAnalyzed);
    }

    private void setInfo() {
        try {
            this.m_info = this.m_remote.getJobInfo();
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
        }
    }

    static JavaDataServer connectToServer(String string, String string2, int n, Component component) throws ConnectFailed {
        if (string2 == null) {
            string2 = Version.getService();
        }
        String string3 = "//" + string + (n == 0 ? "" : ":" + n) + "/" + string2;
        JavaDataServer javaDataServer = null;
        try {
            PasswordHandler passwordHandler = null;
            try {
                javaDataServer = (JavaDataServer)Naming.lookup(string3);
                boolean bl = javaDataServer.openConnection(System.getProperty("user.name"), Version.getVersion());
                return javaDataServer;
            }
            catch (PasswordRequiredException passwordRequiredException) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("clientUser", System.getProperty("user.name"));
                passwordHandler = passwordRequiredException.getPasswordHandler();
                while (true) {
                    try {
                        Object object = passwordHandler.getPasswordInfo(component, hashtable);
                        if (object == null) {
                            return null;
                        }
                        boolean bl = ((SecureJavaDataServer)javaDataServer).openSecureConnection((String)hashtable.get("clientUser"), Version.getVersion(), object);
                        return javaDataServer;
                    }
                    catch (PasswordRequiredException passwordRequiredException2) {
                        passwordHandler = passwordRequiredException2.getPasswordHandler();
                        continue;
                    }
                    break;
                }
            }
        }
        catch (ConnectionRejected connectionRejected) {
            double d = connectionRejected.getGot();
            double d2 = connectionRejected.getExpected();
            if (d == d2) {
                throw new ConnectFailed("Connection Rejected ", connectionRejected);
            }
            throw new ConnectFailed("Server incompatible (got " + d + " expected " + d2 + ")", connectionRejected);
        }
        catch (ConnectException connectException) {
            throw new ConnectFailed("Java Data Server not running on host " + string, connectException);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ConnectFailed("Unknown host " + string, unknownHostException);
        }
        catch (NotBoundException notBoundException) {
            throw new ConnectFailed("Java Data Server not running on host " + string, notBoundException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConnectFailed("Bad host, port or service name " + string, malformedURLException);
        }
        catch (RemoteException remoteException) {
            throw new ConnectFailed("Unexpected exception during connect to " + string, remoteException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

