/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import hep.analysis.EventData;
import jas.job.LoaderException;
import jas.job.OpenJobException;
import jas.plugin.IPlugin;
import jas.plugin.NoEventAvailable;
import jas.plugin.PluginContext;
import jas.plugin.RunListener;
import jas.swingstudio.JASCommandProcessor;
import jas.swingstudio.JASException;
import jas.swingstudio.JASJobAdaptor;
import jas.swingstudio.JASLocalJobBuilder;
import jas.swingstudio.JASPluginContext;
import jas.swingstudio.JavaAnalysisStudio;
import jas.swingstudio.Job;
import jas.swingstudio.LoadDialog;
import jas.swingstudio.LoadPluginDialog;
import jas.swingstudio.LocalJob;
import jas.swingstudio.LocalJobPage;
import jas.swingstudio.NotImplemented;
import jas.swingstudio.OpenDataSetPage;
import jas.swingstudio.StoppableExecution;
import jas.swingstudio.StoppableExecutionMonitor;
import jas.swingstudio.TreeAdaptor;
import jas.swingstudio.TreeAdaptorSite;
import jas.util.ImageException;
import jas.util.JASCheckboxState;
import jas.util.JASIcon;
import jas.util.JASState;
import jas.util.JASWizard;
import jas.util.tree.OrderedNode;
import jas.util.tree.SimpleNode;
import jas.util.tree.SimpleTreeModel;
import jas.util.tree.TreeItem;
import jas.util.tree.TreeObjectSource;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

final class JASJob
implements Serializable,
TreeSelectionListener,
StoppableExecution,
TreeObjectSource,
ActionListener {
    static final long serialVersionUID = 8830773281026894908L;
    private String m_name;
    private Job m_job;
    private transient TreeModel m_treeModel = null;
    private transient DefaultTreeCellRenderer m_treeRenderer;
    private transient ListCellRenderer m_listRenderer;
    private transient String m_filePath = null;
    private transient int m_changes = 0;
    private transient boolean m_connected = false;
    private transient TreeNode m_root;
    private transient JASJobCommandProcessor m_command;
    private transient StoppableExecutionMonitor m_stopMonitor;
    private transient JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private transient ComboModel m_eventSourceModel = new ComboModel();
    private transient Vector m_plugins = new Vector();
    private transient Vector m_pluginMenus = new Vector();
    private transient PluginContext m_pluginContext = new JobPluginContext(this.m_app);
    private transient JTree m_tree;
    private transient JComboBox m_combo;

    JASJob(String string) {
        this.m_name = string;
        this.m_root = new TreeNode(string, "Job");
        this.m_command = new JASJobCommandProcessor();
        this.m_treeModel = new SimpleTreeModel(this.m_root);
        this.m_treeRenderer = new JASTreeCellRenderer();
        this.m_listRenderer = new JASListCellRenderer();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.m_job.eventsAnalyzed());
        objectOutputStream.writeBoolean(this.m_job.isAtEndOfData());
        this.m_changes = 0;
        this.m_command.forceSetChanged();
    }

    private void readObject(ObjectInputStream objectInputStream) throws OpenJobException {
        try {
            this.m_treeRenderer = new JASTreeCellRenderer();
            this.m_eventSourceModel = new ComboModel();
            this.m_listRenderer = new JASListCellRenderer();
            this.m_plugins = new Vector();
            this.m_pluginMenus = new Vector();
            this.m_pluginContext = new JobPluginContext(this.m_app);
            objectInputStream.defaultReadObject();
            this.m_root = new TreeNode(this.m_name, "Job");
            this.m_treeModel = new SimpleTreeModel(this.m_root);
            this.m_job.reopen(objectInputStream, this);
            this.m_app = JavaAnalysisStudio.getApp();
            this.m_changes = 0;
            this.m_command = new JASJobCommandProcessor();
            this.m_command.setChanged();
            this.m_app.getCommandManager().add(this.m_command);
            this.m_stopMonitor = this.m_app.registerStoppable(this);
        }
        catch (Exception exception) {
            throw new OpenJobException(exception);
        }
        this.m_changes = 0;
    }

    private void addPlugin(IPlugin iPlugin) {
        this.m_plugins.addElement(iPlugin);
        iPlugin.setPluginContext(this.m_pluginContext);
    }

    void loadPlugin(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class clazz = this.loadClientClass(string);
        IPlugin iPlugin = (IPlugin)clazz.newInstance();
        this.addPlugin(iPlugin);
    }

    Class loadClientClass(String string) throws ClassNotFoundException {
        return this.m_job.loadClientClass(string);
    }

    void close() {
        Object object;
        Object object2;
        if (this.m_job != null) {
            this.m_job.close();
        }
        if (this.m_command != null) {
            this.m_app.getCommandManager().remove(this.m_command);
        }
        this.m_job = null;
        this.m_command = null;
        if (this.m_stopMonitor != null) {
            this.m_stopMonitor.end();
        }
        this.clearTreeModel();
        this.clearEventSourceModel();
        this.m_app.setCurrentSelection(null);
        Enumeration enumeration = this.m_plugins.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (IPlugin)enumeration.nextElement();
            object2.destroy();
        }
        object2 = this.m_app.getMenuBar();
        enumeration = this.m_pluginMenus.elements();
        while (enumeration.hasMoreElements()) {
            object = (JMenu)enumeration.nextElement();
            ((Container)object2).remove((Component)object);
        }
        ((JComponent)object2).revalidate();
        object = Runtime.getRuntime();
        ((Runtime)object).gc();
        ((Runtime)object).runFinalization();
    }

    void reload() throws RemoteException, LoaderException {
        if (this.m_job != null) {
            this.m_job.reload();
        }
        ++this.m_changes;
        this.m_command.forceSetChanged();
    }

    String getName() {
        return this.m_name;
    }

    void setFilePath(String string) {
        this.m_filePath = string;
    }

    String getFilePath() {
        return this.m_filePath;
    }

    void setJob(Job job) {
        this.m_job = job;
        this.m_app.getCommandManager().add(this.m_command);
        this.m_stopMonitor = this.m_app.registerStoppable(this);
    }

    boolean isChanged() {
        return this.m_changes > 0 || this.m_job != null && this.m_job.isChanged();
    }

    void setTreeModel(JTree jTree) {
        if (this.m_tree != null) {
            this.m_tree.getSelectionModel().removeTreeSelectionListener(this);
        }
        this.m_tree = jTree;
        if (jTree != null) {
            jTree.setModel(this.m_treeModel);
            jTree.setCellRenderer(this.m_treeRenderer);
            jTree.setCellEditor(new JASTreeCellEditor(jTree, this.m_treeRenderer));
            jTree.getSelectionModel().addTreeSelectionListener(this);
        }
    }

    private void clearTreeModel() {
        this.setTreeModel(null);
    }

    void setEventSourceModel(JComboBox jComboBox) {
        if (this.m_combo != null) {
            this.m_combo.removeActionListener(this);
        }
        this.m_combo = jComboBox;
        if (jComboBox != null) {
            jComboBox.setModel(this.m_eventSourceModel);
            jComboBox.setRenderer(this.m_listRenderer);
            jComboBox.addActionListener(this);
        }
    }

    private void clearEventSourceModel() {
        this.setEventSourceModel(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TreeNode treeNode = (TreeNode)this.m_combo.getSelectedItem();
        if (treeNode != null) {
            this.m_job.setEventSource(treeNode.getTreeItem());
        }
    }

    void updateTree() {
        ++this.m_changes;
        if (this.m_command != null) {
            this.m_command.forceSetChanged();
        }
    }

    void setCommandChanged() {
        if (this.m_command != null) {
            this.m_command.setChanged();
        }
    }

    Job getJob() {
        return this.m_job;
    }

    ComboBoxModel getComboModel() {
        return this.m_eventSourceModel;
    }

    ListCellRenderer getListRenderer() {
        return this.m_listRenderer;
    }

    public void stop() {
        this.m_job.stop();
        this.m_stopMonitor.doStopEnabling();
    }

    public boolean isRunning() {
        return this.m_job.isRunning();
    }

    void addNode(TreeItem treeItem) {
        TreeNode treeNode = (TreeNode)this.m_root.add(treeItem);
        if ((treeItem.flags & 0x20000) != 0) {
            this.m_eventSourceModel.addElement(treeNode);
        }
        treeNode.update();
    }

    void deleteNode(TreeItem treeItem) {
        TreeNode treeNode = (TreeNode)this.m_root.find(treeItem);
        this.deleteEventSource(treeNode);
        treeNode.destroy();
    }

    private void deleteEventSource(TreeNode treeNode) {
        this.m_eventSourceModel.removeElement(treeNode);
        Enumeration enumeration = treeNode.children();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.deleteEventSource((TreeNode)enumeration.nextElement());
            }
        }
    }

    private Object getAssociatedObject(TreeNode treeNode) {
        return this.m_job.getItem(this.getTreeItem(treeNode));
    }

    private TreeItem getTreeItem(TreeNode treeNode) {
        return treeNode.getTreeItem(this.m_root);
    }

    public Object getItem(TreeItem treeItem) {
        return this.m_job.getItem(treeItem);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeNode treeNode = (TreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        TreeAdaptor treeAdaptor = treeNode.getTreeAdaptor();
        this.m_app.setCurrentSelection(treeAdaptor);
    }

    void loadClass(String string) {
        try {
            this.m_job.loadObject(string);
            ++this.m_changes;
            this.setCommandChanged();
        }
        catch (LoaderException loaderException) {
            this.m_app.error("Could not load class", loaderException);
        }
    }

    boolean isLoaded(String string) {
        return this.m_job.isLoaded(string);
    }

    class JASJobCommandProcessor
    extends JASCommandProcessor {
        JASJobCommandProcessor() {
        }

        public void onOpenDataset() {
            if (JASJob.this.m_job instanceof JASJobAdaptor) {
                new JASWizard(JASJob.this.m_app.getFrame(), "New Dataset", new OpenDataSetPage((JASJobAdaptor)JASJob.this.m_job, JASJob.this.m_app));
            } else {
                new JASWizard(JASJob.this.m_app.getFrame(), "New Dataset", new LocalJobPage(new JASLocalJobBuilder((LocalJob)JASJob.this.m_job)));
            }
        }

        public void onLoadProgram() {
            LoadDialog loadDialog = new LoadDialog(JASJob.this.m_app.getFrame());
            if (loadDialog.doModal()) {
                JASJob.this.loadClass(loadDialog.getClassName());
            }
        }

        public void onLoadPlugin() {
            LoadPluginDialog loadPluginDialog = new LoadPluginDialog(JASJob.this.m_app.getFrame());
            if (loadPluginDialog.doModal()) {
                try {
                    JASJob.this.loadPlugin(loadPluginDialog.getClassName());
                }
                catch (Exception exception) {
                    JASJob.this.m_app.error("Could not load plugin", exception);
                }
            }
        }

        public void onUnloadAllPrograms() throws RemoteException {
            JASJob.this.m_job.unloadAll();
            JASJob.this.m_changes++;
            this.setChanged();
        }

        public void onSaveJob() throws IOException, JASException {
            JASJob.this.m_app;
            throw new NotImplemented("Saving and restoring jobs");
        }

        public void onSaveJobAs() throws IOException, JASException {
            JASJob.this.m_app;
            throw new NotImplemented("Saving and restoring jobs");
        }

        public void onCloseCurrentJob() {
            JASJob.this.m_app.closeCurrentJob();
            JASJob.this.m_app.setToEmptyJob();
        }

        public void enableDisconnect(JASState jASState) {
            jASState.setEnabled(JASJob.this.m_job instanceof JASJobAdaptor);
        }

        public void onDisconnect() throws RemoteException {
            ((JASJobAdaptor)JASJob.this.m_job).disconnect();
            JASJob.this.m_job = null;
            JASJob.this.m_app.closeCurrentJob();
            JASJob.this.m_app.setToEmptyJob();
        }

        public void onKill() throws RemoteException {
            JASJob.this.m_job.kill();
        }

        public void onRewind() throws RemoteException {
            JASJob.this.m_job.rewind();
        }

        public void onStep() throws RemoteException {
            JASJob.this.m_job.go(1);
        }

        public void onGo() throws RemoteException {
            JASJob.this.m_job.go(0);
        }

        public void enableGo(JASState jASState) {
            jASState.setEnabled(JASJob.this.m_job.isRunnable() && !JASJob.this.m_job.isAtEndOfData());
        }

        public void enableStep(JASState jASState) {
            jASState.setEnabled(JASJob.this.m_job.isRunnable() && !JASJob.this.m_job.isAtEndOfData());
        }

        public void enableRewind(JASState jASState) {
            jASState.setEnabled(!JASJob.this.m_job.isAtStartOfData());
        }

        public void enableKill(JASState jASState) {
            jASState.setEnabled(JASJob.this.m_job.isRunning());
        }

        public void enablePersistent(JASCheckboxState jASCheckboxState) {
            jASCheckboxState.setCheckbox(JASJob.this.m_job.isPersistent());
            jASCheckboxState.setEnabled(true);
        }

        public void onPersistent(boolean bl) throws RemoteException {
            JASJob.this.m_job.setPersistent(bl);
            JASJob.this.m_changes++;
            this.setChanged();
        }

        protected void setChanged() {
            super.setChanged();
            if (JASJob.this.m_stopMonitor != null) {
                JASJob.this.m_stopMonitor.doStopEnabling();
            }
        }

        void forceSetChanged() {
            super.setChanged();
        }
    }

    private class JASListCellRenderer
    extends DefaultListCellRenderer {
        private JASListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                this.setIcon(((TreeNode)object).getIcon());
            }
            return this;
        }
    }

    private class JASTreeCellEditor
    extends DefaultTreeCellEditor {
        JASTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
        }

        protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            this.editingIcon = ((TreeNode)object).getIcon();
            if (this.editingIcon == null) {
                super.determineOffset(jTree, object, bl, bl2, bl3, n);
            } else {
                this.offset = this.renderer.getIconTextGap() + this.editingIcon.getIconWidth();
            }
        }

        protected TreeCellEditor createTreeCellEditor() {
            Border border = UIManager.getBorder("Tree.editorBorder");
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new DefaultTreeCellEditor.DefaultTextField(this, border)){

                public boolean shouldSelectCell(EventObject eventObject) {
                    boolean bl = super.shouldSelectCell(eventObject);
                    this.getComponent().requestFocus();
                    return bl;
                }

                public boolean stopCellEditing() {
                    TreeNode treeNode = (TreeNode)JASJob.this.m_tree.getEditingPath().getLastPathComponent();
                    if (treeNode.getTreeAdaptor().stopEditing(this.getCellEditorValue().toString())) {
                        return super.stopCellEditing();
                    }
                    return false;
                }
            };
            defaultCellEditor.setClickCountToStart(1);
            return defaultCellEditor;
        }
    }

    private class JASTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private JASTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Icon icon = ((TreeNode)object).getIcon();
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }

    class TreeNode
    extends OrderedNode
    implements TreeAdaptorSite,
    Serializable {
        private TreeAdaptor adaptor;

        TreeNode(String string, String string2) {
            super(string, string2, 0, JASJob.this);
        }

        TreeNode(TreeNode treeNode, String string, String string2, int n) {
            this(treeNode, string, string2, n, null);
        }

        private TreeNode(TreeNode treeNode, String string, String string2, int n, Object object) {
            super(treeNode, string, string2, n, object);
        }

        protected SimpleNode createNode(SimpleNode simpleNode, String string, String string2, int n, Object object) {
            return new TreeNode((TreeNode)simpleNode, string, string2, n, object);
        }

        public TreeAdaptor getTreeAdaptor() {
            if (this.adaptor == null && this.getType() != null) {
                try {
                    String string = this.getType();
                    string = string.indexOf(".") < 0 ? "jas.swingstudio.adaptor." + string.substring(0, 1).toUpperCase() + string.substring(1) + "TreeAdaptor" : string + "TreeAdaptor";
                    Class<?> clazz = Class.forName(string);
                    this.adaptor = (TreeAdaptor)clazz.newInstance();
                    this.adaptor.setAdaptorSite(this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.adaptor = null;
                }
                catch (InstantiationException instantiationException) {
                    this.adaptor = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.adaptor = null;
                }
            }
            return this.adaptor;
        }

        void update() {
            int n = this.getFlags();
            if ((n & 0x80000) != 0 && this.adaptor == null) {
                this.getTreeAdaptor();
            }
            if (this.adaptor != null) {
                this.adaptor.updateNode(n);
            }
        }

        public Object getAssociatedObject() {
            return this.getObject();
        }

        public PluginContext getPluginContext() {
            return JASJob.this.m_pluginContext;
        }

        public TreeItem getTreeItem() {
            return JASJob.this.getTreeItem(this);
        }

        public Job getJob() {
            return JASJob.this.m_job;
        }

        Icon getIcon() {
            try {
                return new JASIcon(this, "images/" + this.getType() + ".gif");
            }
            catch (ImageException imageException) {
                return null;
            }
        }

        public TreeAdaptorSite getParentAdaptor() {
            return (TreeNode)this.getParent();
        }

        boolean isEditable() {
            TreeAdaptor treeAdaptor = this.getTreeAdaptor();
            return treeAdaptor == null ? false : treeAdaptor.isEditable();
        }

        JPopupMenu getPopupMenu() {
            TreeAdaptor treeAdaptor = this.getTreeAdaptor();
            return treeAdaptor == null ? null : treeAdaptor.getPopupMenu();
        }

        public void startEditing() {
            SimpleNode simpleNode = this;
            int n = 0;
            while (simpleNode != null) {
                simpleNode = simpleNode.getParent();
                ++n;
            }
            Object[] objectArray = new SimpleNode[n];
            simpleNode = this;
            int n2 = 1;
            while (simpleNode != null) {
                objectArray[n - n2] = simpleNode;
                simpleNode = simpleNode.getParent();
                ++n2;
            }
            JASJob.this.m_tree.startEditingAtPath(new TreePath(objectArray));
        }
    }

    private class ComboModel
    extends DefaultComboBoxModel {
        private ComboModel() {
        }

        public void addElement(TreeNode treeNode) {
            int n = this.getIndexOf(treeNode);
            if (n < 0) {
                super.addElement(treeNode);
            }
            if ((treeNode.getFlags() & 0x40000) != 0 && this.getSelectedItem() != treeNode) {
                this.setSelectedItem(treeNode);
            }
        }
    }

    private class JobPluginContext
    extends JASPluginContext
    implements PluginContext {
        private Vector m_runListeners = new Vector();

        JobPluginContext(JavaAnalysisStudio javaAnalysisStudio) {
            super(javaAnalysisStudio);
        }

        public void addMenu(JMenu jMenu) {
            super.addMenu(jMenu);
            JASJob.this.m_pluginMenus.addElement(jMenu);
        }

        public void removeMenu(JMenu jMenu) {
            super.removeMenu(jMenu);
            JASJob.this.m_pluginMenus.removeElement(jMenu);
        }

        public void addRunListener(RunListener runListener) {
            JASJob.this.m_job.addRunListener(runListener);
        }

        public void removeRunListener(RunListener runListener) {
            JASJob.this.m_job.removeRunListener(runListener);
        }

        public EventData getCurrentEvent() throws NoEventAvailable {
            return JASJob.this.m_job.getEvent();
        }

        public void sendJob(Object object) {
            JASJob.this.m_job.receiveMessage(object);
        }
    }
}

