/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import hep.analysis.NamedObject;
import jas.hist.DataSource;
import jas.jds.interfaces.RemoteHistogramAccess;
import jas.job.HistogramAccess;
import jas.swingstudio.JASRebinAdaptor;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.rmi.RMIDestination;
import jas.util.rmi.RMIEventDelivery;
import java.rmi.RemoteException;

class JASHistogramAccessAdaptor
implements HistogramAccess {
    private RMIEventDelivery m_ed;
    private RemoteHistogramAccess m_remote;
    private JavaAnalysisStudio app = JavaAnalysisStudio.getApp();

    public JASHistogramAccessAdaptor(RemoteHistogramAccess remoteHistogramAccess, RMIEventDelivery rMIEventDelivery) {
        this.m_remote = remoteHistogramAccess;
        this.m_ed = rMIEventDelivery;
    }

    public void delete() {
        try {
            this.m_remote.delete();
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
        }
    }

    public void rename(String string) throws NamedObject.RenameException {
        try {
            this.m_remote.rename(string);
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
        }
    }

    public void clear() {
        try {
            this.m_remote.clear();
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
        }
    }

    public boolean isClearOnRewind() {
        try {
            return this.m_remote.isClearOnRewind();
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
            return false;
        }
    }

    public boolean canSetClearOnRewind() {
        try {
            return this.m_remote.canSetClearOnRewind();
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
            return false;
        }
    }

    public void setClearOnRewind(boolean bl) {
        try {
            this.m_remote.setClearOnRewind(bl);
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
        }
    }

    public String getDescription() {
        try {
            return this.m_remote.getDescription();
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
            return "";
        }
    }

    public DataSource getData() {
        try {
            RMIDestination rMIDestination = this.m_ed.getRMIDestination();
            return JASRebinAdaptor.getAdaptor(this.m_remote.getData(rMIDestination), this.m_ed, rMIDestination);
        }
        catch (RemoteException remoteException) {
            this.app.error("Network Error", remoteException);
            return null;
        }
    }
}

