/*
 * Decompiled with CFR 0.152.
 */
package jas.swingstudio;

import jas.plot.HasPopupItems;
import jas.plot.PopupMenuBuilder;
import jas.plot.PrintHelper;
import jas.swingstudio.Closable;
import jas.swingstudio.HasCommandProcessor;
import jas.swingstudio.JASCommandProcessor;
import jas.swingstudio.JASHTMLEditorKit;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.CommandProcessor;
import jas.util.JASMenuItem;
import jas.util.JASState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HTMLPage
extends JPanel
implements HasCommandProcessor,
HasPopupItems,
Closable {
    private JASHTMLEditorKit editorKit;
    private JEditorPane jep = new JEditorPane();
    private HTMLCommand htmlCommand = new HTMLCommand();
    private URLHistory urlHistory;
    private JavaAnalysisStudio app = JavaAnalysisStudio.getApp();

    HTMLPage(URL uRL) {
        super(new BorderLayout());
        this.jep.setEditable(false);
        this.jep.setMargin(new Insets(0, 0, 0, 0));
        this.editorKit = new JASHTMLEditorKit(this);
        this.jep.setEditorKitForContentType("text/html", this.editorKit);
        this.urlHistory = new URLHistory(uRL);
        try {
            this.jep.setPage(uRL);
        }
        catch (Exception exception) {
            this.app.error("Could not open home page", exception);
        }
        JScrollPane jScrollPane = new JScrollPane(this.jep);
        this.add((Component)jScrollPane, "Center");
        this.jep.addHyperlinkListener(new SimpleLinkListener());
        this.jep.addMouseListener(new PopupMenuBuilder());
        this.jep.addCaretListener(this.htmlCommand);
    }

    public boolean pleaseClose() {
        this.editorKit.destroy();
        return true;
    }

    public void pageSelected(boolean bl) {
    }

    public CommandProcessor getCommandProcessor() {
        return this.htmlCommand;
    }

    void showURL(URL uRL) {
        SwingUtilities.invokeLater(new PageLoader(uRL));
    }

    public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(new JASMenuItem("Copy", 'C'));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JASMenuItem("Home", 'H'));
        jPopupMenu.add(new JASMenuItem("Back", 'B'));
        jPopupMenu.add(new JASMenuItem("Forward", 'F'));
        jPopupMenu.add(new JASMenuItem("Refresh", 'R'));
        jPopupMenu.add(new JASMenuItem("Web Page...", 'W'));
    }

    class PageLoader
    implements Runnable {
        private URL url;
        private Cursor cursor;

        PageLoader(URL uRL) {
            this.url = uRL;
            this.cursor = HTMLPage.this.jep.getCursor();
            HTMLPage.this.jep.setCursor(Cursor.getPredefinedCursor(3));
        }

        public void run() {
            try {
                try {
                    HTMLPage.this.jep.setPage(this.url);
                    HTMLPage.this.urlHistory.recordVisit(this.url);
                    HTMLPage.this.htmlCommand.setChanged();
                }
                catch (IOException iOException) {
                    HTMLPage.this.app.error("Could not load page " + this.url, iOException);
                    Object var3_2 = null;
                    HTMLPage.this.jep.setCursor(this.cursor);
                }
                Object var3_1 = null;
                HTMLPage.this.jep.setCursor(this.cursor);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                HTMLPage.this.jep.setCursor(this.cursor);
                throw throwable;
            }
        }
    }

    private class HistoryItem
    extends JMenuItem {
        private URL url;

        HistoryItem(URL uRL) {
            super(uRL.toString());
            this.url = uRL;
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            HTMLPage.this.showURL(this.url);
            super.fireActionPerformed(actionEvent);
        }
    }

    private class URLHistory
    extends Vector {
        private ListItem m_current;

        URLHistory(URL uRL) {
            this.m_current = new ListItem(uRL);
            this.recordInHistory(uRL);
        }

        private void clear(ListItem listItem) {
            if (listItem == null) {
                return;
            }
            this.clear(listItem.next);
            listItem.prev = null;
            listItem.next = null;
            listItem.url = null;
        }

        void recordVisit(URL uRL) {
            if (this.m_current.next == null || !this.m_current.next.url.equals(uRL)) {
                this.clear(this.m_current.next);
                this.m_current.next = new ListItem(uRL);
                new ListItem(uRL).prev = this.m_current;
            }
            this.m_current = this.m_current.next;
            this.recordInHistory(uRL);
        }

        private void recordInHistory(URL uRL) {
            if (this.contains(uRL)) {
                this.removeElement(uRL);
            }
            this.insertElementAt(uRL, 0);
        }

        boolean enableForward() {
            return this.m_current.next != null;
        }

        void goForward() throws IOException {
            this.m_current = this.m_current.next;
            HTMLPage.this.jep.setPage(this.m_current.url);
        }

        boolean enableBack() {
            return this.m_current.prev != null;
        }

        void goBack() throws IOException {
            this.m_current = this.m_current.prev;
            HTMLPage.this.jep.setPage(this.m_current.url);
        }

        void reload() throws IOException {
            HTMLPage.this.jep.getDocument().putProperty("stream", null);
            HTMLPage.this.jep.setPage(this.m_current.url);
        }

        boolean enableHistory() {
            return this.size() > 0;
        }

        private class ListItem {
            URL url;
            ListItem next;
            ListItem prev;

            ListItem(URL uRL) {
                this.url = uRL;
            }
        }
    }

    private class SimpleLinkListener
    implements HyperlinkListener {
        private SimpleLinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
            if (eventType == HyperlinkEvent.EventType.ENTERED) {
                URL uRL = hyperlinkEvent.getURL();
                if (uRL != null) {
                    HTMLPage.this.jep.setCursor(Cursor.getPredefinedCursor(12));
                    HTMLPage.this.app.setMessage(uRL.toString());
                }
            } else if (eventType == HyperlinkEvent.EventType.EXITED) {
                HTMLPage.this.jep.setCursor(Cursor.getDefaultCursor());
                HTMLPage.this.app.setMessage(" ");
            } else if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)HTMLPage.this.jep.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                HTMLPage.this.showURL(hyperlinkEvent.getURL());
            }
        }
    }

    private class HTMLCommand
    extends JASCommandProcessor
    implements CaretListener {
        private HTMLCommand() {
        }

        public void onPrint() throws Exception {
            PrintHelper printHelper = PrintHelper.instance();
            printHelper.printTarget(HTMLPage.this.jep);
        }

        public void onRefresh() throws IOException {
            HTMLPage.this.urlHistory.reload();
        }

        public void onBack() throws IOException {
            HTMLPage.this.urlHistory.goBack();
            this.setChanged();
        }

        public void onForward() throws IOException {
            HTMLPage.this.urlHistory.goForward();
            this.setChanged();
        }

        public void enableBack(JASState jASState) {
            jASState.setEnabled(HTMLPage.this.urlHistory.enableBack());
        }

        public void enableForward(JASState jASState) {
            jASState.setEnabled(HTMLPage.this.urlHistory.enableForward());
        }

        public void onCopy() {
            HTMLPage.this.jep.copy();
        }

        public void enableCopy(JASState jASState) {
            jASState.setEnabled(HTMLPage.this.jep.getSelectedText() != null);
        }

        public void setChanged() {
            super.setChanged();
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.setChanged();
        }
    }
}

