/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.FontMenuItem;
import jas.plot.MovableObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPopupMenu;

public abstract class TextBlock
extends MovableObject {
    protected FontMetrics fm;
    private int blockwidth;
    private int blockheight;
    private int maxleftsplitwidth;
    private int maxrightsplitwidth;
    private int numberlinesallocated;
    private static final int WIDTHSPACE = 5;
    private static final int LEFTALIGNSPLIT = 1;
    private static final int RIGHTALIGNSPLIT = 2;
    private static final int NOALIGNSPLIT = 3;

    public TextBlock(String string) {
        super(string);
        this.setBorderType(4);
        this.setFont(new Font("SansSerif", 0, 10));
    }

    public abstract int getNLines();

    public abstract String getLine(int var1);

    public abstract int getSplitStringAlign();

    public Dimension getPreferredSize() {
        if (this.fm == null) {
            this.fm = this.getGraphics().getFontMetrics(this.getFont());
        }
        this.allocateSize();
        Insets insets = this.getInsets();
        return new Dimension(this.blockwidth + insets.right + insets.left, insets.top + insets.bottom + this.blockheight);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.getForeground());
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(this.getFont());
        }
        Insets insets = this.getInsets();
        int n = this.fm.getAscent() + insets.top;
        int n2 = this.fm.getHeight();
        int n3 = this.getSplitStringAlign();
        boolean bl = false;
        if (this.getNLines() != this.numberlinesallocated) {
            bl = true;
        }
        int n4 = 0;
        while (n4 < this.getNLines()) {
            String string = this.getLine(n4);
            if (string != null) {
                if (string.equals("\n")) {
                    if (n4 > 0) {
                        graphics.drawLine(insets.left, n -= n2 / 2, this.blockwidth + insets.right, n);
                        n += n2;
                    }
                } else {
                    String[] stringArray = this.formatLine(string);
                    if (this.fm.stringWidth(stringArray[0]) > this.maxleftsplitwidth || stringArray[1] != null && this.fm.stringWidth(stringArray[1]) > this.maxrightsplitwidth) {
                        bl = true;
                    }
                    graphics.drawString(stringArray[0], insets.left, n);
                    if (stringArray[1] != null && n3 == 1) {
                        graphics.drawString(stringArray[1], insets.left + this.maxleftsplitwidth, n);
                    } else if (stringArray[1] != null && n3 == 2) {
                        graphics.drawString(stringArray[1], insets.left + this.rightAlignSplitWidth(stringArray[1]), n);
                    } else if (stringArray[1] != null && n3 == 3) {
                        graphics.drawString(stringArray[1], insets.left + this.fm.stringWidth(stringArray[0]), n);
                    }
                    n += n2;
                }
            }
            ++n4;
        }
        if (bl) {
            this.revalidate();
        }
    }

    public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        jPopupMenu.add(new FontMenuItem(this, this.getPrefix()));
        super.modifyPopupMenu(jPopupMenu, component);
    }

    private String[] formatLine(String string) {
        String[] stringArray = new String[2];
        if (string != null) {
            int n = string.indexOf(9);
            if (n >= 0) {
                stringArray[0] = "  " + string.substring(0, n) + " : ";
                stringArray[1] = string.substring(n + 1) + " ";
            } else {
                stringArray[0] = string;
            }
        }
        return stringArray;
    }

    protected void allocateSize() {
        this.maxleftsplitwidth = 0;
        this.maxrightsplitwidth = 0;
        this.blockwidth = 30;
        this.blockheight = 0;
        int n = this.fm.getHeight();
        this.numberlinesallocated = this.getNLines();
        int n2 = 0;
        while (n2 < this.getNLines()) {
            String string = this.getLine(n2);
            if (string != null) {
                if (string.equals("\n")) {
                    if (n2 > 0) {
                        this.blockheight += n / 2;
                    }
                } else {
                    this.blockheight += n;
                    this.blockWidth(string);
                }
            }
            ++n2;
        }
        if (this.blockheight == 0) {
            this.blockheight = n;
        }
    }

    private int rightAlignSplitWidth(String string) {
        int n = 0;
        int n2 = 0;
        if (string != null) {
            n2 = this.fm.stringWidth(string);
            n = this.blockwidth - n2 - 5;
        }
        return n;
    }

    private void blockWidth(String string) {
        String[] stringArray = this.formatLine(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getSplitStringAlign();
        if (stringArray[0] != null) {
            n2 = this.fm.stringWidth(stringArray[0]);
        }
        if (stringArray[1] != null) {
            n3 = this.fm.stringWidth(stringArray[1]);
        }
        if (n4 == 1 && stringArray[1] != null) {
            if (n2 > this.maxleftsplitwidth) {
                this.maxleftsplitwidth = n2;
            }
            if (n3 > this.maxrightsplitwidth) {
                this.maxrightsplitwidth = n3;
            }
            n = this.maxrightsplitwidth + this.maxleftsplitwidth + 5;
        } else {
            n = n3 + n2 + 5;
        }
        if (n > this.blockwidth) {
            this.blockwidth = n;
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = null;
        this.revalidate();
        this.repaint();
    }
}

