/*
 * Decompiled with CFR 0.152.
 */
package jas.loader;

import jas.loader.ClassPath;
import jas.loader.NestedClassException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPathLoader
extends ClassLoader {
    private static final boolean debug = System.getProperty("debugLoader") != null;
    private String loaderName;
    private ClassPath path;
    private Hashtable m_cache = new Hashtable();

    public ClassPathLoader(ClassPath classPath, String string) {
        this.path = classPath;
        this.loaderName = string;
    }

    public ClassPath getClassPath() {
        return this.path;
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)this.m_cache.get(string);
        if (clazz == null) {
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                clazz = classLoader != null ? classLoader.loadClass(string) : this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                byte[] byArray = this.loadClassData(string);
                clazz = this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                byte[] byArray = this.loadClassData(string);
                clazz = this.defineClass(string, byArray, 0, byArray.length);
            }
            this.m_cache.put(string, clazz);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public URL getResource(String string) {
        if (debug) {
            System.err.println("Could not load resource " + string);
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        Enumeration enumeration = this.path.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            inputStream = e instanceof ZipFile ? this.getResourceFromJar((ZipFile)e, string) : this.getResourceFromFileSystem((File)e, string);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    private InputStream getResourceFromFileSystem(File file, String string) {
        try {
            File file2 = new File(file, string);
            if (file2.exists()) {
                return new FileInputStream(file2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private InputStream getResourceFromJar(ZipFile zipFile, String string) {
        try {
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                return zipFile.getInputStream(zipEntry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public byte[] loadClassData(String string) throws ClassNotFoundException {
        String string2 = File.separator;
        String string3 = string.replace('.', string2.charAt(0)) + ".class";
        String string4 = string.replace('.', '/') + ".class";
        Enumeration enumeration = this.path.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            byte[] byArray = e instanceof ZipFile ? this.loadFromJar((ZipFile)e, string4) : this.loadFromFilesystem((File)e, string3);
            if (byArray == null) continue;
            if (debug) {
                String string5 = e instanceof ZipFile ? ((ZipFile)e).getName() : ((File)e).getAbsolutePath();
                System.out.println(this.loaderName + ": loaded class " + string + " from: " + string5);
            }
            return byArray;
        }
        throw new ClassNotFoundException("Class " + string + " not found");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadFromFilesystem(File var1_1, String var2_2) throws NestedClassException {
        var3_3 = new File(var1_1, var2_2);
        var4_4 = null;
        try {
            try {
                var4_4 = new FileInputStream(var3_3);
                var5_5 = (int)var3_3.length();
                var6_7 = this.loadFromInputStream(var4_4, var5_5);
                var8_10 = null;
            }
            catch (FileNotFoundException var5_6) {
                var6_8 = null;
                var8_11 = null;
                try {
                    if (var4_4 == null) return var6_8;
                    var4_4.close();
                    return var6_8;
                }
                catch (IOException var9_14) {
                    // empty catch block
                }
                return var6_8;
            }
            catch (IOException var6_9) {
                throw new NestedClassException("Error reading class file: " + var3_3.getName(), var6_9);
            }
        }
        catch (Throwable var7_16) {
            var8_12 = null;
            try {}
            catch (IOException var9_15) {
                throw var7_16;
            }
            if (var4_4 == null) throw var7_16;
            var4_4.close();
            throw var7_16;
        }
        ** try [egrp 2[TRYBLOCK] [3 : 101->114)] { 
lbl35:
        // 1 sources

        if (var4_4 == null) return var6_7;
        var4_4.close();
        return var6_7;
lbl38:
        // 1 sources

        catch (IOException var9_13) {
            // empty catch block
        }
        return var6_7;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadFromJar(ZipFile var1_1, String var2_2) throws ClassNotFoundException {
        block10: {
            block9: {
                var3_3 = null;
                try {
                    try {
                        var4_4 = var1_1.getEntry(var2_2);
                        if (var4_4 == null) {
                            var5_6 = null;
                            var9_7 = null;
                            break block9;
                        }
                        var3_3 = var1_1.getInputStream(var4_4);
                        var6_13 = (int)var4_4.getSize();
                        var7_14 = this.loadFromInputStream(var3_3, var6_13);
                        break block10;
                    }
                    catch (IOException var4_5) {
                        throw new NestedClassException("Error reading zip file: " + var1_1.getName(), var4_5);
                    }
                }
                catch (Throwable var8_15) {
                    var9_9 = null;
                    try {
                        if (var3_3 == null) throw var8_15;
                        var3_3.close();
                        throw var8_15;
                    }
                    catch (IOException var10_12) {
                        throw var8_15;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 97->108)] { 
lbl28:
            // 1 sources

            if (var3_3 == null) return var5_6;
            var3_3.close();
            return var5_6;
lbl31:
            // 1 sources

            catch (IOException var10_10) {
                // empty catch block
            }
            return var5_6;
        }
        var9_8 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 97->108)] { 
lbl37:
        // 1 sources

        if (var3_3 == null) return var7_14;
        var3_3.close();
        return var7_14;
lbl40:
        // 1 sources

        catch (IOException var10_11) {
            // empty catch block
        }
        return var7_14;
    }

    protected byte[] loadFromInputStream(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = inputStream.read(byArray, n2, n);
        while (n3 > 0) {
            n3 = inputStream.read(byArray, n2 += n3, n -= n3);
        }
        return byArray;
    }
}

