/*
 * Decompiled with CFR 0.152.
 */
package jas.loader;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassPath {
    private Vector v = new Vector();

    public ClassPath() {
    }

    public ClassPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreElements()) {
            try {
                this.add(stringTokenizer.nextToken());
            }
            catch (ZipException zipException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void add(String string) throws ZipException, IOException {
        File file = new File(string);
        if (file.isDirectory()) {
            this.v.addElement(file);
        } else {
            ZipFile zipFile = new ZipFile(file);
            this.v.addElement(zipFile);
        }
    }

    public void add(File file) {
        this.v.addElement(file);
    }

    public void add(ZipFile zipFile) {
        this.v.addElement(zipFile);
    }

    public Enumeration elements() {
        return this.v.elements();
    }

    public void setContents(Vector vector) {
        this.v = vector;
    }

    public void clear() {
        Enumeration enumeration = this.v.elements();
        this.v = new Vector();
        this.close(enumeration);
    }

    private void close(Enumeration enumeration) {
        enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            try {
                if (!(e instanceof ZipFile)) continue;
                ((ZipFile)e).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void finalize() {
        this.close(this.v.elements());
    }

    public String getClassPath() {
        String string = File.pathSeparator;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            stringBuffer.append(e instanceof ZipFile ? ((ZipFile)e).getName() : e.toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getClassPath();
    }
}

