/*
 * Decompiled with CFR 0.152.
 */
package jas.jds.module;

import hep.analysis.EventSource;
import jas.jds.module.DIM2;
import jas.jds.module.ModuleException;
import jas.util.tree.TreeItem;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;

public abstract class BasicServer
implements FilenameFilter,
DIM2 {
    private String directory = ".";
    private String fileExtension;
    private String title;
    private Vector dataSetList;

    public BasicServer(String[] stringArray, String string, String string2) {
        this.fileExtension = string2;
        this.title = string;
        if (stringArray.length > 0) {
            this.title = stringArray[0];
        }
        if (stringArray.length > 1) {
            this.directory = stringArray[1];
        }
        if (stringArray.length > 2) {
            this.fileExtension = stringArray[2];
        }
        if (stringArray.length > 3) {
            throw new RuntimeException("Too many arguments passed to server");
        }
    }

    public boolean accept(File file, String string) {
        if (new File(file, string).isDirectory()) {
            TreeItem treeItem = new TreeItem();
            treeItem.path = new String[1];
            treeItem.path[0] = string;
            treeItem.flags = 1;
            this.dataSetList.addElement(treeItem);
        } else if (this.fileExtension == null || string.endsWith("." + this.fileExtension)) {
            TreeItem treeItem = new TreeItem();
            treeItem.path = new String[1];
            treeItem.path[0] = string;
            this.dataSetList.addElement(treeItem);
        }
        return true;
    }

    public TreeItem[] getDataSets(TreeItem treeItem) {
        this.dataSetList = new Vector();
        File file = new File(this.directory);
        int n = 0;
        while (n < treeItem.path.length) {
            file = new File(file, treeItem.path[n]);
            ++n;
        }
        file.list(this);
        System.out.println("getDataSets returned " + this.dataSetList.size() + " items for base=" + treeItem);
        Object[] objectArray = new TreeItem[this.dataSetList.size()];
        this.dataSetList.copyInto(objectArray);
        this.dataSetList = null;
        return objectArray;
    }

    public EventSource openDataSet(TreeItem treeItem) throws ModuleException {
        File file = new File(this.directory);
        int n = 0;
        while (n < treeItem.path.length) {
            file = new File(file, treeItem.path[n]);
            ++n;
        }
        return this.createEventSource(file.getAbsolutePath());
    }

    public EventSource openDataSet(String string) throws ModuleException {
        throw new RuntimeException("Unimplemented method exception");
    }

    protected abstract EventSource createEventSource(String var1) throws ModuleException;

    public String toString() {
        return this.title;
    }
}

