/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.uth.command;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.freehep.uth.command.CommandEvent;
import org.freehep.uth.command.CommandListener;

public class REMatcher {
    private Map listeners = new HashMap();
    private RE success;
    private RE fail;
    private final CommandEvent failEvent = new CommandEvent(this, Double.NaN);
    private static final boolean debug = System.getProperty("debug") != null;

    public REMatcher(String successPattern, String failPattern) throws REException {
        this.success = new RE(successPattern);
        this.fail = failPattern == null ? null : new RE(failPattern);
    }

    void process(String line) {
        REMatch match;
        if (debug) {
            System.out.println("Trying " + this.success.toString());
        }
        if (this.fail != null && (match = this.fail.getMatch(line)) != null) {
            this.fireCommandEvent(line, null);
        }
        if ((match = this.success.getMatch(line)) != null) {
            this.fireCommandEvent(line, match);
        }
    }

    public synchronized void addCommandListener(CommandListener pl, int index) {
        this.listeners.put(pl, new Integer(index));
    }

    public synchronized void removeCommandListener(CommandListener pl) {
        this.listeners.remove(pl);
    }

    protected synchronized void fireCommandEvent(String line, REMatch match) {
        Iterator i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            double val;
            Map.Entry entry = i.next();
            CommandListener cl = (CommandListener)entry.getKey();
            if (match == null) {
                cl.match(this.failEvent);
                continue;
            }
            int index = ((Number)entry.getValue()).intValue();
            String value = line.substring(match.getSubStartIndex(index), match.getSubEndIndex(index));
            if (debug) {
                System.out.println("Match: (" + index + ")=" + value);
            }
            if (value.startsWith("=")) {
                value = value.substring(1);
            }
            if (value.startsWith("<")) {
                value = value.substring(1);
            }
            try {
                val = Double.parseDouble(value);
            }
            catch (Throwable t) {
                val = Double.NaN;
            }
            CommandEvent ce = new CommandEvent(this, val);
            cl.match(ce);
        }
    }
}

