/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.uth.command;

import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;
import java.awt.Color;
import java.util.Observable;
import org.freehep.uth.command.CommandEvent;
import org.freehep.uth.command.CommandListener;

public class CommandDataSource
extends Observable
implements Rebinnable1DHistogramData,
HasStyle,
CommandListener,
Runnable {
    private static HistogramUpdate hdr;
    private int bins;
    private int range;
    private String title;
    private Color color;
    private double[] data;
    private boolean delta;
    private int symbol;
    private int size;
    private boolean line;
    private double oldValue = Double.NaN;
    private double nextValue = Double.NaN;
    private boolean timeAxis;
    private double now = 0.0;

    public CommandDataSource(boolean timeAxis, int bins, int range, String title, Color color, boolean delta, int symbol, int size, boolean line) {
        this.timeAxis = timeAxis;
        this.delta = delta;
        this.bins = bins;
        this.range = range;
        this.title = title;
        this.color = color;
        this.symbol = symbol;
        this.size = size;
        this.line = line;
        this.data = new double[bins];
        int i = 0;
        while (i < bins) {
            this.data[i] = Double.NaN;
            ++i;
        }
        if (timeAxis) {
            this.now = (double)System.currentTimeMillis() / 1000.0;
        }
        int stat = 2;
        if (timeAxis) {
            stat += 4;
        }
        hdr = new HistogramUpdate(stat, true);
    }

    public synchronized double[][] rebin(int nbin, double min, double max, boolean wantErrors, boolean hurry) {
        double[][] result = new double[][]{this.data};
        return result;
    }

    public double getMin() {
        return this.now - (double)this.range;
    }

    public double getMax() {
        return this.now;
    }

    public int getBins() {
        return this.bins;
    }

    public boolean isRebinnable() {
        return false;
    }

    public int getAxisType() {
        return this.timeAxis ? 3 : 4;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public Statistics getStatistics() {
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public JASHistStyle getStyle() {
        JASHist1DHistogramStyle style = new JASHist1DHistogramStyle();
        style.setShowErrorBars(false);
        style.setShowDataPoints(this.symbol >= -1);
        style.setShowLinesBetweenPoints(this.line);
        style.setShowHistogramBars(false);
        if (this.color != null) {
            style.setDataPointColor(this.color);
            style.setLineColor(this.color);
        }
        if (this.symbol >= 0) {
            style.setDataPointStyle(this.symbol);
        }
        if (this.size >= 0) {
            style.setDataPointSize(this.size);
        }
        return style;
    }

    public synchronized void match(CommandEvent e) {
        double value = e.getValue();
        if (this.delta) {
            this.nextValue += value - this.oldValue;
            this.oldValue = value;
        } else {
            this.nextValue = value;
        }
    }

    public synchronized void run() {
        System.arraycopy(this.data, 1, this.data, 0, this.bins - 1);
        this.data[this.bins - 1] = this.nextValue;
        double d = this.nextValue = this.delta ? 0.0 : Double.NaN;
        if (this.timeAxis) {
            this.now = (double)System.currentTimeMillis() / 1000.0;
        }
        this.setChanged();
        this.notifyObservers(hdr);
    }
}

