/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.uth;

import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHistAxis;
import jas.plot.Legend;
import jas.util.ColorConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.freehep.uth.command.Command;
import org.freehep.uth.command.CommandDataSource;
import org.freehep.uth.command.REMatcher;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class Plotter
extends JASHist {
    private List commands = new ArrayList();
    static /* synthetic */ Class class$org$freehep$uth$Plotter;

    public void init(Element root) throws Exception {
        this.setAllowUserInteraction(false);
        Element title = root.getChild("title");
        if (title != null) {
            this.setTitle(title.getText());
        }
        List labels = root.getChildren("label");
        Iterator i = labels.iterator();
        while (i.hasNext()) {
            Element label = (Element)i.next();
            String axis = label.getAttributeValue("axis");
            if (axis == null) continue;
            JASHistAxis a = axis.equalsIgnoreCase("y") ? this.getYAxis() : this.getXAxis();
            a.setLabel(label.getText());
        }
        final ArrayList<CommandDataSource> sources = new ArrayList<CommandDataSource>();
        boolean timeAxis = false;
        int bins = 60;
        int range = 60;
        List axes = root.getChildren("axis");
        Iterator i2 = axes.iterator();
        while (i2.hasNext()) {
            Element axis = (Element)i2.next();
            String pos = axis.getAttributeValue("position");
            boolean xAxis = pos.equalsIgnoreCase("x");
            if (!xAxis) continue;
            timeAxis = Plotter.booleanValue(axis, "showTime", false);
            bins = Plotter.intValue(axis, "bins", 60);
            range = Plotter.intValue(axis, "range", bins);
        }
        List commands = root.getChildren("command");
        Iterator i3 = commands.iterator();
        while (i3.hasNext()) {
            Element element = (Element)i3.next();
            String cmd = element.getAttributeValue("command");
            Command command = new Command(cmd);
            this.addCommand(command);
            Iterator j = element.getChildren("re").iterator();
            while (j.hasNext()) {
                Element reElement = (Element)j.next();
                String success = reElement.getAttributeValue("match");
                String fail = reElement.getAttributeValue("fail");
                REMatcher matcher = new REMatcher(success, fail);
                Iterator k = reElement.getChildren("data").iterator();
                while (k.hasNext()) {
                    Element dataElement = (Element)k.next();
                    Color color = Plotter.colorValue(dataElement, "color");
                    int symbol = Plotter.symbolValue(dataElement, "symbol");
                    boolean line = Plotter.booleanValue(dataElement, "line", true);
                    int size = Plotter.intValue(dataElement, "size", -1);
                    boolean delta = Plotter.booleanValue(dataElement, "delta");
                    int value = Plotter.intValue(dataElement, "value", 1);
                    String lTitle = cmd;
                    Element legend = dataElement.getChild("legend");
                    if (legend != null) {
                        lTitle = legend.getText();
                    }
                    CommandDataSource ds = new CommandDataSource(timeAxis, bins, range, lTitle, color, delta, symbol, size, line);
                    matcher.addCommandListener(ds, value);
                    this.addMatcher(matcher, lTitle, dataElement);
                    this.addData((DataSource)ds).show(true);
                    sources.add(ds);
                }
                command.add(matcher);
            }
            command.start();
        }
        axes = root.getChildren("axis");
        Iterator i4 = axes.iterator();
        while (i4.hasNext()) {
            String max;
            JASHistAxis a;
            Element axis = (Element)i4.next();
            String pos = axis.getAttributeValue("position");
            boolean yAxis = pos.equalsIgnoreCase("y");
            JASHistAxis jASHistAxis = a = pos == null || yAxis ? this.getYAxis() : this.getXAxis();
            if (!yAxis) continue;
            String min = axis.getAttributeValue("min");
            if (min != null) {
                a.setMin(Double.parseDouble(min));
            }
            if ((max = axis.getAttributeValue("max")) != null) {
                a.setMax(Double.parseDouble(max));
            }
            a.setLogarithmic(Plotter.booleanValue(axis, "logarithmic", false));
            a.setAllowSuppressedZero(!Plotter.booleanValue(axis, "forceZero", false));
        }
        TimerTask tt = new TimerTask(){

            public void run() {
                Iterator i = sources.iterator();
                while (i.hasNext()) {
                    Runnable r = (Runnable)i.next();
                    r.run();
                }
            }
        };
        Timer timer = new Timer();
        long period = 1000 * range / bins;
        timer.scheduleAtFixedRate(tt, 0L, period);
    }

    protected void addMatcher(REMatcher matcher, String label, Element node) {
    }

    protected void addCommand(Command command) {
        this.commands.add(command);
    }

    public static void main(String[] args) throws Exception {
        String file = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-d")) {
                System.getProperties().setProperty("debug", "true");
            } else if (file != null) {
                Plotter.usage();
            } else {
                file = args[i];
            }
            ++i;
        }
        if (file == null) {
            Plotter.usage();
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(new File(file));
        Element root = doc.getRootElement();
        int x = Plotter.relValue(root, "x", 10);
        int y = Plotter.relValue(root, "y", 10);
        int width = Plotter.relValue(root, "width", 400);
        int height = Plotter.relValue(root, "height", 200);
        String title = root.getAttributeValue("title");
        String showLegend = root.getAttributeValue("showLegend");
        int show = 1;
        if (showLegend != null) {
            if (showLegend.equalsIgnoreCase("true")) {
                show = 2;
            }
            if (showLegend.equalsIgnoreCase("false")) {
                show = 0;
            }
        }
        if (title == null) {
            title = "UTHPlotter";
        }
        Plotter plot = new Plotter();
        plot.init(root);
        Color fg = Plotter.colorValue(root, "foreground");
        Color bg = Plotter.colorValue(root, "background");
        if (fg != null) {
            ((JComponent)((Object)plot)).setForeground(fg);
        }
        Legend legend = plot.getLegend();
        legend.setBorder(BorderFactory.createEtchedBorder());
        if (fg != null) {
            legend.setForeground(fg);
        }
        plot.setShowLegend(show);
        JFrame frame = new JFrame(title);
        Container c = frame.getContentPane();
        if (bg != null) {
            c.setBackground(bg);
        }
        c.add((Component)((Object)plot));
        c.add((Component)legend, "East");
        ((Component)frame).setBounds(x, y, width, height);
        frame.setDefaultCloseOperation(3);
        frame.show();
    }

    private static void usage() {
        System.out.println("Usage: java " + (class$org$freehep$uth$Plotter == null ? (class$org$freehep$uth$Plotter = Plotter.class$("org.freehep.uth.Plotter")) : class$org$freehep$uth$Plotter).getName() + " [-d] <xml file>");
        System.exit(1);
    }

    public static int relValue(Element node, String name, int defValue) {
        try {
            String val = node.getAttributeValue(name);
            if (val == null) {
                return defValue;
            }
            if (val.endsWith("%")) {
                double pc = Double.parseDouble(val.substring(0, val.length() - 1));
                Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
                pc = name.equalsIgnoreCase("y") || name.equalsIgnoreCase("height") ? (pc *= (double)size.height) : (pc *= (double)size.width);
                return (int)(pc / 100.0);
            }
            return Integer.parseInt(val);
        }
        catch (Throwable t) {
            return defValue;
        }
    }

    public static int intValue(Element node, String name, int defValue) {
        try {
            return Integer.parseInt(node.getAttributeValue(name));
        }
        catch (Throwable t) {
            return defValue;
        }
    }

    public static double doubleValue(Element node, String name, double defValue) {
        try {
            return Double.parseDouble(node.getAttributeValue(name));
        }
        catch (Throwable t) {
            return defValue;
        }
    }

    public static boolean booleanValue(Element node, String name, boolean defValue) {
        String val = node.getAttributeValue(name);
        if (val == null) {
            return defValue;
        }
        return !val.equalsIgnoreCase("false");
    }

    public static Color colorValue(Element node, String name) {
        try {
            return ColorConverter.stringToHTMLColor((String)node.getAttributeValue(name));
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean booleanValue(Element node, String name) {
        String result = node.getAttributeValue(name);
        return result != null && result.equalsIgnoreCase("true");
    }

    public static int symbolValue(Element node, String name) {
        String s = node.getAttributeValue(name);
        if (s == null) {
            return -1;
        }
        if (s.equalsIgnoreCase("none")) {
            return -2;
        }
        if (s.equalsIgnoreCase("box")) {
            return 1;
        }
        if (s.equalsIgnoreCase("circle")) {
            return 8;
        }
        if (s.equalsIgnoreCase("cross")) {
            return 7;
        }
        if (s.equalsIgnoreCase("diamond")) {
            return 3;
        }
        if (s.equalsIgnoreCase("dot")) {
            return 0;
        }
        if (s.equalsIgnoreCase("horiz line")) {
            return 6;
        }
        if (s.equalsIgnoreCase("square")) {
            return 9;
        }
        if (s.equalsIgnoreCase("star")) {
            return 4;
        }
        if (s.equalsIgnoreCase("triangle")) {
            return 2;
        }
        if (s.equalsIgnoreCase("vert line")) {
            return 5;
        }
        throw new IllegalArgumentException("Unrecognized symbol " + name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        public void run() {
            Iterator i = Plotter.this.commands.iterator();
            while (i.hasNext()) {
                Command cmd = (Command)i.next();
                cmd.stop();
            }
        }
    }
}

