/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;
import gnu.regexp.RETokenChar;
import java.util.Vector;

class RETokenOneOf
extends REToken {
    private Vector options;
    private boolean negative;

    RETokenOneOf(int f_subIndex, String f_options, boolean f_negative, boolean f_insens) {
        super(f_subIndex);
        this.options = new Vector();
        this.negative = f_negative;
        int i = 0;
        while (i < f_options.length()) {
            this.options.addElement(new RETokenChar(f_subIndex, f_options.charAt(i), f_insens));
            ++i;
        }
    }

    RETokenOneOf(int f_subIndex, Vector f_options, boolean f_negative) {
        super(f_subIndex);
        this.options = f_options;
        this.negative = f_negative;
    }

    int getMinimumLength() {
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.options.size()) {
            int x = ((REToken)this.options.elementAt(i)).getMinimumLength();
            if (x < min) {
                min = x;
            }
            ++i;
        }
        return min;
    }

    int[] match(CharIndexed input, int index, int eflags, REMatch mymatch) {
        int[] newIndex;
        if (this.negative && input.charAt(index) == '\uffff') {
            return null;
        }
        int[] possibles = new int[]{};
        int i = 0;
        while (i < this.options.size()) {
            REToken tk = (REToken)this.options.elementAt(i);
            newIndex = tk.match(input, index, eflags, mymatch);
            if (newIndex == null && tk instanceof RE && tk.m_subIndex > 0) {
                mymatch.reset(tk.m_subIndex + 1);
            }
            if (newIndex != null) {
                if (this.negative) {
                    return null;
                }
                int[] temp = new int[possibles.length + newIndex.length];
                System.arraycopy(possibles, 0, temp, 0, possibles.length);
                int j = 0;
                while (j < newIndex.length) {
                    temp[possibles.length + j] = newIndex[j];
                    ++j;
                }
                possibles = temp;
            }
            ++i;
        }
        int[] doables = new int[]{};
        int i2 = 0;
        while (i2 < possibles.length) {
            newIndex = this.next(input, possibles[i2], eflags, mymatch);
            if (newIndex != null) {
                int[] temp = new int[doables.length + newIndex.length];
                System.arraycopy(doables, 0, temp, 0, doables.length);
                int j = 0;
                while (j < newIndex.length) {
                    temp[doables.length + j] = newIndex[j];
                    ++j;
                }
                doables = temp;
            } else if (this.m_subIndex > 0) {
                mymatch.reset(this.m_subIndex + 1);
            }
            ++i2;
        }
        if (doables.length > 0) {
            if (this.negative) {
                return null;
            }
            return doables;
        }
        if (this.negative) {
            return this.next(input, index + 1, eflags, mymatch);
        }
        return null;
    }

    void dump(StringBuffer os) {
        os.append(!this.negative ? "(?:" : "[^");
        int i = 0;
        while (i < this.options.size()) {
            if (!this.negative && i > 0) {
                os.append('|');
            }
            ((REToken)this.options.elementAt(i)).dumpAll(os);
            ++i;
        }
        os.append(!this.negative ? (char)')' : ']');
    }

    boolean chain(REToken f_next) {
        super.chain(f_next);
        int i = 0;
        while (i < this.options.size()) {
            ((REToken)this.options.elementAt(i)).setUncle(f_next);
            ++i;
        }
        return true;
    }
}

