/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class CharIndexedInputStream
implements CharIndexed {
    private static final int BUFFER_INCREMENT = 1024;
    private BufferedInputStream br;
    private int m_index;
    private int m_end;
    private int m_bufsize;
    private char cached;

    CharIndexedInputStream(InputStream str, int index) {
        this.br = str instanceof BufferedInputStream ? (BufferedInputStream)str : new BufferedInputStream(str, 1024);
        this.m_bufsize = 1024;
        this.m_index = -1;
        this.m_end = Integer.MAX_VALUE;
        this.next();
        if (index > 0) {
            this.move(index);
        }
    }

    private boolean next() {
        if (this.m_end == 1) {
            return false;
        }
        --this.m_end;
        try {
            if (this.m_index != -1) {
                this.br.reset();
            }
            int i = this.br.read();
            this.br.mark(this.m_bufsize);
            if (i == -1) {
                this.m_end = 1;
                this.cached = (char)65535;
                return false;
            }
            this.cached = (char)i;
            this.m_index = 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.cached = (char)65535;
            return false;
        }
        return true;
    }

    public char charAt(int index) {
        if (index == 0) {
            return this.cached;
        }
        if (index >= this.m_end) {
            return '\uffff';
        }
        if (index >= this.m_bufsize) {
            try {
                while (this.m_bufsize <= index) {
                    this.m_bufsize += 1024;
                }
                this.br.reset();
                this.br.mark(this.m_bufsize);
                this.br.skip(index - 1);
            }
            catch (IOException iOException) {}
        } else if (this.m_index != index) {
            try {
                this.br.reset();
                this.br.skip(index - 1);
            }
            catch (IOException iOException) {}
        }
        char ch = '\uffff';
        try {
            int i = this.br.read();
            this.m_index = index + 1;
            if (i == -1) {
                this.m_end = index;
                return ch;
            }
            ch = (char)i;
        }
        catch (IOException iOException) {}
        return ch;
    }

    public boolean move(int index) {
        boolean retval = true;
        while (retval && index-- > 0) {
            retval = this.next();
        }
        return retval;
    }

    public boolean isValid() {
        return this.cached != '\uffff';
    }
}

