/*
 * Decompiled with CFR 0.152.
 */
import jas.plot.Legend;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.freehep.uth.Plotter;
import org.freehep.uth.command.Command;
import org.freehep.uth.command.CommandEvent;
import org.freehep.uth.command.CommandListener;
import org.freehep.uth.command.REMatcher;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class PingWorld
extends JDesktopPane {
    private Image background;
    private List commands = new ArrayList();

    public PingWorld(URL xml) throws Exception {
        int y;
        int x;
        this.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
        ShutdownThread shutdown = new ShutdownThread();
        Runtime.getRuntime().addShutdownHook(shutdown);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(xml);
        Element world = doc.getRootElement();
        final boolean showBorder = Plotter.booleanValue((Element)world, (String)"showBorder", (boolean)true);
        URL image = new URL(world.getAttributeValue("image"));
        if (image != null) {
            this.background = this.getToolkit().createImage(image);
            this.getToolkit().prepareImage(this.background, 1280, 1024, this);
        }
        double opacity = Plotter.doubleValue((Element)world, (String)"opacity", (double)0.75);
        int size = 20;
        Element summary = world.getChild("Summary");
        if (summary != null) {
            size = Plotter.intValue((Element)summary, (String)"iconSize", (int)20);
        }
        final PingTable table = new PingTable(size){

            public void paint(Graphics g) {
                if (!showBorder) {
                    Color c = this.getBackground();
                    g.setColor(c);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                super.paint(g);
            }
        };
        List plots = world.getChildren("UTHPlotter");
        Iterator i = plots.iterator();
        while (i.hasNext()) {
            Element root = (Element)i.next();
            x = Plotter.relValue((Element)root, (String)"x", (int)10);
            y = Plotter.relValue((Element)root, (String)"y", (int)10);
            int width = Plotter.relValue((Element)root, (String)"width", (int)400);
            int height = Plotter.relValue((Element)root, (String)"height", (int)200);
            String title = root.getAttributeValue("title");
            String showLegend = root.getAttributeValue("showLegend");
            int show = 1;
            if (showLegend != null) {
                if (showLegend.equalsIgnoreCase("true")) {
                    show = 2;
                }
                if (showLegend.equalsIgnoreCase("false")) {
                    show = 0;
                }
            }
            if (title == null) {
                title = "UTHPlotter";
            }
            Plotter plot = new Plotter(){

                protected void addMatcher(REMatcher matcher, String label, Element node) {
                    table.addTableEntry(matcher, label);
                    Element labelNode = node.getChild("label");
                    if (labelNode == null) {
                        return;
                    }
                    int x = Plotter.relValue((Element)labelNode, (String)"x", (int)10);
                    int y = Plotter.relValue((Element)labelNode, (String)"y", (int)10);
                    String align = labelNode.getAttributeValue("align");
                    int fontSize = Plotter.intValue((Element)labelNode, (String)"fontSize", (int)20);
                    int iconSize = Plotter.intValue((Element)labelNode, (String)"iconSize", (int)10);
                    Color color = Plotter.colorValue((Element)node, (String)"color");
                    int halign = 0;
                    int valign = 0;
                    if (align == null || align.equalsIgnoreCase("left")) {
                        halign = 4;
                    } else if (align.equalsIgnoreCase("right")) {
                        halign = 2;
                    } else if (align.equalsIgnoreCase("top")) {
                        valign = 3;
                    } else if (align.equalsIgnoreCase("bottom")) {
                        valign = 1;
                    }
                    JLabel test = new JLabel(label);
                    test.setIcon(new LegendIcon(iconSize, color));
                    test.setHorizontalTextPosition(halign);
                    test.setVerticalTextPosition(valign);
                    test.setFont(new Font("dialog", 1, fontSize));
                    PingWorld.this.add(test);
                    Dimension ls = test.getPreferredSize();
                    test.setBounds(x, y, ls.width, ls.height);
                    test.setVisible(true);
                }

                protected void addCommand(Command cmd) {
                    PingWorld.this.commands.add(cmd);
                }
            };
            plot.init(root);
            Color fg = Plotter.colorValue((Element)root, (String)"foreground");
            Color bg = Plotter.colorValue((Element)root, (String)"background");
            if (fg != null) {
                plot.setForeground(fg);
            }
            Legend legend = plot.getLegend();
            legend.setBorder(BorderFactory.createEtchedBorder());
            if (fg != null) {
                legend.setForeground(fg);
            }
            plot.setShowLegend(show);
            JPanel c = new JPanel(new BorderLayout()){

                public void paint(Graphics g) {
                    if (!showBorder) {
                        Color c = this.getBackground();
                        g.setColor(c);
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    super.paint(g);
                }
            };
            if (bg == null) {
                bg = c.getBackground();
            }
            Color translucentBackground = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), (int)(255.0 * opacity));
            c.setBackground(translucentBackground);
            c.add((Component)plot);
            c.add((Component)legend, "East");
            if (!showBorder) {
                plot.setTitle(title);
            }
            this.frameIt(c, title, showBorder, x, y, width, height);
        }
        if (summary != null) {
            String title = summary.getAttributeValue("title");
            if (title == null) {
                title = "Summary";
            }
            x = Plotter.relValue((Element)summary, (String)"x", (int)10);
            y = Plotter.relValue((Element)summary, (String)"y", (int)10);
            Color c = Plotter.colorValue((Element)summary, (String)"background");
            if (c == null) {
                c = Color.white;
            }
            double sopacity = Plotter.doubleValue((Element)summary, (String)"opacity", (double)0.75);
            Color bg = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * sopacity));
            List map = summary.getChildren("ColorMap");
            Iterator i2 = map.iterator();
            while (i2.hasNext()) {
                Element colorMap = (Element)i2.next();
                double value = Plotter.doubleValue((Element)colorMap, (String)"lessThan", (double)Double.NaN);
                Color color = Plotter.colorValue((Element)colorMap, (String)"color");
                table.addColorMap(value, color);
            }
            if (showBorder) {
                JInternalFrame tf = new JInternalFrame(title);
                this.add(tf);
                tf.setContentPane(table);
                table.setBackground(bg);
                tf.setOpaque(false);
                tf.pack();
                tf.setLocation(x, y);
                tf.show();
            } else {
                this.add(table);
                Dimension ts = table.getPreferredSize();
                table.setBackground(bg);
                table.setBorder(BorderFactory.createLineBorder(Color.black));
                table.setBounds(x, y, ts.width + 2, ts.height + 2);
                table.setOpaque(false);
                table.setVisible(true);
            }
        }
    }

    private void frameIt(JComponent c, String title, boolean showBorder, int x, int y, int width, int height) {
        if (showBorder) {
            JInternalFrame frame = new JInternalFrame(title);
            this.add(frame);
            frame.setBounds(x, y, width, height);
            frame.setContentPane(c);
            frame.setOpaque(false);
            frame.show();
        } else {
            this.add(c);
            c.setBorder(BorderFactory.createLineBorder(Color.black));
            c.setBounds(x, y, width, height);
            c.setOpaque(false);
            c.setVisible(true);
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.background != null) {
            g.drawImage(this.background, 0, 0, this.getWidth(), this.getHeight(), null);
        } else {
            super.paintComponent(g);
        }
    }

    public static void main(String[] args) throws Exception {
        boolean fullScreen = args.length > 1 && args[0].equals("-fullScreen");
        URL xml = new URL(args[args.length - 1]);
        PingWorld pw = new PingWorld(xml);
        JFrame frame = new JFrame("Ping World");
        pw.addMouseListener(new PopupListener(new MyMenu()));
        Dimension size = frame.getToolkit().getScreenSize();
        frame.setBounds(0, 0, size.width, size.height);
        frame.setContentPane(pw);
        frame.setDefaultCloseOperation(3);
        if (fullScreen) {
            try {
                GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                frame.setUndecorated(true);
                gd.setFullScreenWindow(frame);
            }
            catch (Throwable t) {
                frame.show();
            }
        } else {
            frame.show();
        }
    }

    private static class PopupListener
    extends MouseAdapter {
        private JPopupMenu menu;

        PopupListener(JPopupMenu menu) {
            this.menu = menu;
        }

        public void mousePressed(MouseEvent me) {
            this.maybePopup(me);
        }

        public void mouseReleased(MouseEvent me) {
            this.maybePopup(me);
        }

        private void maybePopup(MouseEvent me) {
            if (this.menu.isPopupTrigger(me)) {
                this.menu.show(me.getComponent(), me.getX(), me.getY());
            }
        }
    }

    private static class MyMenu
    extends JPopupMenu {
        MyMenu() {
            JMenuItem exit = new JMenuItem(this, "Exit"){
                private final /* synthetic */ MyMenu this$0;
                {
                    this.this$0 = this$0;
                }

                protected void fireActionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            };
            this.add(exit);
        }
    }

    private class LegendIcon
    implements Icon {
        private int size;
        private Color color;

        LegendIcon(int size, Color c) {
            this.size = size;
            this.color = c;
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            graphics.setColor(this.color);
            graphics.fillOval(x, y, this.size, this.size);
        }
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        public void run() {
            System.out.println("shutdown");
            Iterator i = PingWorld.this.commands.iterator();
            while (i.hasNext()) {
                Command cmd = (Command)i.next();
                cmd.stop();
            }
            System.out.println("done");
        }
    }

    private static class PingTable
    extends JPanel {
        private int size;
        private List map = new ArrayList();

        PingTable(int size) {
            super(new GridLayout(0, 1));
            this.size = size;
        }

        void addTableEntry(REMatcher matcher, String title) {
            StatusIcon icon = new StatusIcon(matcher, 10);
            JLabel label = new JLabel(title, icon, 2);
            icon.setLabel(label);
            this.add(label);
        }

        void addColorMap(double value, Color color) {
            this.map.add(new MapEntry(value, color));
        }

        private Color colorMap(double d) {
            int i = 0;
            while (i < this.map.size()) {
                MapEntry me = (MapEntry)this.map.get(i);
                if (Double.isNaN(me.value) || d < me.value) {
                    return me.color;
                }
                ++i;
            }
            return Color.red;
        }

        private class StatusIcon
        implements Icon,
        CommandListener,
        Runnable {
            private JLabel label;
            private Color currentColor;
            private int size;

            StatusIcon(REMatcher matcher, int size) {
                matcher.addCommandListener((CommandListener)this, 1);
                this.size = size;
            }

            public int getIconWidth() {
                return this.size;
            }

            public int getIconHeight() {
                return this.size;
            }

            public void paintIcon(Component component, Graphics graphics, int x, int y) {
                if (this.currentColor != null) {
                    Color old = graphics.getColor();
                    graphics.setColor(this.currentColor);
                    graphics.fillRect(x, y, this.size, this.size);
                    graphics.setColor(old);
                }
            }

            public void match(CommandEvent e) {
                double curValue = e.getValue();
                Color newColor = PingTable.this.colorMap(curValue);
                if (newColor != this.currentColor) {
                    this.currentColor = newColor;
                    SwingUtilities.invokeLater(this);
                }
            }

            public void run() {
                if (this.label != null) {
                    this.label.repaint();
                }
            }

            void setLabel(JLabel label) {
                this.label = label;
            }
        }

        private static class MapEntry {
            Color color;
            double value;

            MapEntry(double value, Color color) {
                this.value = value;
                this.color = color;
            }
        }
    }
}

